<%@ include file="/sdk/oemTop.jspf" %>
<%-- ==============  Database Group Page For EM2Go ================

   MODIFIED    (MM/DD/YY)
    xshen       06/17/03 - 
    xshen       05/01/03 - 
    qsong       04/29/03 - Add oemTop.jspf
    xshen       03/27/03 - xshen_em2go_pc-0203
    xshen       03/18/03 - Creation
--%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">  
  <uix:bundle name="bundle"
              class="oracle.sysman.db.rsc.inst.DBGrpMsg"/>
  <uix:bundle name="mntrResourceBundle"
              class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="sdkMessageBundle"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

  <oem:setURLEncoder id="renderingContext"/>

  <%@ include file="/em2go/em2goHrGlobal.jspf" %>

  <uix:document>
    <uix:body>
      <%-- uix:pageLayout --%>  

        <%-- 
        ---- Main Header
        --%>
        <uix:header textBinding="MAIN_HEADER@servletRequest">
        <uix:styledText styleClass="OraHeaderSubSub" textBinding="MAIN_HEADER@servletRequest"/>

          <uix:form name="viewbyForm" method="get" 
                    destination="/console/database/em2go/group">
            <uix:formValue name="target" 
                           valueBinding="target@servletRequest"/> 
            <uix:formValue name="type" 
                           valueBinding="type@servletRequest"/> 
          </uix:form>


                    <%-- 
                    ---- Refresh Time
                    --%>
                		<uix:flowLayout>		
                      <uix:styledText styleClass="OraInlineInfoText" 
                                      textBinding="refreshTime@servletRequest"/>
                      <uix:spacer width="5"/>
                		</uix:flowLayout>

            <uix:tableLayout>
              <uix:rowLayout>
                  <%--
                  ---- % Bottleneck
                  --%>
                  <uix:header textBinding="chartHeader@bottleneckBean@servletRequest">
                  <uix:styledText styleClass="OraHeaderSubSub" 
                          				textBinding="chartHeader@bottleneckBean@servletRequest"/>
                    <oem:chart 
                         chartType="timeSeriesChart"
                         axisMax="100"
                         axisMin="0"
                         width="220"
                         height="175" 
                         orientation="vertical"
                         timeGranularity="MINUTE"
                         legendPosition="south"
                         legendWidthFraction="1.0"
                         shortDescBinding="BOTTLENECK_CHART_DESC@bundle"
                         seriesColorsAutomatic="true">
                      <oem:boundChartDataSource 
                           chartDataSourceBinding="chartSource@bottleneckBean@servletRequest"/>
                      <oem:chartColumn                                   
                        isKey="true" 
                        displayLabel="Databases"
                        sourceIndex="0"/>
                      <oem:chartColumn
                        isTimeColumn="true"
                        displayLabel="Time"
                        sourceIndex="1"/>
                      <oem:chartColumn                                   
                        displayLabel=""
                        sourceIndex="2"
                        itemColor="red"/>
                      <oem:imageMap imageMapDataSourceBinding="imageMapSource@bottleneckBean@servletRequest"/>
                    </oem:chart>
                  </uix:header>
            		</uix:rowLayout>
                <uix:rowLayout>

                  <%--
                  ---- Alert History
                  --%>
                  <uix:header textBinding="chartHeader@alertHist@servletRequest">
                  <uix:styledText styleClass="OraHeaderSubSub" 
                          				textBinding="chartHeader@alertHist@servletRequest"/>
                    <uix:tableLayout>
                      <uix:contents childDataBinding="timelineBeans@alertHist@servletRequest">
                        <uix:rowLayout>
                          <uix:cellFormat wrappingDisabled="true">
                            <uix:link textBinding="shortDbName"
                                      destinationBinding="dbUrl"
                                      shortDescBinding="dbName"/>
                          </uix:cellFormat>
                        </uix:rowLayout>
                        <uix:rowLayout>
                          <uix:cellFormat>
                            <uix:image sourceBinding="imgSrc"
                                       destinationBinding="imgUrl"
                                       shortDescBinding="dbName"
                        				       width="200"/> 
                          </uix:cellFormat>
                          <uix:cellFormat>
                            <uix:image sourceBinding="statusImgSrc"
                                       destinationBinding="statusImgUrl"
                                       shortDescBinding="dbName"/> 
                          </uix:cellFormat>
                        </uix:rowLayout>
                      </uix:contents>
                    </uix:tableLayout>

                    <%--
                    ---- Alert Legend
                    --%>
                    <uix:tableLayout>
                      <uix:rowLayout>

                        <uix:cellFormat wrappingDisabled="true">
                          <uix:spacer width="4"/>
                          <uix:image source="<%= request.getContextPath() + \"/images/database/grp/clearColor.gif\" %>"
                                     width="8" height="8"/>
                          <uix:spacer width="4"/>
                          <uix:styledText styleClass="OraPromptText"
                                          textBinding="SEV_CLEAR@sdkMessageBundle"/>
                        </uix:cellFormat>

                        <uix:cellFormat wrappingDisabled="true">
                          <uix:spacer width="4"/>
                          <uix:image source="<%= request.getContextPath() + \"/images/database/grp/warnColor.gif\" %>"
                                     width="8" height="8"/>
                          <uix:spacer width="4"/>
                          <uix:styledText styleClass="OraPromptText"
                                          textBinding="SEV_WARNING@sdkMessageBundle"/>
                        </uix:cellFormat>

                        <uix:cellFormat wrappingDisabled="true">
                          <uix:spacer width="4"/>
                          <uix:image source="<%= request.getContextPath() + \"/images/database/grp/criticalColor.gif\" %>"
                                     width="8" height="8"/>
                          <uix:spacer width="4"/>
                          <uix:styledText styleClass="OraPromptText"
                                          textBinding="SEV_CRITICAL@sdkMessageBundle"/>
                        </uix:cellFormat>

                      </uix:rowLayout>
                      <uix:rowLayout>

                        <uix:cellFormat wrappingDisabled="true">
                          <uix:spacer width="4"/>
                          <uix:image source="<%= request.getContextPath() + \"/images/database/grp/downColor.gif\" %>"
                                     width="8" height="8"/>
                          <uix:spacer width="4"/>
                          <uix:styledText styleClass="OraPromptText"
                                          textBinding="DOWN@sdkMessageBundle"/>
                        </uix:cellFormat>

                        <uix:cellFormat wrappingDisabled="true">
                          <uix:spacer width="4"/>
                          <uix:image source="<%= request.getContextPath() + \"/images/database/grp/blackoutColor.gif\" %>"
                                     width="8" height="8"/>
                          <uix:spacer width="4"/>
                          <uix:styledText styleClass="OraPromptText"
                                          textBinding="17@sdkMessageBundle"/>
                                          <%-- no idea why 17 is used
                                          for blackout in sdk bundle
                                          --%>
                        </uix:cellFormat>

                        <uix:cellFormat wrappingDisabled="true">
                          <uix:spacer width="4"/>
                          <uix:image source="<%= request.getContextPath() + \"/images/database/grp/nodataColor.gif\" %>"
                                     width="8" height="8"/>
                          <uix:spacer width="4"/>
                          <uix:styledText styleClass="OraPromptText"
                                          text="No Data"/>
                        </uix:cellFormat>

                      </uix:rowLayout>
                    </uix:tableLayout>

                  </uix:header>

              </uix:rowLayout>
            </uix:tableLayout>

          <%@ include file="detailTable.jspf"%>
        </uix:header>

      <%-- /uix:pageLayout --%>
    </uix:body>
  </uix:document>
  <%@ include file="/em2go/em2goThinFooter.jspf" %> 
</uix:renderingContext>

