<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
<%@ include file="/em2go/em2goHrGlobal.jspf" %>
  <uix:document>
<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head />
</uix:metaContainer>

<uix:body>
<%@ include file="/em2go/em2goFooter.jspf" %>

          <%-- <uix:pageLayout> --%>
        <db:form name="foo" method="post" destinationBinding="destURL@request"
          copyParams="target,type"> 

        <uix:formValue name="event" />
        
          <uix:contents>
            <uix:header textBinding="database/instance/lock@DBMsgBundle@servletRequest" >
              
             <%@ include file="../refreshTime.jspf" %> 

                <uix:rowLayout>
                    <uix:flowLayout>
                      <oem:messageBox messageType="info" 
                              errorTableBinding="info@servletRequest"/>
                      <uix:styledText styleClass="OraInstructionText"
                                      textBinding="VIEW_DETAIL@DBMsgBundle@servletRequest" />
                      <uix:choice name="viewBy" selectedValueBinding="viewBy@lockBeanEm2go@servletRequest">
                        <uix:option textBinding="BLOCKING_LOCKS@DBMsgBundle@servletRequest"
                                    value="blockingLocks"/>
                        <uix:option textBinding="USER_LOCKS@DBMsgBundle@servletRequest"
                                    value="userLocks" />
                        <uix:option textBinding="ALL_LOCKS@DBMsgBundle@servletRequest"
                                    value="allLocks" />
                      </uix:choice>
                      <uix:submitButton name="event" value="switch" textBinding="GO@DBMsgBundle@servletRequest"/>
                    </uix:flowLayout>
                </uix:rowLayout>
              
              <oem:table name="twoDUIDataSource" 
                     beanKey="lockBeanEm2go"
                     formSubmitted="true"
                     dataSourceProp="topLocksEm2goDataSource" width="100%"
                     destination="/console/database/em2go/instance/dblocks"
                     alternateTextBinding="NO_LOCKS@DBMsgBundle@servletRequest"
                     blockSize="25" 
                     partialRenderMode="self">
              </oem:table>

              <uix:cellFormat hAlign="left" wrappingDisabled="true">
                <uix:rowLayout>
                  <uix:image sourceBinding="tipImage@servletRequest" />
                  <uix:styledText styleClass="OraInlineInfoText" 
                                  textBinding="TIP@DBMsgBundle@servletRequest"/>
                  <uix:spacer width="5" />  
                  <uix:styledText styleClass="OraInlineInfoText" 
                                  textBinding="LOCK_TIP@DBMsgBundle@servletRequest"/>
                </uix:rowLayout>
              </uix:cellFormat>

<%-- no blocking session functionality in em2go
              <uix:switcher childNameBinding="is10iOrHigher@lockBeanEm2go@servletRequest">
                <uix:case name="true">
                  <uix:header textBinding="RELATED_LINKS@DBMsgBundle@servletRequest">
                    <uix:tableLayout width="100%" cellSpacing="2">   
                      <uix:rowLayout>     
                        <uix:stackLayout>
                          <uix:link textBinding="BLOCKING_SESS_HEADER@DBMsgBundle@servletRequest"
                                    destinationBinding="blockingSessDest@servletRequest" />
                        </uix:stackLayout>
                      </uix:rowLayout>   
                    </uix:tableLayout>
                  </uix:header>
                </uix:case>
              </uix:switcher>
              
--%>
            </uix:header>
          </uix:contents>

        </db:form>
  </uix:body>
</uix:document>
 <%@ include file="/em2go/em2goThinFooter.jspf" %>
</uix:renderingContext> 
