<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 

    <%-- only need refresh if automatic refresh selected and not using SVG --%> 
    <uix:switcher childNameBinding="manualSelected@servletRequest">
      <uix:case name="false">
        <uix:rawText renderedBinding="notUseSVG@defaultBean@servletRequest">
          <meta http-equiv="Refresh" content="<%=request.getAttribute("refreshChoiceGIF") %>" >
        </uix:rawText> 
      </uix:case>  
    </uix:switcher>

    <%@ include file="/em2go/em2goHrGlobal.jspf" %>

  <uix:document> 
    <uix:body>   

    <%-- uix:pageLayout --%>
      
    <db:form name="foo" method="get" destination="/console/database/em2go/instance/sitemap"
       copyParams="target,type">
    <uix:formValue name="event"/>
    <uix:formValue name="pageNum" />
    <uix:formValue name="mode" valueBinding="mode@servletRequest"/>
    <uix:formValue name="instanceVersion" valueBinding="instanceVersion@servletRequest"/>
    <uix:formValue name="rateType" />

	<%--................ Breadcrumbs  ................--%>
	 <uix:flowLayout>
	  <uix:contents>
	    <uix:styledText styleClass="OraPromptText" 
				textBinding="bc1Str@servletRequest" 
				destinationBinding="bc1Dest@servletRequest"/>
	    <%-- uix:styledText styleClass="OraPromptText" text=" > Performance" / --%>
	  </uix:contents>
	 </uix:flowLayout>

<uix:tableLayout>
  <uix:contents>

    <uix:rowLayout>
      <uix:contents>
        <uix:styledText styleClass="OraHeaderSubSub" textBinding="HOST@DBMsgBundle@servletRequest"/>
      </uix:contents>
    </uix:rowLayout>
    <uix:rowLayout>
      <uix:contents>
         <%@ include file="/database/em2go/instance/sitemap/runqueue.jspf" %>
      </uix:contents>
    </uix:rowLayout>
<%--
    <uix:rowLayout>
      <uix:contents>
         <uix:styledText styleClass="OraHeaderSubSub" textBinding="PAGING_RATE@DBMsgBundle@servletRequest"/> 
      </uix:contents>
    </uix:rowLayout>
    <uix:rowLayout>
      <uix:contents>
         <%@ include file="/database/em2go/instance/sitemap/paging.jspf" %>
      </uix:contents>
    </uix:rowLayout>
--%>
    <uix:rowLayout>
      <uix:contents>
          <uix:styledText styleClass="OraHeaderSubSub" textBinding="AVERAGE_ACTIVE_SESSIONS@DBMsgBundle@servletRequest"/> 
      </uix:contents>
    </uix:rowLayout>

	<uix:rowLayout>
          <uix:contents>
                <oem:chart 
                    chartType="timeSeriesChart"
                    width="200"
                    height="100"
                    timeGranularity="SECOND"
                    orientation="vertical"
                    fill="cumulative"
                    yAxisLabelBinding="ACTIVE_SESSIONS@DBMsgBundle@servletRequest" 
                    legendVisible="external"
                    externalLegendOrientation="2"
              	    legendPosition="south"
                    titleBinding="SERVICE_TIME@DBMsgBundle@servletRequest"
                    titleVisible="false"    
                    pdaDisplay="true"
	            colorPaletteBinding="waitsColorTable@waitsChart@defaultBean@servletRequest"
        	    yAxisNumberFormatBinding="oneDecimalChartFormat@defaultBean@servletRequest"
           	    axisMaxBinding="waitsChartGIFMaxValue@defaultBean@servletRequest"

                >
                  <uix:contents>
                    <oem:boundChartDataSource 
                      chartDataSourceBinding="waitsChartGIF@defaultBean@servletRequest"/>
                    <oem:imageMap imageMapDataSourceBinding="waitsImageDataSource@servletRequest"/>                     
                    <oem:chartColumn                                   
                        isKey="true" 
                        displayLabel=""
                        sourceIndex="0" />
                    <oem:chartColumn
                        isTimeColumn="true"
                        displayLabel="Time"
                        sourceIndex="1"  />
                    <oem:chartColumn                                   
                        displayLabel=""
                        sourceIndex="2" />
                  </uix:contents>
                </oem:chart>
    </uix:contents>
  </uix:rowLayout>
            
  <uix:rowLayout>
    <uix:contents>
      <uix:styledText styleClass="OraHeaderSubSub" textBinding="THROUGHPUT@DBMsgBundle@servletRequest"/>
    </uix:contents>
  </uix:rowLayout>

  <uix:rowLayout>  
    <uix:contents>
                <oem:chart 
                    chartType="timeSeriesChart"
                    width="200"
                    height="100"
                    timeGranularity="SECOND"
                    orientation="vertical"
                    legendVisible="external"
                    externalLegendOrientation="2"
                    legendPosition="south" 
                    fill="none"
                    titleBinding="THROUGHTPUT@DBMsgBundle@servletRequest"
                    titleVisible="false"                       
                    yAxisLabelBinding="sysstatChartYAxisLabel@defaultBean@servletRequest"
                    pdaDisplay="true"
                >
                  <uix:contents>
                    <oem:boundChartDataSource 
                      chartDataSourceBinding="sysstatChartGIF@defaultBean@servletRequest"/>
                    <oem:imageMap imageMapDataSourceBinding="systatImageDataSource@servletRequest"/>
                    <oem:chartColumn                                   
                        isKey="true" 
                        displayLabel=""
                        sourceIndex="0" />
                    <oem:chartColumn
                        isTimeColumn="true"
                        displayLabel="Time"
                        sourceIndex="1"  />
                    <oem:chartColumn                                   
                        displayLabel=""
                        sourceIndex="2" />
                  </uix:contents>
                </oem:chart>
      </uix:contents>
    </uix:rowLayout>

    <uix:rowLayout>  
      <uix:contents>
                <oem:chart 
                    chartType="timeSeriesChart"
                    width="200"
                    height="100"
                    timeGranularity="SECOND"
                    orientation="vertical"
                    legendVisible="external"
                    externalLegendOrientation="2"
                    legendPosition="south" 
                    fill="none"
                    titleBinding="BLOCKS@DBMsgBundle@servletRequest"
                    titleVisible="false"                       
                    yAxisLabelBinding="sysstatBlocksChartYAxisLabel@defaultBean@servletRequest"
                    pdaDisplay="true"
                >
                  <uix:contents>
                    <oem:boundChartDataSource 
                      chartDataSourceBinding="sysstatBlocksChartGIF@defaultBean@servletRequest"/>
                    <oem:imageMap imageMapDataSourceBinding="systatBlocksImageDataSource@servletRequest"/>
                    <oem:chartColumn                                   
                        isKey="true" 
                        displayLabel=""
                        sourceIndex="0" />
                    <oem:chartColumn
                        isTimeColumn="true"
                        displayLabel="Time"
                        sourceIndex="1"  />
                    <oem:chartColumn                                   
                        displayLabel=""
                        sourceIndex="2" />
                  </uix:contents>
                </oem:chart>
      </uix:contents>
    </uix:rowLayout>
  </uix:contents>
</uix:tableLayout>

    </db:form>

   <%-- /uix:pageLayout --%>
   </uix:body>
  </uix:document> 
    <%@ include file="/em2go/em2goThinFooter.jspf" %> 
</uix:renderingContext> 





        
