<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="SmapResourceBundle"
              class="oracle.sysman.db.rsc.inst.DBMsg"/>
  <uix:bundle name="HDMMsg"
	    class="oracle.sysman.db.rsc.inst.HDMMsg"/>
  <%@ include file="/em2go/em2goHrGlobal.jspf" %>
  <uix:document>
    <uix:body>
    <%-- uix:pageLayout --%>

    <uix:switcher childNameBinding="stateChange@servletRequest">
      <uix:case name="true">
        <oem:messageBox messageTypeBinding="stateChangeMessageType@servletRequest"
	      errorTableBinding="msgBox@servletRequest"
                             destTableBinding="msgUrls@servletRequest"/>
        <uix:styledText styleClass="OraInlineInfoText" textBinding="mainText@msgBox@servletRequest"/>
      </uix:case>
    </uix:switcher>

    <uix:flowLayout>
      <uix:switcher childNameBinding="stateChange@servletRequest">
        <uix:case name="true">
          <uix:link styleClass="OraInlineInfoText" destinationBinding="viewDetailsDest@servletRequest" text="View Details"/>
   
        </uix:case>
      </uix:switcher>
    </uix:flowLayout>

     <uix:flowLayout>
       <oem:messageBox messageType="info" 
                       errorTableBinding="info@servletRequest"/>
       <uix:styledText styleClass="OraInlineInfoText" textBinding="mainText@info@servletRequest"/>
     </uix:flowLayout>
     <uix:flowLayout>
       <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"/>
       <uix:styledText styleClass="OraInlineErrorText" textBinding="mainText@errors@servletRequest"/>
     </uix:flowLayout>     
             
    <db:form name="foo" method="POST" destination="/console/database/em2go/instance/sitemap"
			copyParams="target,type,cancelURL" >

    <%-- Sitemap Header --%>
    <uix:styledText styleClass="OraHeaderSubSub" textBinding="header@defaultBean@servletRequest"/>

                <!-- ...................  General Section .................. -->
                        <uix:tableLayout>
			 <uix:contents>
<%--                            <uix:rowLayout>
			     <uix:contents>
                              <uix:cellFormat hAlign="right" wrappingDisabled="true">
				<uix:contents>
                                  <uix:styledText styleClass="OraPromptText"
                                    text="Database" />			    
			       </uix:contents>
                              </uix:cellFormat>
			     <uix:spacer width="4"/>
			     <uix:stackLayout>
   			      <uix:contents>
                              <uix:styledText styleClass="OraDataText"
                                textBinding="targetName@defaultBean@servletRequest"/>
			      </uix:contents>
			     </uix:stackLayout>
			     </uix:contents>
                            </uix:rowLayout>
--%>

                         <uix:rowLayout>
			     <uix:contents>
                              <uix:cellFormat hAlign="right" wrappingDisabled="true">
			       <uix:contents>
                                  <uix:styledText styleClass="OraPromptText"
                                    text="Status"/>
			       </uix:contents>
                              </uix:cellFormat>
			     <uix:spacer width="4"/>
			     <uix:stackLayout>
			      <uix:contents>
				<uix:flowLayout>
				<uix:contents>
                                <uix:styledText styleClass="OraFieldText"
                                  textBinding="trafficStatusStr@defaultBean@servletRequest"
				  destinationBinding="availDest@servletRequest"/>
			     <uix:spacer width="6"/>
                                <uix:button textBinding="changeStateButtonLabel@servletRequest" 
                                  destinationBinding="changeStateUrl@servletRequest"/>
				</uix:contents>
				</uix:flowLayout>
  			      </uix:contents>
                             </uix:stackLayout>
			   </uix:contents>
                         </uix:rowLayout>

          <uix:rowLayout renderedBinding="showNormal@defaultBean@servletRequest">
			     <uix:contents>
             <uix:cellFormat hAlign="right" wrappingDisabled="true">
            	<uix:contents>
                  <uix:styledText styleClass="OraPromptText"
                                    textBinding="HOST@DBMsgBundle@servletRequest" />
              </uix:contents>
             </uix:cellFormat>
            <uix:spacer width="4"/>
			      <uix:stackLayout>
      				<uix:contents>
                  <uix:link destinationBinding="hostDest@servletRequest"
                                textBinding="hostDetailsLinkLabel@defaultBean@servletRequest"/>	
            	</uix:contents>
			      </uix:stackLayout>
			     </uix:contents>
          </uix:rowLayout>

	  <!--... Listener Sitemap intg not done in Centrol mode in regular EM ...-->
          <%-- uix:rowLayout renderedBinding="showNormal@defaultBean@servletRequest">
  		     <uix:contents>
              <uix:cellFormat hAlign="right" wrappingDisabled="true">
      		<uix:contents>
               <uix:styledText styleClass="OraPromptText"
                                    textBinding="LISTENER@DBMsgBundle@servletRequest" />
        	</uix:contents>
          </uix:cellFormat>
	  <uix:spacer width="4"/>

            <uix:link destinationBinding="listenerDest@servletRequest"
                 textBinding="listenerName@defaultBean@servletRequest"/>
			   
	   </uix:contents>
          </uix:rowLayout --%>

			    <!--... Oracle Storage Manager: combined 2 renderedbinding into 1 ...-->
                            <!--... Disabled from Beta2 ...-->
<%--
			    <uix:rowLayout renderedBinding="showOsmUsage@defaultBean@servletRequest">
			     <uix:contents>
			       <uix:cellFormat hAlign="right" wrappingDisabled="true">
				<uix:contents>
                                <uix:styledText styleClass="OraPromptText"
                                    	        textBinding="OSM_USAGE@DBMsgBundle@servletRequest" />
				</uix:contents>
			       </uix:cellFormat>
			     <uix:spacer width="4"/>
				<uix:stackLayout>
				 <uix:contents>
                               <uix:link textBinding="osmTargetName@defaultBean@servletRequest"
                                	 destinationBinding="osmUsageLink@servletRequest" />
				</uix:contents>
				</uix:stackLayout>
			     </uix:contents>
			    </uix:rowLayout>
--%>               

	     </uix:contents>
            </uix:tableLayout>

                      <!--  end of table of General info  -->

              <uix:rowLayout>
		<uix:contents>
	          <uix:styledText styleClass="OraHeaderSubSub" text="Links" />
		</uix:contents>
	      </uix:rowLayout>

	      <uix:flowLayout>
		<uix:contents>
                    <uix:choice name="sitemapChoice"
                                selectedValue="altlog">
                      <uix:contents>
                        <uix:option textBinding="ALERT_LOG_CONTENT@SmapResourceBundle" value="altlog" /> 
                        <uix:option textBinding="VIEW_ALL_METRICS@SmapResourceBundle" value="allmcs" /> 
                        <uix:option textBinding="PERFORMANCE_HEADER@SmapResourceBundle" value="perform" /> 
                        <uix:option text="Initialization Parameters" value="initora" /> 
			<uix:option textBinding="EXECUTE_SQL@SmapResourceBundle" value="execSql" />
                        <uix:option textBinding="VIEW_DATABASE_LOCKS@SmapResourceBundle" value="dblock" /> 
                        <uix:option textBinding="VIEW_TOP_SESSIONS@SmapResourceBundle" value="topsess" /> 
                        <uix:option textBinding="VIEW_TOP_SQL@SmapResourceBundle" value="topsql" /> 
                        <uix:option textBinding="DATAFILES@SmapResourceBundle" value="dfs" /> 
			<uix:option textBinding="CONTROLFILES@SmapResourceBundle" value="ctls"/>
                        <uix:option textBinding="TABLESPACES@SmapResourceBundle" value="tbsps" /> 
                        <uix:option textBinding="REDOLOGS@SmapResourceBundle" value="redo" />                     
                        <uix:option textBinding="RB_SEGMENTS@SmapResourceBundle" value="rbs" /> 
                      </uix:contents>
                    </uix:choice>                                    
                    <uix:submitButton name="event"
                                      textBinding="GO@DBMsgBundle@servletRequest"
                                      value="gotoSitemapChoice"/>
		</uix:contents>
              </uix:flowLayout>

  <uix:rowLayout>
    <uix:contents>
      <uix:styledText styleClass="OraHeaderSubSub" 
		      textBinding="ALERTS_HEADER@DBMsgBundle@servletRequest" 
		      renderedBinding="showAlertsTable@defaultBean@servletRequest" />
    </uix:contents>
  </uix:rowLayout>
 
  <uix:tableLayout renderedBinding="showAlertsTable@defaultBean@servletRequest">
              <uix:rowLayout vAlign="top">

                <oem:table name="alertsUIDataSource"
                           partialRenderMode="self"
                           id="alertsTable"
                           alternateTextBinding="NO_ALERTS_ALT@SDKBundle@servletRequest"
                           width="100%" blockSize="5"
                           dataSourceProp="alertsUIDataSource"
                           beanKey="defaultBean"
                           >
                  </oem:table>

              </uix:rowLayout>
            </uix:tableLayout>
        

      <%-- host alerts header --%>

       <uix:styledText styleClass="OraHeaderSubSub" textBinding="RELATED_ALERTS@SDKBundle@servletRequest" 
			renderedBinding="showRelatedAlertsTable@defaultBean@servletRequest" />
          <uix:tableLayout renderedBinding="showRelatedAlertsTable@defaultBean@servletRequest" width="100%" >
              <uix:rowLayout vAlign="top">

                <oem:table name="relatedAlertsUIDataSource"
                           partialRenderMode="self"
                           id="relatedAlertsTable"
                           width="100%" blockSize="5"
                           alternateTextBinding="NO_ALERTS_ALT@SDKBundle@servletRequest"
                           dataSourceProp="relatedAlertsUIDataSource"
                           beanKey="defaultBean"
                           
                           >
                  </oem:table>

              </uix:rowLayout>
            </uix:tableLayout>

        <uix:styledText styleClass="OraHeaderSubSub" textBinding="DB_HOME_HDM_FINDINGS_TABLE_HEADER@HDMMsg"  renderedBinding="hdmRunAvailable@servletRequest"/>
        <uix:tableLayout renderedBinding="hdmRunAvailable@servletRequest">
           <uix:rowLayout>
	    
	     
           <uix:cellFormat  wrappingDisabled="true">
             <uix:styledText styleClass="OraPromptText"
                 textBinding="START_TIME@HDMMsg"/>

           </uix:cellFormat>
           <uix:spacer width="3"/>
           <uix:cellFormat wrappingDisabled="true">
             <uix:styledText styleClass="OraDataText"
                 textBinding="HDMStartPeriod@defaultBean@servletRequest"/>
           </uix:cellFormat>
           <uix:spacer width="3"/>
           <uix:cellFormat wrappingDisabled="true">
             <uix:styledText styleClass="OraPromptText"
                 textBinding="DURATION@HDMMsg"/>

           </uix:cellFormat>
           <uix:spacer width="3"/>
           <uix:cellFormat wrappingDisabled="true">
             <uix:styledText styleClass="OraDataText"
                 textBinding="HDMDuration@defaultBean@servletRequest"/>
           </uix:cellFormat> 
	     
         </uix:rowLayout>
         
       </uix:tableLayout>
        <uix:tableLayout renderedBinding="hdmRunAvailable@servletRequest">
           <uix:rowLayout>
	    
           <oem:table name="findingsTableUI"
            width="100%"
            formSubmitted="true"
            dataSourceProp="findingsTableUI"
            beanKey="defaultBean" 
            blockSize="5" alternateTextBinding="NO_FINDING_MESSAGE@HDMMsg" copyParams="target,type,task_id"> 
          </oem:table> 
         </uix:rowLayout>
         
       </uix:tableLayout>

     </db:form>
    <%-- /uix:pageLayout --%>
    </uix:body>


  </uix:document>
    <%@ include file="/em2go/em2goThinFooter.jspf" %> 
</uix:renderingContext>

