<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  
  <%@ include file="/em2go/em2goHrGlobal.jspf" %>  
  <uix:document>
    <uix:body>
    <%@ include file="/em2go/em2goBreadCrumbs.jspf" %>
        <db:form name="tsForm"  
                 destinationBinding="destURI@servletRequest"
                 copyParams="target,type">
        <uix:spacer height="10"/>


        <uix:header textBinding="header@sqlObjectBean@servletRequest" >

        <uix:tableLayout width="100%">
          <uix:rowLayout hAlign="left">
            <uix:cellFormat>
              <uix:rowLayout>
                <uix:styledText styleClass="OraInlineInfoText"
                      textBinding="lastUpdatedTime@sqlObjectBean@servletRequest"/>
              </uix:rowLayout>
            </uix:cellFormat>
          </uix:rowLayout>
        </uix:tableLayout>

        <uix:tableLayout width="100%">
          <uix:rowLayout>
            <uix:cellFormat hAlign="left">
              <uix:textInput name="sqlText"
                             textBinding="formatedSqlText@sqlObjectBean@servletRequest"
                             readOnly="true"
                             columns="120"
                             rows="10" />
            </uix:cellFormat>
          </uix:rowLayout>
        </uix:tableLayout>

        <uix:spacer height="10"/>

        <uix:subTabLayout>
          <uix:subTabs>
            <uix:subTabBar selectedIndex="2">
                <uix:link textBinding="EXPLAIN_PLAN_HEADER@DBMsgBundle@servletRequest"
                          destinationBinding="explainDest@servletRequest"/>
                <uix:link textBinding="SQL_STATISTICS@DBMsgBundle@servletRequest"
                          destinationBinding="statDest@servletRequest"/>
                <uix:link textBinding="SQL_ASSESSMENT@DBMsgBundle@servletRequest"/>
            </uix:subTabBar>
          </uix:subTabs>

        <uix:spacer height="5"/>

        <uix:rowLayout>
            <uix:stackLayout>
              <uix:switcher childNameBinding="sqlProblemsExist@sqlObjectBean@servletRequest">
                <uix:case name="true">

                  <uix:styledText styleClass="OraInstructionText"
                                  textBinding="PROBLEM_SUMMARY_RESPONSE_ONLY@DBMsgBundle@servletRequest" />
                  <oem:table name="twoDUIDataSource"
                             beanKey="sqlObjectBean"
                             destination="/console/database/instance/realTimeSqlObject"
                             copyParams="target,type"
                             formSubmitted="true"
                             dataSourceProp="problemsUIDataSource"
                             width="100%">
                  </oem:table>
                </uix:case>

                <uix:case name="false">

                  <uix:styledText styleClass="OraInstructionText"
                                  textBinding="PROBLEM_SUMMARY_NONE@DBMsgBundle@servletRequest" />
                </uix:case>
              </uix:switcher>
              <uix:spacer height="10"/>
            </uix:stackLayout>
        </uix:rowLayout>

        </uix:subTabLayout>

      </uix:header>            
    </db:form>
    </uix:body>
  </uix:document>
<%@ include file="/em2go/em2goThinFooter.jspf" %>    
</uix:renderingContext>

