<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

<uix:bundle name="dbMsg"
            class="oracle.sysman.db.rsc.inst.DBMsg"/>
<uix:bundle name="sqlMsg"
            class="oracle.sysman.db.rsc.inst.SQLMsg"/>

<%@ include file="/em2go/em2goHrGlobal.jspf" %>  
  <uix:document>

    <uix:body>

<%-- uix:pageLayout --%>
<%@ include file="/em2go/em2goBreadCrumbs.jspf" %>

    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="warning"
                        errorTableBinding="intervalWarning@servletRequest"
                        mainTextKey="exceptionText"/>
    <oem:messageBox messageType="error"
                        errorTableBinding="intervalError@servletRequest"
                        mainTextKey="exceptionText"/>
          
       <uix:rowLayout>
	     <uix:contents>
      <uix:styledText styleClass="OraHeaderSubSub" 
                      textBinding="HDR_SQL_TEXT@dbMsg" />
	     </uix:contents>
       </uix:rowLayout>


          <uix:tableLayout width="100%" >
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" vAlign = "top">
                  <uix:flowLayout>
                    <uix:link textBinding="SQL_STATISTICS@dbMsg"
                              destinationBinding="sqlStatDest@servletRequest"/>
                  </uix:flowLayout>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>


       <uix:rowLayout>
	     <uix:contents>
           <uix:spacer height="10"/>
	     </uix:contents>
       </uix:rowLayout>

          <uix:tableLayout width="100%" cellSpacing="3">
              <uix:rowLayout>
                <uix:cellFormat>
                    <uix:spacer width="15" />
                </uix:cellFormat >
                <uix:cellFormat hAlign="left">
                  <db:sqlDisplay sqlListBinding="sqlList@sqlDetailUI@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

       
    </uix:body>
  </uix:document>
<%@ include file="/em2go/em2goThinFooter.jspf" %>    
</uix:renderingContext>


