<%-- ================ Database Top Sqls Page Em2go =================== 
   MODIFIED    (MM/DD/YY)
      sresrini  03/21/06 - Fix jsp compilation errors
      yfeng     10/18/05 - Remove Bad SQL Assess button
--%>

<%@ include file="/sdk/oemTop.jspf" %>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
<%@ include file="/em2go/em2goHrGlobal.jspf" %>  
  <uix:document>

  <uix:metaContainer>
    <db:script src="/database/utils.js"/>
  </uix:metaContainer>
  <uix:body>

    <%@ include file="/em2go/em2goBreadCrumbs.jspf" %>

    <oem:messageBox messageType="warning"
              errorTableBinding="intervalWarning@servletRequest"
              mainTextKey="exceptionText"/>

    <oem:messageBox messageType="error"
              errorTableBinding="intervalError@servletRequest"
              mainTextKey="exceptionText"/>

    <db:form name="foo" destination="/console/database/em2go/instance/topSqls"
             copyParams="target,type">

      <uix:styledText styleClass="OraHeaderSubSub" 
                      textBinding="TOP_SQL_HEADER@ResourceBundle@servletRequest" />



    <uix:tableLayout  width="100%">
      <uix:rowLayout>
          <uix:stackLayout>
            <uix:switcher childNameBinding="node@dataSourceBeanEm2go@servletRequest">
              <uix:case name="okNode">

                <oem:table name="twoDUIDataSource"
                           blockSize="10" 
                           beanKey="dataSourceBeanEm2go"
                           destination="/console/database/em2go/instance/topSqls"
                           dataSourceProp="twoDUIDataSource"
                           width="100%">
                </oem:table>


              </uix:case>

              <!-- Error message -->
              <uix:case name="errNode">
                <uix:styledText textBinding="noData@dataSourceBeanEm2go@servletRequest"/>           
              </uix:case>


              <uix:case name="emptyNode">
              <uix:styledText textBinding="noData@dataSourceBeanEm2go@servletRequest"/>
              </uix:case>

            </uix:switcher>
          </uix:stackLayout>
        
      </uix:rowLayout>
    </uix:tableLayout>

          
        </db:form>
    </uix:body>
  </uix:document>
<%@ include file="/em2go/em2goThinFooter.jspf" %>    
</uix:renderingContext>
