<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
<%@ include file="/em2go/em2goHrGlobal.jspf" %>    
  <uix:document>
    <uix:body>

    <%@ include file="/em2go/em2goBreadCrumbs.jspf" %>
    <db:form name="foo" method="get" destination="/console/database/em2go/instance/sqlExecution" 
                     copyParams="target,type">
    <uix:header text="Sql Execution" >
    
    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest" 
                    msgBundleBinding="ResourceBundle"/>
    <uix:tableLayout>
       <uix:contents>      
        <uix:rowLayout>
          <uix:contents>
            <uix:stackLayout>
	          <uix:contents>
                    <uix:textInput name="queryString"
                                   textBinding="sqlQuery@servletRequest"
                                   columns="60"
                                   rows="3"/>
                    <uix:styledText renderedBinding="missingsql@servletRequest" styleClass="OraInlineInfoText" textBinding="missingsql@servletRequest" />
            
                    <uix:flowLayout>
                    <uix:submitButton text="Execute"
                                      name="event"
                                      value="execQuery" />

                      <uix:submitButton text="Clear"
                                      name="event"
                                      value="clearQuery" />
                    </uix:flowLayout>

                    <uix:switcher childNameBinding="showSQLException@servletRequest">
                      <uix:case name="yes">
                    <uix:styledText styleClass="OraInlineErrorText" textBinding="sqlException@servletRequest" />
                      </uix:case>
                    </uix:switcher>
                    <uix:switcher childNameBinding="showTable@servletRequest">
                      <uix:case name="yes">
                                <oem:table name="sqlExecBeanEm2go"
                                           beanKey="dataSourceBeanEm2go"
                                           dataSourceProp="sqlExecBeanEm2go" blockSize="5" 
                                           width="100%">
                                </oem:table>
                      </uix:case>
                    </uix:switcher>
             	  </uix:contents>
                </uix:stackLayout>
         	</uix:contents>
        </uix:rowLayout>
       </uix:contents>              
      </uix:tableLayout>

      </uix:header>
    </db:form>
    </uix:body>
  </uix:document>
<%@ include file="/em2go/em2goThinFooter.jspf" %>    
</uix:renderingContext>
