<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>

<%@ include file="/em2go/em2goHrGlobal.jspf" %>

    <uix:document>
	<uix:body>
        <uix:contents>
        <db:form name="foo" method="get"
            destinationBinding="destURI@servletRequest" copyParams="target,type" >
            <db:formValue name="waitClass"
                valueBinding="waitClass@waitDrilldownBean@servletRequest"/>
            
            <%@ include file="/em2go/em2goBreadCrumbs.jspf" %>

	        <uix:rowLayout width="100%">
        	    <uix:spacer height="15"/>
	        </uix:rowLayout>


            <uix:header textBinding="header@waitDrilldownBean@servletRequest" >

               <uix:tableLayout width="100%">
                   <uix:rowLayout hAlign="left">
                        <%@ include file="../fromToTime.jspf" %>
                   </uix:rowLayout>
               </uix:tableLayout>

            <uix:header textBinding="header@topWaitEvents@waitDrilldownBean@servletRequest">

        <uix:tableLayout width="100%">
            <uix:rowLayout>
                <uix:spacer height="20"/>
            </uix:rowLayout>
            <uix:rowLayout>
                <oem:table name="topWaitEvents"
                           beanKey="waitDrilldownBean"
                           alternateTextBinding="NO_EVENTS_FOR_CLASS@DBMsgBundle@servletRequest"
                           formSubmitted="true"
                           dataSourceProp="topWaitEvents"
                           width="100%" >
                </oem:table>
            </uix:rowLayout>
        </uix:tableLayout>

        <uix:tableLayout width="100%">
            <uix:cellFormat hAlign="left" wrappingDisabled="false" >
                <uix:rowLayout width="100%">
                    <uix:image sourceBinding="tipImage@servletRequest" />
                    <uix:styledText styleClass="OraInlineInfoText"
                        textBinding="TIP@DBMsgBundle@servletRequest"/>
                    <uix:spacer width="5" />
                    <uix:styledText styleClass="OraInlineInfoText"
                        textBinding="TOP_WAITS_TIP@DBMsgBundle@servletRequest"/>
                </uix:rowLayout>
            </uix:cellFormat>
        </uix:tableLayout>

        </uix:header>

        <uix:spacer height="10"/>

        <uix:header textBinding="header@waitingSessions@waitDrilldownBean@servletRequest">
        <uix:tableLayout width="100%">
            <uix:rowLayout>
                <uix:spacer height="20"/>
            </uix:rowLayout>
            <uix:rowLayout>
                <oem:table name="waitingSessions"
                           beanKey="waitDrilldownBean"
               blockSize="25"	
                           alternateTextBinding="NO_WAITING_SESSIONS@DBMsgBundle@servletRequest"
                           formSubmitted="true"
                           dataSourceProp="waitingSessions"
                           width="100%">
                </oem:table>

            </uix:rowLayout>
        </uix:tableLayout>

        <uix:tableLayout width="100%">
            <uix:cellFormat hAlign="left" wrappingDisabled="false">
                <uix:rowLayout>
                    <uix:image sourceBinding="tipImage@servletRequest" />
                    <uix:styledText styleClass="OraInlineInfoText"
                        textBinding="TIP@DBMsgBundle@servletRequest"/>
                    <uix:spacer width="5" />
                    <uix:styledText styleClass="OraInlineInfoText"
                        textBinding="WAITING_SESS_TIP@DBMsgBundle@servletRequest"/>
                </uix:rowLayout>
            </uix:cellFormat>
        </uix:tableLayout>

        </uix:header>

        <uix:rowLayout>
            <uix:spacer height="20"/>
        </uix:rowLayout>

        <uix:header textBinding="RELATED_LINKS@DBMsgBundle@servletRequest">
        <uix:tableLayout width="100%" cellSpacing="2">
          <uix:rowLayout>
            <uix:stackLayout>
              <uix:link textBinding="VIEW_TOP_SESSIONS@DBMsgBundle@servletRequest"
                    destinationBinding="topSessDest@servletRequest" />
              <uix:link textBinding="VIEW_TOP_SQL@DBMsgBundle@servletRequest"
                    destinationBinding="topSqlDest@servletRequest" />

                <uix:switcher childNameBinding="is10iOrHigher@waitDrilldownBean@servletRequest">
                    <uix:case name="true">
                        <uix:link textBinding="BLOCKING_SESS_HEADER@DBMsgBundle@servletRequest"
                            destinationBinding="blockingSessDest@servletRequest" />
                    </uix:case>
                </uix:switcher>
              </uix:stackLayout>

            <uix:stackLayout>
                <uix:switcher childNameBinding="hasEnqueueEvent@waitingSessions@waitDrilldownBean@servletRequest">
                    <uix:case name="true">
                        <uix:link textBinding="VIEW_DATABASE_LOCKS@DBMsgBundle@servletRequest"
                            destinationBinding="dbLocksDestEm2go@servletRequest" />
                    </uix:case>
                </uix:switcher>
              </uix:stackLayout>

          </uix:rowLayout>
        </uix:tableLayout>
      </uix:header>

          </uix:header>

        </db:form>
    </uix:contents>
    </uix:body>
    </uix:document>
 <%@ include file="/em2go/em2goThinFooter.jspf" %> 
</uix:renderingContext>
