<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
   <%@ include file="/em2go/em2goHrGlobal.jspf" %>
   <uix:document>

    <uix:metaContainer>
      <uix:head 
        titleBinding="CONTROLFILES_TITLE@controlfileBundle@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form
        name="foo" 
        method="post"
        destination="/console/database/em2go/storage/controlfile" copyParams="target,type,cancelURL">

        <uix:formValue 
          name="pageName" 
          value="/database/storage/em2go/controlfile/advancedPage"/>
        <uix:formValue 
          name="event" 
          value="bar"/>


        <%@ include file="/em2go/em2goBreadCrumbs.jspf" %>

          <%-- for breadcrumbs support; plus standard label, links, tabs, etc --%>
         <oem:messageBox messageType="info" 
                          errorTableBinding="info@servletRequest" />

     	    <uix:styledText styleClass="OraInlineInfoText" 
                          textBinding="mainText@info@servletRequest"/>                          
          <oem:messageBox messageType="error" 
                          errorTableBinding="errors@servletRequest" />
     	   <uix:styledText styleClass="OraInlineInfoText" 
                         textBinding="mainText@errors@servletRequest"/>

          <uix:subTabLayout>

     
            <%-- start Controlfile Information section --%>
            <uix:rowLayout>
            <uix:styledText styleClass="OraHeaderSubSub" 
              textBinding="CONTROLFILE_INFORMATION@controlfileBundle@servletRequest"/>
              </uix:rowLayout>
              <uix:tableLayout cellSpacing="5">

                <uix:rowLayout>
                  <uix:styledText 
                    styleClass="OraInstructionText"
                    textBinding="CONTROLFILES_DESCRIPTION@controlfileBundle@servletRequest"/>
                </uix:rowLayout>
              </uix:tableLayout>

              <uix:tableLayout cellSpacing="5">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt 
                      promptBinding="DATABASE_ID@controlfileBundle@servletRequest"/>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:styledText 
                      styleClass="OraDataText" 
                      textBinding="DBID@controlfileBean@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt 
                      promptBinding="CONTOLFILE_TYPE@controlfileBundle@servletRequest"/>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:styledText 
                      styleClass="OraDataText" 
                      textBinding="type@controlfileBean@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt 
                      promptBinding="CONTROLFILE_CREATION_DATE@controlfileBundle@servletRequest"/>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:styledText 
                      styleClass="OraDataText" 
                      textBinding="dateCreated@controlfileBean@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt 
                      promptBinding="CONTROLFILE_SEQUENCE_NUMBER@controlfileBundle@servletRequest"/>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:styledText 
                      styleClass="OraDataText" 
                      textBinding="seqNum@controlfileBean@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt
                      promptBinding="LAST_CHANGE_NUMBER@controlfileBundle@servletRequest"/>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:styledText 
                      styleClass="OraDataText" 
                      textBinding="changeNum@controlfileBean@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt 
                      promptBinding="DATE_LAST_MODIFIED@controlfileBundle@servletRequest"/>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:styledText 
                      styleClass="OraDataText"
                      textBinding="lastBackupTime@controlfileBean@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>

              </uix:tableLayout>
 

            <%-- end Controlfile Information section --%>

          </uix:subTabLayout>

      </db:form>
    </uix:body>
  </uix:document>
   <%@ include file="/em2go/em2goThinFooter.jspf" %>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>
