<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
   <%@ include file="/em2go/em2goHrGlobal.jspf" %>
   <uix:document>

    <uix:metaContainer>
      <uix:head 
        titleBinding="CONTROLFILES_TITLE@controlfileBundle@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form name="foo" 
               method="post"
               destination="/console/database/em2go/storage/controlfile" 
               copyParams="target,type,cancelURL">

        <uix:formValue name="pageName" 
                       value="/database/em2go/storage/controlfile/generalPage"/>

            <%@ include file="/em2go/em2goBreadCrumbs.jspf" %>

             <oem:messageBox messageType="info" 
                          errorTableBinding="info@servletRequest"/>
             <uix:styledText styleClass="OraInlineInfoText" 
                          textBinding="mainText@info@servletRequest"/>                          
             <oem:messageBox messageType="error" 
                          errorTableBinding="errors@servletRequest" />
       	     <uix:styledText styleClass="OraInlineInfoText" 
                         textBinding="mainText@errors@servletRequest"/>
           
         
	    <uix:tableLayout cellSpacing="10" width="100%">  
	    <uix:rowLayout>
		<uix:cellFormat>
                   <uix:link
                     textBinding="ADVANCED@controlfileBundle@servletRequest"
                     destinationBinding="ADVANCEDURL@servletRequest"/>
		</uix:cellFormat>
		<uix:cellFormat>
               <uix:link
                  textBinding="RECORD_SECTION@controlfileBundle@servletRequest"
                    destinationBinding="RECORDURL@servletRequest"/>
	        </uix:cellFormat>
           </uix:rowLayout>
            <uix:rowLayout>
                  <uix:submitButton 
                    textBinding="BACKUP@controlfileBundle@servletRequest"
                    name="event"
                    value="backupToTrace"
                    />
              </uix:rowLayout>  
	   </uix:tableLayout>

            <%-- start Controlfile Mirror Images section --%>
            <uix:styledText styleClass="OraHeaderSubSub" 
              textBinding="CONTROLFILE_MIRROR_IMAGES@controlfileBundle@servletRequest"/>

              <uix:tableLayout cellSpacing="5">
                <uix:rowLayout>
                  <uix:styledText 
                    styleClass="OraInstructionText"
                    textBinding="ORACLE_STRONGLY_RECOMMENDS@controlfileBundle@servletRequest"/>
                </uix:rowLayout>
              </uix:tableLayout>

              <uix:switcher childNameBinding="fileMapSupported@controlfileBean@servletRequest">
                <uix:case name="true">
                  <oem:table  
                    name="controlfilesTableUI"
                    beanKey="controlfilesBean"
                    destination="/console/database/storage/controlfile"
                    formSubmitted="true"
                    dataSourceProp="controlfilesTableUI"
                    width="100%"
                    >
                     <uix:tableSelection>
                      <uix:singleSelection selectedIndex="0">
                      <uix:submitButton textBinding="STORAGELAYOUT@uixDBObjectBundle@servletRequest"
                                        name="event"
                                        value="storageLayoutTab"/>
                      </uix:singleSelection>
                     </uix:tableSelection>
                  </oem:table>
                </uix:case>
		
		        <uix:case name="false">
                  <oem:table 
                    name="controlfilesTableUI"
                    beanKey="controlfilesBean"
                    destination="/console/database/storage/controlfile"
                    formSubmitted="true"
                    dataSourceProp="controlfilesTableUI"
                    width="100%"/>
		   </uix:case>
                   </uix:switcher>

  
            <%-- end Controlfile Mirror Images section --%>



      </db:form>
    </uix:body>
  </uix:document>
   <%@ include file="/em2go/em2goThinFooter.jspf" %>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>
