<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <%@ include file="/em2go/em2goHrGlobal.jspf" %>
  <uix:document>

    <uix:metaContainer>
      <uix:head 
        titleBinding="CONTROLFILES_TITLE@controlfileBundle@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form
        name="foo" 
        method="post"
        destination="/console/database/em2go/storage/controlfile" copyParams="target,type,cancelURL">

        <uix:formValue 
          name="pageName" 
          value="/database/em2go/storage/controlfile/recSectionPage"/>

   
          <%@ include file="/em2go/em2goBreadCrumbs.jspf" %>
        <oem:messageBox messageType="info" 
                          errorTableBinding="info@servletRequest"/>

     	    <uix:styledText styleClass="OraInlineInfoText" 
                          textBinding="mainText@info@servletRequest"/>                          
          <oem:messageBox messageType="error" 
                          errorTableBinding="errors@servletRequest"/>
     	   <uix:styledText styleClass="OraInlineInfoText" 
                         textBinding="mainText@errors@servletRequest"/>
          <uix:subTabLayout>
            <%-- start Controlfile Record Section Information section --%>
              <uix:rowLayout>
                <uix:styledText styleClass="OraHeaderSubSub"  
                textBinding="CONTROLFILE_RECORD_INFORMATION@controlfileBundle@servletRequest"/>
              </uix:rowLayout>

              <oem:table 
                name="controlfileRecSectionsTableUI"
                beanKey="recsecBean"
                destination="/console/database/storage/controlfile" 
                formSubmitted="true"
                dataSourceProp="controlfileRecSectionsTableUI"
                width="80%">
              </oem:table>

            <%-- end Controlfile Record Section Information section --%>

          </uix:subTabLayout>

       
      </db:form>
    </uix:body>
  </uix:document>
   <%@ include file="/em2go/em2goThinFooter.jspf" %>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>
