<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
   <%@ include file="/em2go/em2goHrGlobal.jspf" %>
   <uix:document>
    <uix:metaContainer>
      <uix:head titleBinding="title@datafileBean@servletRequest"/>
      <db:script src="/database/utils.js"/>
    </uix:metaContainer>
  <uix:body>
  
  <uix:contents> 
    <db:form name="foo" method="post" destination="/console/database/em2go/storage/datafile" copyParams="target,type,cancelURL,oname">
    <uix:formValue name="pageName" value="/database/em2go/storage/datafile/dbfGenPage"/>

    <!-- for breadcrumbs support; plus standard label, links, tabs, etc -->
 <%@ include file="/em2go/em2goBreadCrumbs.jspf" %>

    <oem:messageBox messageType="info"
                        errorTableBinding="info@servletRequest" />
    <uix:styledText styleClass="OraInlineInfoText" textBinding="mainText@info@servletRequest"/>

    <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest" />

    <uix:styledText styleClass="OraInlineErrorText" textBinding="mainText@errors@servletRequest"/>
 



   <uix:subTabLayout>


      <%-- start General & Storage section --%>
      <jsp:include page="/database/em2go/storage/datafile/dbfTbsSharedAtt.jsp" />
      <uix:ref refID="dbfTbsSharedAtt" />
      <%-- End General & Storage section --%>

     </uix:subTabLayout>


      <%-- start buttons section --%>
      <uix:rowLayout>
     
          <uix:submitButton name="event" value="showSql"
                    textBinding="SHOWSQL@uixDBObjectBundle@servletRequest"
                    formName="foo"/>

          <uix:switcher childNameBinding="creating@defaultBean@servletRequest">
            <uix:case name="true">
              <uix:flowLayout>
                <uix:submitButton name="event" value="cancel"
                          textBinding="CANCEL@uixDBObjectBundle@servletRequest"
                          formName="foo"/>
                <uix:submitButton name="event" value="apply"
                          textBinding="OK@uixDBObjectBundle@servletRequest"
                          formName="foo"/>
              </uix:flowLayout>
            </uix:case>
            <uix:case name="false">
              <uix:flowLayout>
                <uix:submitButton name="event" value="revert"
                          textBinding="REVERT@uixDBObjectBundle@servletRequest"
                          formName="foo"/>
                <uix:submitButton name="event" value="apply"
                          textBinding="APPLY@uixDBObjectBundle@servletRequest"
                          formName="foo"/>
              </uix:flowLayout>
            </uix:case>
          </uix:switcher>

      </uix:rowLayout>
      <%-- end buttons section --%>

</db:form>
</uix:contents>
</uix:body>
</uix:document>
  <%@ include file="/em2go/em2goThinFooter.jspf" %> 
</uix:renderingContext>

