<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<uix:buildTree nodeID="dbfTbsSharedAtt">
  <uix:tableLayout cellSpacing="5">

          <uix:rowLayout>
            <uix:cellFormat hAlign="right">                   
              <uix:messagePrompt promptBinding="NAME@DatafileBundle@servletRequest"
                               required="yes"/>
            </uix:cellFormat>                                                                                    
            <uix:cellFormat hAlign="left">
            <%-- textInput name attribute cannot have a value of "name" --%>
              <uix:textInput name="filename"
                           columns="19"
                           textBinding="filename@defaultBean@servletRequest"/>
              <uix:messageText messageBinding="filename@errors@servletRequest" messageType="error"/>
            </uix:cellFormat>
          </uix:rowLayout>
   
          <uix:rowLayout>
            <uix:cellFormat hAlign="right">                   
              <uix:messagePrompt promptBinding="PATH@DatafileBundle@servletRequest"
                               required="yes"/>
            </uix:cellFormat>                                                                                    
            <uix:cellFormat hAlign="left">
              <uix:textInput name="filepath"
                           columns="19"
                           textBinding="filepath@defaultBean@servletRequest"/>
              <uix:messageText messageBinding="filepath@errors@servletRequest"
                             messageType="error"/>

            </uix:cellFormat>
          </uix:rowLayout>
       

      <uix:switcher childNameBinding="datafileFromTbs@defaultBean@servletRequest">
        <uix:case name="false">
          <uix:switcher childNameBinding="creating@defaultBean@servletRequest">
            <uix:case name="true">
              <uix:rowLayout>
                  <uix:cellFormat hAlign="right">                   
                  <uix:messagePrompt required="yes"
                                  promptBinding="TABLESPACE@DatafileBundle@servletRequest"/>
                  </uix:cellFormat>                                  
                <uix:flowLayout>
                  <uix:lovField
                        name="tablespace"
                        textBinding="tablespace@defaultBean@servletRequest"
                        destination="javascript:launchLov('/em/console/database/storage/datafile?event=selectTablespace&pageName=/database/storage/datafile/dbfGenPage',700,500)"/>
                  <uix:messageText
                             messageBinding="Tablespaces@errors@servletRequest"
                             messageType="error"/>
                  <uix:styledText styleClass="OraInlineErrorText" textBinding="Tablespaces@errors@servletRequest"/>
 
             </uix:flowLayout>
            </uix:rowLayout>
            </uix:case>
            <uix:case name="false">
              <uix:rowLayout>
                  <uix:cellFormat hAlign="right">                                 
                  <uix:messagePrompt promptBinding="TABLESPACE@DatafileBundle@servletRequest"/>
                   </uix:cellFormat>
                   <uix:cellFormat hAlign="left">
                    <uix:spacer width="3"/>
                    <uix:link textBinding="tablespace@defaultBean@servletRequest"
                          destinationBinding="tablespaceLink@servletRequest"/>
                    </uix:cellFormat>
              </uix:rowLayout>
            </uix:case>
          </uix:switcher>

        </uix:case>
        <%--uix:case name="true">
          <!-- we got to this datafile page from the tablespace page -->
          <uix:rowLayout>
            <uix:cellFormat hAlign="right">                                 
              <uix:messagePrompt promptBinding="TABLESPACE@DatafileBundle@servletRequest"/>
            </uix:cellFormat>
            <uix:styledText  styleClass="OraDataText"
                             textBinding="tablespace@defaultBean@servletRequest"/>
          </uix:rowLayout>
        </uix:case--%>
      </uix:switcher>

             <uix:rowLayout renderedBinding="editing@defaultBean@servletRequest">
                     <uix:cellFormat hAlign="right">                                
                     <uix:messagePrompt promptBinding="STATUS@DatafileBundle@servletRequest"/>
                     </uix:cellFormat>                     
                <uix:flowLayout>

                 <oem:radioButton  name="datafileStatus"
                          selectedValueBinding="datafileStatus@defaultBean@servletRequest"
                          textBinding="TXT_ONLINE@DatafileBundle@servletRequest"
                          value="0"/>

                  <uix:switcher childNameBinding="datafileStatus@defaultBean@servletRequest">
                  <uix:case name="0">
                  <oem:radioButton  name="datafileStatus"
                          selectedValueBinding="datafileStatus@defaultBean@servletRequest"
                          textBinding="TXT_OFFLINE@DatafileBundle@servletRequest"
                          value="1"/>
                  </uix:case>
                  <uix:case name="1">
                  <oem:radioButton name="datafileStatus"
                          selectedValueBinding="datafileStatus@defaultBean@servletRequest"
                          textBinding="TXT_OFFLINE@DatafileBundle@servletRequest"
                          value="1"/>
                  </uix:case>
                  <uix:case name="2">
                  <oem:radioButton name="datafileStatus"
                          selectedValueBinding ="datafileStatus@defaultBean@servletRequest"
                          textBinding="TXT_RECOVER@DatafileBundle@servletRequest"
                          value="2"/>
                  </uix:case>
                </uix:switcher>


                  </uix:flowLayout>
              </uix:rowLayout>


              <uix:rowLayout>
                  <uix:cellFormat hAlign="right">                                 
                  <uix:messagePrompt promptBinding= "SIZE@DatafileBundle@servletRequest"/>
                  </uix:cellFormat>                  
             
                  <uix:flowLayout>
                    <uix:textInput name="datafileSize"
                                   textBinding="datafileSize@defaultBean@servletRequest"
                                   columns="5"/>
                    <oem:choice name="datafileSizeUnit"
                                selectedValueBinding="datafileSizeUnit@defaultBean@servletRequest"
                                optionsBinding="units@defaultBean@servletRequest"/>

                  </uix:flowLayout>
                 <uix:messageText
                             messageBinding="datafileSize@errors@servletRequest"
                             messageType="error"/>

          
              </uix:rowLayout>

              <uix:switcher childNameBinding="datafileFromTbs@defaultBean@servletRequest">
              <uix:case name="false">

               <uix:switcher childNameBinding="creating@defaultBean@servletRequest">
                <uix:case name="true">
                <uix:rowLayout>
                  <uix:messagePrompt prompt=""/>
                  <uix:checkBox name="datafileReuse"
                                checkedBinding="datafileReuse@defaultBean@servletRequest"
                                textBinding="REUSE_EXISTING_FILE@DatafileBundle@servletRequest"/>
              </uix:rowLayout>
              </uix:case>
              </uix:switcher>

              </uix:case>
              <uix:case name="true">
              <uix:switcher childNameBinding="datafileCreatingFromTbs@defaultBean@servletRequest">
               <uix:case name="true">

              <uix:rowLayout>
                  <uix:messagePrompt prompt=""/>
                  <uix:checkBox name="datafileReuse"
                     checkedBinding="datafileReuse@defaultBean@servletRequest"
                     textBinding="REUSE_EXISTING_FILE@DatafileBundle@servletRequest"/>
              </uix:rowLayout>
              </uix:case>
              </uix:switcher>
              </uix:case>
              </uix:switcher>
          <uix:rowLayout>
            <uix:messagePrompt prompt=""/>
            <uix:checkBox name="datafileAutoExtend"
                     checkedBinding="datafileAutoExtend@defaultBean@servletRequest"
                     textBinding="EM2GO_AUTO_EXTEND@DatafileBundle@servletRequest"/>
          </uix:rowLayout>
            <%--/uix:tableLayout--%>
            <%-- end General section --%>

           
            <%--uix:rowLayout> 
           
              <uix:tableLayout cellSpacing="5"--%>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                      <uix:messagePrompt promptBinding="EXTEND_INCREMENT@DatafileBundle@servletRequest"
                               required="no"/>
                  </uix:cellFormat>

                  <uix:cellFormat wrappingDisabled="true">
                    <uix:flowLayout>
                      <uix:textInput name="datafileIncrement"
                                 textBinding="datafileIncrement@defaultBean@servletRequest"
                                 columns="8"/>
                      <oem:choice  name="datafileIncrementUnit"
                                 selectedValueBinding="datafileIncrementUnit@defaultBean@servletRequest"
                                 optionsBinding="units@defaultBean@servletRequest"/>
                    </uix:flowLayout>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:messageText
                             messageBinding="datafileIncrement@errors@servletRequest"
                             messageType="error"/>
                  </uix:cellFormat>
                </uix:rowLayout>

                <uix:rowLayout vAlign="top">
                  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt promptBinding="EXTEND_MAX_SIZE@DatafileBundle@servletRequest"
                               required="no"/>
                  </uix:cellFormat>

                  <uix:cellFormat hAlign="left" wrappingDisabled="true">
                    <uix:stackLayout>
                      <oem:radioButton name="maxSizeUnlimited"
                                        textBinding="TXT_UNLIMITED@DatafileBundle@servletRequest"
                                        selectedValueBinding="maxSizeUnlimited@defaultBean@servletRequest"
                                       value="true"/>
                      <uix:flowLayout>
                        <oem:radioButton name="maxSizeUnlimited"
                                        textBinding="TXT_VALUE@DatafileBundle@servletRequest"
                                        value="false"
                                        selectedValueBinding="maxSizeUnlimited@defaultBean@servletRequest"/>

                        <uix:textInput columns="4" name="datafileMaxSize"
                                       textBinding="datafileMaxSize@defaultBean@servletRequest"/>
                        <oem:choice name="datafileMaxSizeUnit"
                                    selectedValueBinding="datafileMaxSizeUnit@defaultBean@servletRequest"
                                    optionsBinding="units@defaultBean@servletRequest"/>
                        </uix:flowLayout>
                      </uix:stackLayout>
                    
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:messageText
                              messageBinding="datafileMaxSize@errors@servletRequest"
                              messageType="error"/>
                  </uix:cellFormat>
                </uix:rowLayout>
        
   </uix:tableLayout>
    </uix:buildTree>
            <%--  End Storage section --%>

