<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
   <%@ include file="/em2go/em2goHrGlobal.jspf" %>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="title@datafileBean@servletRequest"/>
    </uix:metaContainer>
    <uix:body>

    <db:form name="foo" method="get" destination="/console/database/em2go/storage/datafile" copyParams="target,type,cancelURL,oname,otype">

    <uix:formValue name="pageName" value="/database/em2go/storage/datafile/dbfView"/>
    <!-- for breadcrumbs support in em2go we have jspf-->
    <%@ include file="/em2go/em2goBreadCrumbs.jspf" %>


     <oem:messageBox messageType="info"
                        errorTableBinding="info@servletRequest" />

     <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"/>
      
    
         <uix:labeledFieldLayout labelWidth="20%">
           <uix:contents>
             <uix:messagePrompt promptBinding="NAME@DatafileBundle@servletRequest"/>
             <uix:styledText
                        styleClass="OraDataText"
                        textBinding="datafileName@datafileBean@servletRequest"/>
           
             <uix:messagePrompt promptBinding="TABLESPACE@DatafileBundle@servletRequest"/>
             <uix:link textBinding="tablespace@datafileBean@servletRequest"
                       destinationBinding="tablespaceLink@servletRequest"/>       
           </uix:contents>
         </uix:labeledFieldLayout> 
    
         <uix:switcher childNameBinding="datafileStatus@defaultBean@servletRequest">
           <uix:case name="0">
             <uix:labeledFieldLayout labelWidth="20%">
               <uix:contents>
                 <uix:messagePrompt promptBinding="STATUS@DatafileBundle@servletRequest"/>
                 <uix:styledText
                            styleClass="OraDataText"
                            textBinding="TXT_ONLINE@DatafileBundle@servletRequest"/>
               </uix:contents>
             </uix:labeledFieldLayout> 
           </uix:case>
           <uix:case name="1">
             <uix:labeledFieldLayout labelWidth="20%">
               <uix:contents>
                 <uix:messagePrompt promptBinding="STATUS@DatafileBundle@servletRequest"/>
                 <uix:styledText
                            styleClass="OraDataText"
                            textBinding="TXT_OFFLINE@DatafileBundle@servletRequest"/>
               </uix:contents>
             </uix:labeledFieldLayout> 
           </uix:case>
           <uix:case name="2">
             <uix:labeledFieldLayout labelWidth="20%">
               <uix:contents>
                 <uix:messagePrompt promptBinding="STATUS@DatafileBundle@servletRequest"/>
                 <uix:styledText
                            styleClass="OraDataText"
                            textBinding="TXT_RECOVER@DatafileBundle@servletRequest"/>
               </uix:contents>
             </uix:labeledFieldLayout> 
           </uix:case>
         </uix:switcher>
    
         <uix:labeledFieldLayout labelWidth="20%">
           <uix:contents>
             <uix:messagePrompt promptBinding="fileSizeWithUnitLabel@defaultBean@servletRequest"/>
             <uix:styledText
                      styleClass="OraDataText"
                      textBinding="datafileSize@defaultBean@servletRequest"/>
    
             <uix:messagePrompt promptBinding="AUTO_EXTEND@DatafileBundle@servletRequest"/>
             <uix:switcher childNameBinding="datafileAutoExtend@defaultBean@servletRequest">
               <uix:case name="true">
                 <uix:styledText styleClass="OraDataText"
                                 textBinding="YES@uixDBObjectBundle@servletRequest"/>
               </uix:case>
               <uix:case name="false">
                 <uix:styledText styleClass="OraDataText"
                                 textBinding="NO@uixDBObjectBundle@servletRequest"/>
               </uix:case>
             </uix:switcher>
           </uix:contents>
         </uix:labeledFieldLayout> 
    
         <uix:switcher childNameBinding="datafileAutoExtend@defaultBean@servletRequest">
           <uix:case name="true">
             <uix:labeledFieldLayout labelWidth="20%">
               <uix:contents>
                   <uix:messagePrompt promptBinding="EXTEND_INCREMENT@DatafileBundle@servletRequest"/>
                   <uix:flowLayout>
                     <uix:styledText
                               styleClass="OraDataText"
                               textBinding="datafileIncrement@defaultBean@servletRequest"/>
                     <uix:styledText
                               styleClass="OraDataText"
                               textBinding="datafileIncrementUnit@defaultBean@servletRequest"/>
                   </uix:flowLayout>
                </uix:contents>
             </uix:labeledFieldLayout>
           </uix:case>
         </uix:switcher>
    
         <uix:switcher childNameBinding="datafileAutoExtend@defaultBean@servletRequest">
           <uix:case  name="true">
             <uix:labeledFieldLayout labelWidth="20%">
               <uix:contents>
                 <uix:messagePrompt promptBinding="EXTEND_MAX_SIZE@DatafileBundle@servletRequest"/>
                 <uix:flowLayout>
                   <uix:styledText
                              styleClass="OraDataText"
                              textBinding="datafileMaxSize@defaultBean@servletRequest"/>
                   <uix:styledText
                              styleClass="OraDataText"
                              textBinding="datafileMaxSizeUnit@defaultBean@servletRequest"/>
                 </uix:flowLayout>
               </uix:contents>
             </uix:labeledFieldLayout>
           </uix:case>
         </uix:switcher>
       

    

  </db:form>

</uix:body>
</uix:document>
<%@ include file="/em2go/em2goThinFooter.jspf" %>
</uix:renderingContext>





