<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
       <%@ include file="/em2go/em2goHrGlobal.jspf" %>
       <uix:document>

   
    <uix:metaContainer>
      <uix:head titleBinding="title@objectBean@servletRequest"/>
      <db:script src="/database/utils.js"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
   

        <db:form name="foo" method="post" destination="/console/database/em2go/storage/rbsegment" copyParams="target,type,cancelURL,oname">
          <uix:formValue name="pageName" value="/database/em2go/storage/rbsegment/pageRbsegment"/>
         
       <%@ include file="/em2go/em2goBreadCrumbs.jspf" %>
       
       <uix:rowLayout>
       </uix:rowLayout>
       
       <oem:messageBox
                messageType="info" errorTableBinding="info@servletRequest" />
            <uix:styledText styleClass="OraInlineInfoText" textBinding="mainText@info@servletRequest"/>

            <oem:messageBox
                messageType="error" errorTableBinding="errors@servletRequest"/>
           <uix:styledText styleClass="OraInlineErrorText" textBinding="mainText@errors@servletRequest"/>
       
       <uix:spacer height="5" />

            <uix:switcher childNameBinding="creating@objectBean@servletRequest">
              <uix:case name="true">
                <uix:labeledFieldLayout labelWidth="10%">
                  <uix:contents>
                    <uix:messagePrompt
                        promptBinding="LBL_NAME@uixRbsegmentBundle@servletRequest"
                        required="yes"/>
                    <uix:stackLayout>
                    <uix:textInput
                        name="rbsegmentName"
                        textBinding="rbsegmentName@objectBean@servletRequest"
                        columns="15"/>
                    <uix:messageText messageType="error" messageBinding="rbsegmentName@errors@servletRequest"/>
                    </uix:stackLayout>
                    
                    <uix:messagePrompt
                        promptBinding="LBL_TABLESPACE@uixRbsegmentBundle@servletRequest"
                        required="yes"/>
                    <uix:stackLayout>
                    <uix:textInput
                        name="tablespace"
                        textBinding="tablespace@rbsegmentComponent@servletRequest"
                        columns="15"/>
                    <uix:messageText messageType="error" messageBinding="tablespace@errors@servletRequest"/>
                    </uix:stackLayout>
                        

                    <uix:messagePrompt
                        prompt=""/>
                    <uix:checkBox
                        name="rbsegmentType"
                        checkedBinding="typeChecked@rbsegmentComponent@servletRequest"
                        textBinding="TXT_PUBLIC@uixRbsegmentBundle@servletRequest"
                        value="PUBLIC"
                        disabledBinding="editing@objectBean@servletRequest"/>
                    <uix:messagePrompt
                        promptBinding="LBL_STATUS@uixRbsegmentBundle@servletRequest"/>
                    <uix:flowLayout>
                      <uix:radioButton
                          name="status"
                          selectedValueBinding="status@rbsegmentComponent@servletRequest"
                          textBinding="TXT_ONLINE@uixRbsegmentBundle@servletRequest"
                          value="ONLINE"/>
                      <uix:radioButton
                          name="status"
                          selectedValueBinding="status@rbsegmentComponent@servletRequest"
                          textBinding="TXT_OFFLINE@uixRbsegmentBundle@servletRequest"
                          value="OFFLINE"/>
                    </uix:flowLayout>
                  </uix:contents>
                </uix:labeledFieldLayout>
              </uix:case>

              <uix:case name="false">
                <uix:labeledFieldLayout labelWidth="20%">
                  <uix:contents>
                    <uix:messagePrompt
                        promptBinding="LBL_NAME@uixRbsegmentBundle@servletRequest"/>
                    <uix:styledText styleClass="OraDataText"
                        textBinding="rbsegmentName@objectBean@servletRequest"/>
                    <uix:messagePrompt
                        promptBinding="LBL_TABLESPACE@uixRbsegmentBundle@servletRequest"/>
                    <uix:styledText styleClass="OraDataText"
                        textBinding="tablespace@rbsegmentComponent@servletRequest"/>
                    <uix:messagePrompt prompt=""/>
                    <uix:checkBox
                        name="rbsegmentType"
                        checkedBinding="typeChecked@rbsegmentComponent@servletRequest"
                        textBinding="TXT_PUBLIC@uixRbsegmentBundle@servletRequest"
                        value="PUBLIC"
                        disabledBinding="editing@objectBean@servletRequest"/>
                    <uix:messagePrompt
                        promptBinding="LBL_STATUS@uixRbsegmentBundle@servletRequest"/>
                    <uix:flowLayout>
                      <uix:radioButton
                          name="status"
                          selectedValueBinding="status@rbsegmentComponent@servletRequest"
                          textBinding="TXT_ONLINE@uixRbsegmentBundle@servletRequest"
                          value="ONLINE"/>
                      <uix:radioButton
                          name="status"
                          selectedValueBinding="status@rbsegmentComponent@servletRequest"
                          textBinding="TXT_OFFLINE@uixRbsegmentBundle@servletRequest"
                          value="OFFLINE"/>
                    </uix:flowLayout>
                  </uix:contents>
                </uix:labeledFieldLayout>
              </uix:case>
            </uix:switcher>
            <%-- start Extents section --%>
            <uix:styledText styleClass="OraHeaderSubSub" textBinding="TAB_EXTENTS@uixRbsegmentBundle@servletRequest"/>
              <uix:tableLayout cellSpacing="2">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" wrappingDisabled="true" >
                    <uix:messagePrompt
                        prompt="Initial"/>
                  </uix:cellFormat>
                  <uix:stackLayout>
                    <uix:flowLayout>
                      <uix:textInput
                          name="initSize"
                          textBinding="initSize@rbsegmentComponent@servletRequest"
                          disabledBinding="editing@objectBean@servletRequest"
                          columns="7"/>
                      <uix:choice
                          name="initSizeUnits"
                          selectedValueBinding="initSizeUnits@rbsegmentComponent@servletRequest"
                          disabledBinding="editing@objectBean@servletRequest">
                        <uix:contents>
                          <uix:option
                              valueBinding="TXT_BYTES@uixRbsegmentBundle@servletRequest"
                              textBinding="TXT_BYTES@uixRbsegmentBundle@servletRequest"/>
                          <uix:option
                              valueBinding="KBYTES@uixDBObjectBundle@servletRequest"
                              textBinding="KBYTES@uixDBObjectBundle@servletRequest"/>
                          <uix:option
                              valueBinding="MBYTES@uixDBObjectBundle@servletRequest"
                              textBinding="MBYTES@uixDBObjectBundle@servletRequest"/>
                        </uix:contents>
                      </uix:choice>
                    </uix:flowLayout>
                    <uix:messageText messageType="error" messageBinding="initSize@errors@servletRequest"/>
                  </uix:stackLayout>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                    <uix:messagePrompt
                        prompt="Next"/>
                  </uix:cellFormat>
                  <uix:stackLayout>
                    <uix:flowLayout>
                      <uix:textInput
                          name="nextSize"
                          textBinding="nextSize@rbsegmentComponent@servletRequest"
                          columns="7"/>
                      <uix:choice
                          name="nextSizeUnits"
                          selectedValueBinding="nextSizeUnits@rbsegmentComponent@servletRequest">
                        <uix:contents>
                          <uix:option
                              valueBinding="TXT_BYTES@uixRbsegmentBundle@servletRequest"
                              textBinding="TXT_BYTES@uixRbsegmentBundle@servletRequest"/>
                          <uix:option
                              valueBinding="KBYTES@uixDBObjectBundle@servletRequest"
                              textBinding="KBYTES@uixDBObjectBundle@servletRequest"/>
                          <uix:option
                              valueBinding="MBYTES@uixDBObjectBundle@servletRequest"
                              textBinding="MBYTES@uixDBObjectBundle@servletRequest"/>
                        </uix:contents>
                      </uix:choice>
                    </uix:flowLayout>
                  </uix:stackLayout>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                    <uix:messagePrompt
                        prompt="Optimal"/>
                  </uix:cellFormat>
                  <uix:stackLayout>
                    <uix:flowLayout>
                      <uix:textInput
                            name="optSize"
                            textBinding="optSize@rbsegmentComponent@servletRequest"
                            columns="7"/>
                      <uix:choice
                          name="optSizeUnits"
                          selectedValueBinding="optSizeUnits@rbsegmentComponent@servletRequest">
                        <uix:contents>
                          <uix:option
                              valueBinding="TXT_BYTES@uixRbsegmentBundle@servletRequest"
                              textBinding="TXT_BYTES@uixRbsegmentBundle@servletRequest"/>
                          <uix:option
                              valueBinding="KBYTES@uixDBObjectBundle@servletRequest"
                              textBinding="KBYTES@uixDBObjectBundle@servletRequest"/>
                          <uix:option
                              valueBinding="MBYTES@uixDBObjectBundle@servletRequest"
                              textBinding="MBYTES@uixDBObjectBundle@servletRequest"/>
                        </uix:contents>
                      </uix:choice>
                    </uix:flowLayout>
                  </uix:stackLayout>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt
                        prompt="Minimum"/>
                  </uix:cellFormat>
                  <uix:stackLayout>
                    <uix:flowLayout>
                      <uix:textInput
                            name="minimum"
                            textBinding="minimum@rbsegmentComponent@servletRequest"
                            disabledBinding="editing@objectBean@servletRequest"
                            columns="7"/>
                    </uix:flowLayout>
                  </uix:stackLayout>
                </uix:rowLayout>
                
                    
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                    <uix:messagePrompt
                        prompt="Maximum"/>
                  </uix:cellFormat>
                  <uix:cellFormat>
                      <uix:flowLayout>
                      <uix:radioButton
                            name="maximumOpt"
                            selectedValueBinding="maximumOpt@rbsegmentComponent@servletRequest"
                            textBinding="TXT_UNLIMITED@uixRbsegmentBundle@servletRequest"
                            value="UNLIMITED"/>
        
                        <uix:radioButton
                            name="maximumOpt"
                            selectedValueBinding="maximumOpt@rbsegmentComponent@servletRequest"
                            textBinding="TXT_VALUE@uixRbsegmentBundle@servletRequest"
                            value="VALUE"/>
                      <uix:textInput
                            name="maximum"
                            textBinding="maximum@rbsegmentComponent@servletRequest"
                            columns="7"/>
                    </uix:flowLayout>
                  </uix:cellFormat>
                </uix:rowLayout>
          </uix:tableLayout>
        
            <%-- end Extents section --%>

              <uix:rowLayout>
                <uix:submitButton name="event" value="showSql"
                    textBinding="SHOWSQL@uixDBObjectBundle@servletRequest"/>
                <uix:switcher childNameBinding="creating@objectBean@servletRequest">
                  <uix:case name="true">
                    <uix:flowLayout>
                      <uix:submitButton name="event" value="cancel"
                          textBinding="CANCEL@uixDBObjectBundle@servletRequest"/>
                  
                      <uix:submitButton name="event" value="apply"
                          textBinding="OK@uixDBObjectBundle@servletRequest"/>
                    </uix:flowLayout>
                  </uix:case>
                  <uix:case name="false">
                    <uix:flowLayout>
                      <uix:submitButton name="event" value="revert"
                          textBinding="REVERT@uixDBObjectBundle@servletRequest"/>

                      <uix:submitButton name="event" value="apply"
                          textBinding="APPLY@uixDBObjectBundle@servletRequest"/>
                    </uix:flowLayout>
                  </uix:case>
                </uix:switcher>
              </uix:rowLayout>
          
    
        </db:form>
      </uix:contents>
    </uix:body>
  </uix:document>
    <%@ include file="/em2go/em2goThinFooter.jspf" %> 
</uix:renderingContext>

