<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <%@ include file="/em2go/em2goHrGlobal.jspf" %>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="title@objectBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>

        <db:form name="foo" method="post" 
                            destination="/console/database/em2go/storage/rbsegment" 
                            copyParams="target,type,cancelURL,oname,otype">

          <uix:formValue name="pageName" value="/database/em2go/storage/rbsegment/pageView"/>

          <%@ include file="/em2go/em2goBreadCrumbs.jspf" %>

          <uix:rowLayout>
          </uix:rowLayout>

          <%-- Info/Error display --%>
          <uix:flowLayout>
            <oem:messageBox messageType="info" 
                            errorTableBinding="info@servletRequest"/>
            <uix:styledText styleClass="OraInlineInfoText" 
                            textBinding="mainText@info@servletRequest"/>
          </uix:flowLayout>
          <uix:flowLayout>
            <oem:messageBox messageType="error" 
                            errorTableBinding="errors@servletRequest"/>
            <uix:styledText styleClass="OraInlineErrorText" 
                            textBinding="mainText@errors@servletRequest"/>
          </uix:flowLayout> 
        
          <uix:tableLayout>
            <uix:rowLayout>
              <uix:contents>
                <uix:cellFormat hAlign="right">
                  <uix:messagePrompt promptBinding="ACTIONS@uixDBObjectBundle@servletRequest" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left">
                  <uix:flowLayout>
                    <uix:contents>
                      <uix:spacer width="3"/>
                      <uix:choice name="optionChoice" selectedIndex="0">
                        <uix:contents childDataBinding="actionsList@defaultBean@servletRequest">
                          <uix:option textBinding="textKey"
                                      valueBinding="valueKey"/>
                        </uix:contents>
                      </uix:choice>
                      <uix:spacer width="2"/>
                      <uix:submitButton textBinding="GO@uixDBObjectBundle@servletRequest" name="event" value="go"/>
                    </uix:contents>
                  </uix:flowLayout>
                </uix:cellFormat>
              </uix:contents>
            </uix:rowLayout>    
          </uix:tableLayout>          

          <uix:spacer height="5"/>

          <uix:labeledFieldLayout labelWidth="20%">
            <uix:contents>
              <uix:messagePrompt promptBinding="LBL_NAME@uixRbsegmentBundle@servletRequest"/>
              <uix:styledText styleClass="OraDataText"
                              textBinding="rbsegmentName@objectBean@servletRequest"/>

              <uix:messagePrompt promptBinding="LBL_TABLESPACE@uixRbsegmentBundle@servletRequest"/>
                    
              <uix:link textBinding="tablespace@rbsegmentComponent@servletRequest" 
                        destinationBinding="tablespaceLink@servletRequest"/>

              <uix:messagePrompt promptBinding="EXTENT_MANAGEMENT@uixRbsegmentBundle@servletRequest"/>
              <uix:styledText styleClass="OraDataText"
                              textBinding="extentManagement@rbsegmentComponent@servletRequest"/>

              <uix:messagePrompt promptBinding="LBL_PUBLIC@uixRbsegmentBundle@servletRequest"/>
              <uix:styledText styleClass="OraDataText"
                              textBinding="public@rbsegmentComponent@servletRequest"/>

              <uix:messagePrompt promptBinding="LBL_STATUS@uixRbsegmentBundle@servletRequest"/>

              <uix:switcher childNameBinding="status@rbsegmentComponent@servletRequest">
                <uix:case name="ONLINE">
                  <uix:styledText styleClass="OraDataText"
                                  textBinding="TXT_ONLINE@uixRbsegmentBundle@servletRequest"/>
                </uix:case>
                <uix:case name="OFFLINE">
                  <uix:styledText styleClass="OraDataText"
                                  textBinding="TXT_OFFLINE@uixRbsegmentBundle@servletRequest"/>
                </uix:case>
              </uix:switcher>

              <uix:messagePrompt promptBinding="LBL_INIT_SIZE@uixRbsegmentBundle@servletRequest"/>
                    
              <uix:flowLayout>
                <uix:styledText styleClass="OraDataText"
                                textBinding="initSize@rbsegmentComponent@servletRequest"/>
                <uix:styledText text=" "/>
                <uix:styledText styleClass="OraDataText"
                                textBinding="initSizeUnitsView@rbsegmentComponent@servletRequest"/>
              </uix:flowLayout>

              <uix:messagePrompt promptBinding="LBL_NEXT_SIZE@uixRbsegmentBundle@servletRequest"/>
                    
              <uix:flowLayout>
                <uix:styledText styleClass="OraDataText"
                                 textBinding="nextSize@rbsegmentComponent@servletRequest"/>
                <uix:styledText text=" "/>
                <uix:styledText styleClass="OraDataText"
                                textBinding="nextSizeUnitsView@rbsegmentComponent@servletRequest"/>
                </uix:flowLayout>
                <uix:messagePrompt promptBinding="LBL_OPT_SIZE@uixRbsegmentBundle@servletRequest"/>
                <uix:flowLayout>
                  <uix:styledText styleClass="OraDataText"
                                  textBinding="optSize@rbsegmentComponent@servletRequest"/>
                  <uix:styledText text=" "/>
                  <uix:styledText styleClass="OraDataText"
                                  textBinding="optSizeUnitsView@rbsegmentComponent@servletRequest"/>
                </uix:flowLayout>

                <uix:messagePrompt promptBinding="LBL_MINIMUM_NUM@uixRbsegmentBundle@servletRequest"/>                    
                <uix:styledText styleClass="OraDataText"
                                textBinding="minimum@rbsegmentComponent@servletRequest"/>

                <uix:messagePrompt promptBinding="LBL_MAXIMUM_NUM@uixRbsegmentBundle@servletRequest"/>
                <uix:styledText styleClass="OraDataText"
                                textBinding="maximum@rbsegmentComponent@servletRequest"/>
              </uix:contents>
            </uix:labeledFieldLayout>

	    <%-- start Statistics section --%>
            <uix:styledText styleClass="OraHeaderSubSub" textBinding="STATISTICS@uixDBObjectBundle@servletRequest" />  

             <uix:labeledFieldLayout labelWidth="20%">
	       <uix:contents>	
                 <uix:messagePrompt promptBinding="LBL_WRAPS@uixRbsegmentBundle@servletRequest"/>
                 <uix:styledText styleClass="OraDataText"
                    		 textBinding="wraps@rbsegmentComponent@servletRequest"/>
		     			
		 <uix:messagePrompt promptBinding="LBL_SHRINKS@uixRbsegmentBundle@servletRequest"/>
                 <uix:styledText styleClass="OraDataText"
                                 textBinding="shrinks@rbsegmentComponent@servletRequest"/>    

		 <uix:messagePrompt promptBinding="LBL_HIGH_WATER_MARK@uixRbsegmentBundle@servletRequest"/>
                 <uix:flowLayout>
                   <uix:styledText styleClass="OraDataText"
                                   textBinding="hwmSize@rbsegmentComponent@servletRequest"/>
	           <uix:styledText  text=" "/>
                   <uix:styledText styleClass="OraDataText"
                      		   textBinding="hwmSizeUnitsView@rbsegmentComponent@servletRequest"/>
		 </uix:flowLayout> 
		     
		 <uix:messagePrompt promptBinding="LBL_ACTIVE_TRANS@uixRbsegmentBundle@servletRequest"/>
                 <uix:styledText styleClass="OraDataText"
                       		 textBinding="xacts@rbsegmentComponent@servletRequest"/>
               </uix:contents>
             </uix:labeledFieldLayout>
	     <%-- End  Statistics section --%>

        </db:form>
      </uix:contents>
    </uix:body>
  </uix:document>
  <%@ include file="/em2go/em2goThinFooter.jspf" %> 
</uix:renderingContext>
