<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<jsp:useBean id="redoLogBean" scope="request"
   type="oracle.sysman.emo.adm.storage.redoLog.RedoLogObject"/>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
   <%@ include file="/em2go/em2goHrGlobal.jspf" %>
   <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="title@redoLogBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form
        name="redologForm" 
        method="post"
        destination="/console/database/em2go/storage/redolog" copyParams="target,type,oname,otype,cancelURL">

        <uix:formValue 
          name="pageName" 
          value="/database/em2go/storage/redolog/generalPage"/>

	<%@ include file="/em2go/em2goBreadCrumbs.jspf" %>
    <uix:rowLayout>
    </uix:rowLayout>
    

    <oem:messageBox messageType="info" 
               errorTableBinding="info@servletRequest"/>

	<uix:styledText styleClass="OraInlineInfoText" textBinding="mainText@info@servletRequest"/>
    
    <oem:messageBox messageType="error" 
              errorTableBinding="errors@servletRequest" />
	
    <uix:styledText styleClass="OraInlineErrorText" textBinding="mainText@errors@servletRequest"/>

          <uix:switcher childNameBinding="creating@redoLogBean@servletRequest" >
            <uix:case name="true">
              <%---  CREATE  ---%>

              <uix:tableLayout cellSpacing="5">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt
                      promptBinding="GROUP_NUM@redologBundle@servletRequest"
                      required="yes" />
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:stackLayout>
                      <uix:textInput
                        name="redoLogName"
                        textBinding="redoLogName@redoLogBean@servletRequest"
                        columns="13"/>
                      <uix:formValue
                        name="id"
                        valueBinding="redoLogName@redoLogBean@servletRequest" />
                      <uix:messageText
                        messageBinding="redoLogName@errors@servletRequest"
                        messageType="error"/>
                    </uix:stackLayout>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt
                      promptBinding="FILE_SIZE@redologBundle@servletRequest"
                      required="yes" />
                  </uix:cellFormat>
                  <uix:cellFormat wrappingDisabled="true" >
                    <uix:flowLayout>
                      <uix:textInput
                        name="fileSize"
                        textBinding="fileSize@redoLogBean@servletRequest"
                        columns="6"/>

                      <oem:choice
                        name="fileSizeUnit"
                        optionsBinding="sizeUnitChoices@redoLogBean@servletRequest"
                        selectedValueBinding="fileSizeUnit@redoLogBean@servletRequest">
                      </oem:choice>
                      <uix:messageText
                        messageBinding="fileSize@errors@servletRequest"
                        messageType="error"/>
                    </uix:flowLayout>
                  </uix:cellFormat>
                </uix:rowLayout>
                <%-- ..... thread # .......--%>
                <uix:rowLayout
                  renderedBinding="ops@redoLogBean@servletRequest">
                  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt
                      promptBinding="THREAD_NUM@redologBundle@servletRequest"
                      required="yes" />
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:stackLayout>
                      <uix:textInput
                        name="threadNum"
                        textBinding="threadNum@redoLogBean@servletRequest"
                        columns="16"/>
                        <uix:messageText
                          messageBinding="thread@errors@servletRequest" messageType="error"/>
                    </uix:stackLayout>
                  </uix:cellFormat>
                </uix:rowLayout>

              </uix:tableLayout>
            </uix:case>
            <uix:case name="false">
              <%---  EDIT ---%>

              <uix:tableLayout cellSpacing="5">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt
                      promptBinding="GROUP_NUM@redologBundle@servletRequest"
                      />
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:stackLayout>
                      <uix:styledText
                        textBinding="redoLogName@redoLogBean@servletRequest"
                        styleClass="OraDataText"  />
                      <uix:formValue
                        name="id"
                        valueBinding="redoLogName@redoLogBean@servletRequest" />
                    </uix:stackLayout>
                  </uix:cellFormat>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt
                      promptBinding="FILE_SIZE@redologBundle@servletRequest"
                      />
                  </uix:cellFormat>
                  <uix:flowLayout>
                    <uix:styledText
                      textBinding="fileSize@redoLogBean@servletRequest"
                      styleClass="OraDataText"  />
                    <uix:spacer width="5" />
                    <uix:styledText
                      textBinding="fileSizeUnit@redoLogBean@servletRequest"
                      styleClass="OraDataText"  />
                  </uix:flowLayout>
                </uix:rowLayout>

                <%-- ..... thread # .......--%>
                <uix:rowLayout
                  renderedBinding="ops@redoLogBean@servletRequest">
                  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt
                      promptBinding="THREAD_NUM@redologBundle@servletRequest"
                      />
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:styledText
                      textBinding="threadNum@redoLogBean@servletRequest"
                      styleClass="OraDataText"  />
                  </uix:cellFormat>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt
                      promptBinding="STATUS@uixDBObjectBundle@servletRequest" />
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:styledText
                      textBinding="status@redoLogBean@servletRequest"
                      styleClass="OraDataText"  />
                  </uix:cellFormat>
                </uix:rowLayout>
              
              </uix:tableLayout>

            </uix:case>
          </uix:switcher>

	  <%--show the dropdowns for edit mode --%>
          <uix:switcher childNameBinding="creating@redoLogBean@servletRequest" >
            <uix:case name="false">
          <uix:rowLayout>
            <uix:contents>
               <uix:flowLayout>
                 <uix:contents>
                    <uix:choice name="optionChoice" selectedIndex="0">
                      <uix:contents childDataBinding="actionsList@redoLogBean@servletRequest">
                        <uix:option textBinding="textKey"
                                  valueBinding="valueKey"/>
                      </uix:contents>
                    </uix:choice>
                    
		    <uix:spacer width="2"/>
                  <uix:submitButton textBinding="GO@uixDBObjectBundle@servletRequest" name="event" value="go"/>
                  </uix:contents>
                  </uix:flowLayout>
                </uix:contents>
           </uix:rowLayout>
          </uix:case>
         </uix:switcher>
      



          
                    <uix:submitButton
                      textBinding="ADD@uixDBObjectBundle@servletRequest"
                      name="event"
                      value="addMember"
                    />
                
            <oem:table
              width="100%"
              formSubmitted="true"
              name="redoLogTableUI"
              dataSourceProp="redoLogTableUI"
              beanKey="redoLogBean"
              alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest"
              destination="/console/database/em2go/storage/redolog"
             />

            <uix:messageText
              messageBinding="membersTable@errors@servletRequest"
              messageType="error"/>

          <uix:rowLayout>
              <uix:submitButton
                name="event"
                value="showSql"
                formName="redologForm"
                textBinding="SHOWSQL@uixDBObjectBundle@servletRequest"
                />

              <uix:switcher childNameBinding="creating@redoLogBean@servletRequest">
                <uix:case name="true">
                    <uix:submitButton
                      textBinding="CANCEL@uixDBObjectBundle@servletRequest"
                      name="event" value="cancel" formName="redologForm"/>  
                </uix:case>
                <uix:case name="false">
                    <uix:submitButton 
                      textBinding="REVERT@uixDBObjectBundle@servletRequest" 
                      name="event" value="revert" formName="redologForm"/>  
                </uix:case>
              </uix:switcher>

              <uix:switcher childNameBinding="creating@redoLogBean@servletRequest">
                <uix:case name="true">
                    <uix:submitButton
                      textBinding="OK@uixDBObjectBundle@servletRequest" 
                      name="event" value="createRedoLog" formName="redologForm"/>
                </uix:case>
                <uix:case name="false">
                    <uix:submitButton 
                      textBinding="APPLY@uixDBObjectBundle@servletRequest" 
                      name="event" value="apply" formName="redologForm"/>
                </uix:case>
              </uix:switcher>

         
          </uix:rowLayout>

      </db:form>
    </uix:body>
  </uix:document>
   <%@ include file="/em2go/em2goThinFooter.jspf" %>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>
