<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%---------------------------------------------------------------
 --  Redo Log page for adding a file to the group members table.
 --  Permits the user to specify the state of the REUSE clause
 --  for a file if and only if that file is being Added.
 ----------------------------------------------------------------%>

<uix:renderingContext id="renderingContext">
   <oem:setURLEncoder id="renderingContext"/>
       <%@ include file="/em2go/em2goHrGlobal.jspf" %>
       <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="title@redoLogBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <%---  Form  ---%>
      <db:form
        name="redologAddForm" 
        method="post"
        destination="/console/database/em2go/storage/redolog" copyParams="target,type,cancelURL,oname,otype">

        <%---  Page Name ---%>
        <uix:formValue 
          name="pageName" 
          value="/database/em2go/storage/redolog/redoLogAdd"/>

    
        <%---  Page Layout and the main Header ---%>
       

          <%@ include file="/em2go/em2goBreadCrumbs.jspf" %>
          <uix:rowLayout>
          </uix:rowLayout>
          <%---  Message Boxes ---%>
          <oem:messageBox messageType="info" 
            errorTableBinding="info@servletRequest"/>
          <uix:styledText styleClass="OraInlineInfoText" textBinding="info@servletRequest"/>
         
 	<oem:messageBox messageType="error" 
            errorTableBinding="errors@servletRequest"/>

	<uix:styledText styleClass="OraInlineErrorText" textBinding="errors@servletRequest"/>


          <%-----------------------------
           -  Labeled Fields
           -----------------------------%>
          <uix:tableLayout cellSpacing="5" >
            <%------------------------%>
            <%---  Log File Name   ---%>
            <%------------------------%>
            <uix:rowLayout>
              
              <%---  Prompt  ---%>
              <uix:cellFormat hAlign="right">
                <uix:messagePrompt
                  required="yes"
                  prompt="Name"/>
              </uix:cellFormat>

              <%---  Field  ---%>
              <uix:cellFormat>
                <uix:textInput 
                  name="addMemberName"
                  textBinding="addMemberName@redoLogBean@servletRequest" columns="16"/>
              
              <uix:messageText
                messageBinding="redoLogName@errors@servletRequest"
                messageType="error"/>
                
              </uix:cellFormat>
            </uix:rowLayout>
            <%------------------------%>
            <%---  Directory Path  ---%>
            <%------------------------%>
            <uix:rowLayout>

              <%---  Prompt  ---%>
              <uix:cellFormat hAlign="right">
                <uix:messagePrompt
                  required="yes"
                  prompt="Directory"/>
              </uix:cellFormat>

              <%---  Field  ---%>
              <uix:cellFormat>
                <uix:textInput 
                  name="addMemberPath"
                  textBinding="addMemberPath@redoLogBean@servletRequest"
                  columns="16"/>

              <uix:messageText
                messageBinding="redoLogDir@errors@servletRequest"
                messageType="error"/>
              </uix:cellFormat>

            </uix:rowLayout>

            <%------------------------%>
            <%---  Reuse Setting   ---%>
            <%------------------------%>
            <uix:switcher childNameBinding="addedMember@redoLogBean@servletRequest">
              <uix:case name="true">

                <uix:rowLayout>

                  <%---  Prompt  ---%>
                  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt
                      promptBinding="CHECK_REUSE@redologBundle@servletRequest"/>
                  </uix:cellFormat>

                  <%---  Field  ---%>
                  <uix:cellFormat>
                    <uix:checkBox
                      name="addMemberReuse"
                      checkedBinding="addMemberReuse@redoLogBean@servletRequest"
                    />
                  </uix:cellFormat>

                </uix:rowLayout>

              </uix:case>
            </uix:switcher>

          </uix:tableLayout>


          <%---------------
           -  PageButtons
           ----------------%>
        
            <uix:rowLayout>

              <%---  Cancel Button  ---%>
              <uix:submitButton 
                name="event" 
                textBinding="CANCEL@uixDBObjectBundle@servletRequest"
                value="cancelAddMember"/>  

              <%---  OK Button  ---%>
              <uix:submitButton
                name="event"
                textBinding="OK@uixDBObjectBundle@servletRequest"
                value="applyAddMember"/>  

          </uix:rowLayout>

      </db:form>
    </uix:body>
  </uix:document>
        <%@ include file="/em2go/em2goThinFooter.jspf" %>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>
