<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<jsp:useBean id="redoLogBean" scope="request"
   type="oracle.sysman.emo.adm.storage.redoLog.RedoLogObject"/>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <%@ include file="/em2go/em2goHrGlobal.jspf" %>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="title@redoLogBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form
        name="redologViewForm" 
        method="get"
        destination="/console/database/em2go/storage/redolog" copyParams="target,type,oname,otype,cancelURL">

        <uix:formValue 
          name="pageName" 
          value="/database/em2go/storage/redolog/redoLogView"/>

        <uix:pageLayout titleBinding="header@redoLogBean@servletRequest">

          <%@ include file="/em2go/em2goBreadCrumbs.jspf" %>
            <oem:messageBox messageType="info" 
                errorTableBinding="info@servletRequest"/>
                <uix:styledText styleClass="OraInlineInfoText" textBinding="info@servletRequest"/>
         
            <oem:messageBox messageType="error" 
                errorTableBinding="errors@servletRequest"/>
                <uix:styledText styleClass="OraInlineErrorText" textBinding="errors@servletRequest"/>



          <uix:tableLayout cellSpacing="5">
            
            <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                <uix:messagePrompt
                  promptBinding="GROUP_NUM@redologBundle@servletRequest"
                  />
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:stackLayout>
                  <uix:styledText
                    textBinding="redoLogName@redoLogBean@servletRequest"
                    styleClass="OraDataText"  />
                  <uix:formValue
                    name="id"
                    valueBinding="redoLogName@redoLogBean@servletRequest" />
                </uix:stackLayout>
                <uix:messageText
                  messageBinding="thread@errors@servletRequest"
                  messageType="error"/>
              </uix:cellFormat>
            </uix:rowLayout>

            <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                <uix:messagePrompt
                  promptBinding="FILE_SIZE@redologBundle@servletRequest"
                  />
              </uix:cellFormat>
              <uix:flowLayout>
                <uix:styledText
                  textBinding="fileSize@redoLogBean@servletRequest"
                  styleClass="OraDataText"  />
                <uix:spacer width="5" />
                <uix:styledText
                  textBinding="fileSizeUnit@redoLogBean@servletRequest"
                  styleClass="OraDataText"  />
              </uix:flowLayout>
            </uix:rowLayout>

            <%-- ..... thread # .......--%>
            <uix:rowLayout
              renderedBinding="ops@redoLogBean@servletRequest">
              <uix:cellFormat hAlign="right">
                <uix:messagePrompt
                  promptBinding="THREAD_NUM@redologBundle@servletRequest"
                  />
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:styledText
                  textBinding="threadNum@redoLogBean@servletRequest"
                  styleClass="OraDataText"  />
                <uix:messageText
                  messageBinding="thread@errors@servletRequest"
                  messageType="error"/>
              </uix:cellFormat>
            </uix:rowLayout>

            <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                <uix:messagePrompt
                  promptBinding="STATUS@uixDBObjectBundle@servletRequest" />
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:styledText
                  textBinding="status@redoLogBean@servletRequest"
                  styleClass="OraDataText"  />
              </uix:cellFormat>
            </uix:rowLayout>
            
            <%
            if (request.getAttribute("operationsChoiceBean") != null)
            { %>
                 <uix:rowLayout>
                    <uix:contents>
                      <uix:cellFormat hAlign="right">
                        <uix:messagePrompt promptBinding="ACTIONS@uixDBObjectBundle@servletRequest" />
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="left">
                      <uix:flowLayout>
                      <uix:contents>
                         <uix:spacer width="3"/>
                         <uix:choice name="selectedOperationChoice"
                                  shortDescBinding="ACTIONS@uixDBObjectBundle@servletRequest"
                                  selectedValueBinding="selectedOperationChoice@operationsChoiceBean@servletRequest">
                              <uix:contents childDataBinding="operationsChoiceInfo@operationsChoiceBean@servletRequest">
                                <uix:option textBinding="textKey"
                                            valueBinding="valueKey"/>
                              </uix:contents>
                          </uix:choice>
                      <uix:spacer width="2"/>
                      <uix:submitButton textBinding="GO@uixDBObjectBundle@servletRequest" name="event" value="operationsGo"/>
                      </uix:contents>
                      </uix:flowLayout>
                      </uix:cellFormat>
                    </uix:contents>
               </uix:rowLayout>
               <% }
                %>
          </uix:tableLayout>

          <uix:header
            textBinding="REDO_LOG_MEMBERS@redologBundle@servletRequest">

            <oem:table 
              name="redoLogTableUI"
              width="100%"
              alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest"
              destination="/console/database/em2go/storage/redolog"
              formSubmitted="true" 
              beanKey="redoLogBean"
              dataSourceProp="redoLogTableUI"
              > 
            </oem:table>

          </uix:header>
          
          <uix:spacer height="7"/>
          <uix:tableLayout>
            <uix:rowLayout>
              <uix:cellFormat hAlign="left">
                  <uix:flowLayout>
                    <uix:submitButton textBinding="EDIT@uixDBObjectBundle@servletRequest" 
                                      name="event" 
                                      value="editFromView" />

                      <%-- OK Button --%>
                      <uix:submitButton textBinding="RETURN@uixDBObjectBundle@servletRequest" 
                                        name="event" 
                                        value="cancel" />

                  </uix:flowLayout>
                </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>

        </uix:pageLayout>
      </db:form>
    </uix:body>

  </uix:document>
  <%@ include file="/em2go/em2goThinFooter.jspf" %>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>
