<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<jsp:useBean id="datafilesBean" scope="request"
   type="oracle.sysman.emo.adm.storage.tablespace.TSDatafiles"/>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <%@ include file="/em2go/em2goHrGlobal.jspf" %>
  <uix:document>
    <uix:metaContainer>
      <uix:head titleBinding="title@mainEmoBean@servletRequest"/>
    </uix:metaContainer>
    <uix:body>
    <uix:contents>
    <db:form name="foo" method="post" 
             destination="/console/database/em2go/storage/tablespace"
             copyParams="target,type,oname,cancelURL,otype">
    <uix:formValue name="pageName" value="/database/em2go/storage/tablespace/generalPage"/>
     
        
    <%@ include file="/em2go/em2goBreadCrumbs.jspf" %>
    
    <uix:rowLayout>
    </uix:rowLayout>

    <uix:flowLayout>
    <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"/>
    <uix:styledText styleClass="OraInlineInfoText" textBinding="mainText@info@servletRequest"/>
   </uix:flowLayout>
  <uix:flowLayout>
    <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"/>
    <uix:styledText styleClass="OraInlineErrorText" textBinding="mainText@errors@servletRequest"/>
   </uix:flowLayout> 
      


    <uix:tableLayout>
      <uix:rowLayout>
        <uix:cellFormat hAlign="right">
         <% if (((oracle.sysman.emo.adm.storage.tablespace.Tablespace)request.getAttribute("mainEmoBean")).isCreating()) {%>
        
              <uix:messagePrompt promptBinding="NAME@tablespaceBundle@servletRequest"
                                 required="yes" />
             <%} else {%> 
              <uix:messagePrompt promptBinding="NAME@uixDBObjectBundle@servletRequest" />
          <%} %> 
        </uix:cellFormat>
        <uix:cellFormat hAlign="left">
        <% if (((oracle.sysman.emo.adm.storage.tablespace.Tablespace)request.getAttribute("mainEmoBean")).isCreating()) {%>
        
               <uix:textInput name="tablespaceName"
                               textBinding="tablespaceName@defaultBean@servletRequest"
                               columns="19"/>
            <%} else {%> 
               <% if (((oracle.sysman.emo.adm.storage.tablespace.Tablespace)request.getAttribute("mainEmoBean")).isVersion10iOrHigher()) {%>
        
                  <uix:textInput name="tablespaceName"
                                   textBinding="tablespaceName@defaultBean@servletRequest"
                                   columns="19"/>
                <%} else {%>
                    <uix:spacer width="3"/>
                    <uix:styledText  styleClass="OraDataText"
                               textBinding="tablespaceName@defaultBean@servletRequest"/>
                <%} %> 
          <%} %> 
          <uix:messageText messageBinding="tablespaceName@errors@servletRequest" messageType="error"/>
        </uix:cellFormat>
      </uix:rowLayout>
   
      <uix:rowLayout>
         <uix:cellFormat hAlign="right">
            <uix:switcher childNameBinding="editingandBft@defaultBean@servletRequest">
              <uix:case name="true">
                  <uix:messagePrompt promptBinding="BFT_LABEL@tablespaceBundle@servletRequest"/>
               </uix:case>
            </uix:switcher>
          </uix:cellFormat>
          <uix:cellFormat hAlign="left">
           <uix:switcher childNameBinding="editingandBft@defaultBean@servletRequest">
              <uix:case name="true">
                  <uix:styledText  styleClass="OraDataText"
                       textBinding="YES@tablespaceBundle@servletRequest"/>
             </uix:case>
             </uix:switcher>
          </uix:cellFormat>
      </uix:rowLayout>
       <% if (((oracle.sysman.emo.adm.storage.tablespace.Tablespace)request.getAttribute("mainEmoBean")).isEditing()) {%>
        
          <%--show the dropdowns for edit mode --%>
           
             <uix:rowLayout>
                <uix:contents>
                  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt prompt="Actions" />
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                  <uix:flowLayout>
                  <uix:contents>
                     <uix:spacer width="3"/>
                    <uix:choice name="optionChoice" selectedIndex="0">
                      <uix:contents childDataBinding="actionsList@defaultBean@servletRequest">
                      <uix:option textBinding="textKey"
                                  valueBinding="valueKey"/>
                    </uix:contents>
                  </uix:choice>
                  <uix:spacer width="2"/>
                  <uix:submitButton textBinding="GO@uixDBObjectBundle@servletRequest" name="event" value="go"/>
                  </uix:contents>
                  </uix:flowLayout>
                  </uix:cellFormat>
                </uix:contents>
           </uix:rowLayout>
    
        <%} %>
    </uix:tableLayout>          
          
        <%-- End tablespace Name --%>

        <%-- try scriplet here to save white space in pda --%>
        <% if (((oracle.sysman.emo.adm.storage.tablespace.Tablespace)request.getAttribute("mainEmoBean")).isCreating()) {%>
        <uix:tableLayout width="100%">

            <%--ExtentManagement Area --%>
              <%--uix:switcher childNameBinding="81OrHigher@defaultBean@servletRequest"--%>
              <% if (((oracle.sysman.emo.adm.storage.tablespace.Tablespace)request.getAttribute("mainEmoBean")).is81OrHigher()) {%>
        
                <%--uix:case name="true"--%>
                <uix:rowLayout>
                
                        <uix:cellFormat wrappingDisabled="true">
                            <oem:radioButton name="extentMgmtType"
                                   disabled="false"
                                   textBinding="LOCALLY_MANAGED@tablespaceBundle@servletRequest"
                                   value="EXTENT_LOCAL"
                                   selectedValueBinding="extentMgmtType@extentMgmtUIBean@servletRequest"/>

                        </uix:cellFormat>
                        <uix:spacer width="2"/>
                        <uix:cellFormat wrappingDisabled="true">
                            <oem:radioButton name="extentMgmtType"
                                   disabled="false"
                                   textBinding="DICTIONARY_MANAGED@tablespaceBundle@servletRequest"
                                   value="EXTENT_DICTIONARY"
                                   selectedValueBinding="extentMgmtType@extentMgmtUIBean@servletRequest"/>
                        </uix:cellFormat>
                 </uix:rowLayout>
              <%} %> 
          </uix:tableLayout>
          <uix:tableLayout>
            <uix:rowLayout>
            
                    <uix:cellFormat wrappingDisabled="true">
                        <oem:radioButton name="tablespaceType"
                                     disabledBinding="permanentDisabled@defaultBean@servletRequest"
                                     textBinding="PERMANENT@tablespaceBundle@servletRequest"
                                     value="Permanent"
                                     selectedValueBinding="tablespaceType@generalPageUIBean@servletRequest"/>
                    </uix:cellFormat>
                    <uix:cellFormat wrappingDisabled="true">
                        <oem:radioButton name="tablespaceType"
                                     textBinding="TEMPORARY@tablespaceBundle@servletRequest"
                                     value="Temporary"
                                     disabledBinding="temporaryDisabled@defaultBean@servletRequest"
                                     selectedValueBinding="tablespaceType@generalPageUIBean@servletRequest"/>
                    </uix:cellFormat>
                   
                    <uix:cellFormat wrappingDisabled="true">
                         <% if (((oracle.sysman.emo.adm.storage.tablespace.Tablespace)request.getAttribute("mainEmoBean")).is90OrHigher()) {%>
           
                              <oem:radioButton name="tablespaceType"
                                             textBinding="UNDO@tablespaceBundle@servletRequest"
                                             value="Undo"
                                             selectedValueBinding="tablespaceType@generalPageUIBean@servletRequest"
                                             disabledBinding="undoDisabled@defaultBean@servletRequest"/>
                         
                     <%} %> 
                  </uix:cellFormat>
              </uix:rowLayout> 
           </uix:tableLayout>
            <uix:tableLayout>
            <uix:rowLayout>
                 <uix:cellFormat wrappingDisabled="true">
                    <oem:radioButton name="modeType"
                                     value="ReadWrite"
                                     disabledBinding="readWriteDisabled@defaultBean@servletRequest"
                                     textBinding="READ_WRITE@tablespaceBundle@servletRequest"
                                     selectedValueBinding="modeType@generalPageUIBean@servletRequest"/>
                  </uix:cellFormat>
                  <uix:cellFormat wrappingDisabled="true">
                 
                    <uix:radioButton name="modeType"
                                     value="ReadOnly"
                                     disabledBinding="readOnlyDisabled@defaultBean@servletRequest"
                                     textBinding="READ_ONLY@tablespaceBundle@servletRequest"
                                     selectedValueBinding="modeType@generalPageUIBean@servletRequest"/>
                   </uix:cellFormat>

                  <uix:cellFormat wrappingDisabled="true">
                    <oem:radioButton name="modeType"
                                     value="Offline"
                                     disabledBinding="offlineDisabled@defaultBean@servletRequest"
                                     textBinding="OFFLINE@tablespaceBundle@servletRequest"
                                     selectedValueBinding="modeType@generalPageUIBean@servletRequest"/>
                 </uix:cellFormat>

                  <uix:switcher childNameBinding="localAndTemp@defaultBean@servletRequest">
                    <uix:case name="false">
                      <uix:switcher  childNameBinding="creating@defaultBean@servletRequest">
                        <uix:case name="false">
                          <uix:rowLayout hAlign="start">
                            <uix:flowLayout>
                              <uix:spacer width="3"/>
                              <uix:messagePrompt promptBinding="OFFLINE_MODE@tablespaceBundle@servletRequest"/>
                              <uix:spacer width="3"/>
                              <oem:choice name="offlineMode"
                                        disabledBinding="currentlyOffline@generalPageUIBean@servletRequest"
                                        selectedValueBinding="offlineMode@generalPageUIBean@servletRequest"
                                        optionsBinding="offlineModes@generalPageUIBean@servletRequest"/>
                            </uix:flowLayout>
                          </uix:rowLayout>
                        </uix:case>
                      </uix:switcher>
                    </uix:case>
                  </uix:switcher>

              </uix:rowLayout>
       </uix:tableLayout>

         
        <%} %>

        <% if (((oracle.sysman.emo.adm.storage.tablespace.Tablespace)request.getAttribute("defaultBean")).isCreateand10i()) {%>
            
                  <uix:tableLayout>
                  <uix:rowLayout>
                    <uix:checkBox
                        name="singleDatafile"
                        disabledBinding="disablesftineditmode@defaultBean@servletRequest"
                        checkedBinding="singleDatafile@defaultBean@servletRequest"
                        textBinding="SINGLE_DATAFILE@tablespaceBundle@servletRequest" />
                  </uix:rowLayout>
                  
                  <uix:rowLayout>                                       
                    <uix:cellFormat hAlign="left">
                      <uix:styledText styleClass="OraInlineInfoText" textBinding="BFT_HINT@tablespaceBundle@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>                                                         
                  </uix:tableLayout>                  
           
            <%} %>
            
  
                    <uix:submitButton textBinding="ADD_DATAFILE@uixDBObjectBundle@servletRequest"
                                      name="event"
                                      value="addDatafile"/>
              
                    <uix:messageText messageBinding="datafilesTable@errors@servletRequest"
                               messageType="error"/>
               
                 <oem:table name="datafilesTable"
                         width="100%"
                         formSubmitted="true"
                         dataSourceProp="datafilesTable" 
                         beanKey="datafilesUIBean" copyParams="target,type,oname"
                         alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest">
                
                </oem:table>
                 
              
               
           <uix:spacer height="7"/>
         <uix:tableLayout>
          <uix:rowLayout>
            <uix:cellFormat hAlign="left">
              <uix:submitButton textBinding="SHOWSQL@uixDBObjectBundle@servletRequest"
                                name="event"
                                value="showSql"
                                formName="foo"/>
              <uix:switcher childNameBinding="creating@defaultBean@servletRequest">
                <uix:case name="true">
                  <uix:flowLayout>
                    <uix:submitButton textBinding="CANCEL@uixDBObjectBundle@servletRequest"
                                      name="event"
                                      value="cancel"
                                      formName="foo"/>
                    <uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest"
                                      name="event"
                                      value="apply"
                                      formName="foo"/>
                  </uix:flowLayout>
                </uix:case>
                <uix:case name="false">
                  <uix:flowLayout>
                    <uix:submitButton textBinding="REVERT@uixDBObjectBundle@servletRequest"
                                      name="event"
                                      value="revert"
                                      formName="foo"/>
                    <uix:submitButton textBinding="APPLY@uixDBObjectBundle@servletRequest"
                                      name="event"
                                      value="apply"
                                      formName="foo"/>
                  </uix:flowLayout>
                </uix:case>
              </uix:switcher>
     </uix:cellFormat>
     </uix:rowLayout>
     </uix:tableLayout>
    
      
      </db:form>
      </uix:contents>
      </uix:body>

     </uix:document>
     <%@ include file="/em2go/em2goThinFooter.jspf" %> 
    </uix:renderingContext>

