<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

   <%--ResourceBundle for labels/headers specific to ESA Project--%>
          <uix:bundle name="esaResourceBundle"
                                  class="oracle.sysman.resources.eml.esa.EsaMsg"/>

          <uix:bundle name="ecmPatchResourceBundle"
                                  class="oracle.sysman.eml.ecm.patch.util.PatchResourceBundle"/>
          <uix:bundle name="patchResourceBundle"
                                  class="oracle.sysman.eml.ecm.patch.util.PatchResourceBundle"/>
          <%--ResourceBundle for common labels/headers etc--%>
      <uix:bundle name="commonResourceBundle"
                                  class="oracle.sysman.resources.CommonResourceBundle"/>
      <uix:bundle name="sdkUIMsg" 
                                  class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
      <uix:bundle name="featurePatchesMsg" 
                                  class="oracle.sysman.db.rsc.featurePatches.DBFeaturePatchesMsg"/>
      <uix:bundle name="dbMsg" 
                                  class="oracle.sysman.db.rsc.inst.DBMsg"/>
      <uix:bundle name="dbPAMsg" 
                                  class="oracle.sysman.db.pa.ui.rb.PatchAdvisorRB"/>

  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="FBP_PAGE_HEADER@dbMsg"/>
    </uix:metaContainer>

    <uix:body>
      <db:form 
        copyParams="target,type,cancelURL,oname,otype,fp_oh_location,fp_target"
        name="featurePatchesForm"  
        method="post"
        destination="/console/database/featurePatches">

        <uix:formValue 
          name="pageName" 
          value="/database/featurePatches/featurePatches"/>

        <uix:pageLayout
          titleBinding="FBP_PAGE_HEADER@featurePatchesMsg"
          >

          <%@ include file="/database/global.jspf" %>

          <%-----------------------------------------
           -            Message Boxes               -
           -----------------------------------------%>
          <oem:messageBox messageType="info" 
                          errorTableBinding="info@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error" 
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>


            <%-- uix:tableLayout width="100%"> 
              <uix:rowLayout --%>

                <%------------------------
                 -  Introduction Text
                 ------------------------%>
                <%-- uix:cellFormat hAlign="left">
                  <uix:styledText
                    styleClass="oraFieldText"
                    textBinding="FEATURE_PATCHES_DESC@dbFeaturePatchesBundle@servletRequest"/>    
                </uix:cellFormat>

              </uix:rowLayout>
            </uix:tableLayout > 

            <uix:spacer height="15"/>
            <%@ include file="/database/featurePatches/featurePatchesLabeledFieldsInc.jspf" --%>
            <uix:spacer height="15"/>
               <uix:header textBinding="CPF_PATCHES@featurePatchesMsg">

                   <uix:table 
                       name="patch_advisories"
                       id="patch_advisories_id"
                       width="100%"
                       partialRenderMode="self"
                       summaryBinding="CPF_PATCHES@featurePatchesMsg"
                       showAll="yes"
                       valueBinding="currentValue@cpfDefaultBean@servletRequest"
                       minValueBinding="minValue@cpfDefaultBean@servletRequest"
                       blockSizeBinding="blockSize@cpfDefaultBean@servletRequest"
                       maxValueBinding="maxValue@cpfDefaultBean@servletRequest" 
                       alternateTextBinding="NO_ADVISORIES_FOUND@patchResourceBundle"
                       tableDataBinding="rows@cpfDefaultBean@servletRequest"
                       columnHeaderDataBinding="columnHeaders@cpfDefaultBean@servletRequest">
                   <uix:tableFormat tableBanding="rowBanding"/>
                       <uix:columnHeaderStamp>
                       <uix:sortableHeader 
                            textBinding="text"
                            sortableBinding="sortable">
                       </uix:sortableHeader>
                       </uix:columnHeaderStamp>
                    <uix:tableSelection>
                       <uix:singleSelection selectedIndexBinding="index@cpfDefaultBean@servletRequest" shortDesc="Select Remedies">
                           <uix:submitButton name="event" formName="featurePatchesForm"
                                textBinding="LBL_SHOW_REMEDIES@patchResourceBundle"
                                value="showRemediesForAlert"/>
                           </uix:singleSelection>
                       </uix:tableSelection>
                       <uix:column>
                           <uix:contents>
                              <uix:styledText textBinding="advisory" destinationBinding="advisoryLink"/>
                              <uix:formValue name="rowKey" valueBinding="rowKey"/>
                           </uix:contents>
                     </uix:column>
                     <uix:styledText textBinding="impact"/>
                     <uix:styledText textBinding="abstract"/>
                     <uix:column>
                           <uix:contents>
                              <uix:columnFormat
                                   cellNoWrapFormat="true" columnDataFormat="numberFormat" />
                              <uix:styledText textBinding="hosts"/>
                           </uix:contents>
                     </uix:column>
                     <uix:column>
                            <uix:contents>
                               <uix:columnFormat cellNoWrapFormat="true"
                                                 columnDataFormat="numberFormat" />
                               <uix:styledText textBinding="homes"/>
                             </uix:contents>
                      </uix:column>

                 </uix:table>
                </uix:header>
            <uix:spacer height="15"/>

            <%------------------------
             -  Feature Usage Table
             ------------------------%>
               <uix:header textBinding="FBP_PATCHES@featurePatchesMsg">
          <uix:messageChoice name="isUsed" promptBinding="FP_VIEW@featurePatchesMsg" selectedIndexBinding="recoTypeIndex@servletRequest" >
            <uix:contents>
               <uix:option textBinding="FP_VIEW_ALL@featurePatchesMsg" value="false"/>
               <uix:option textBinding="FP_VIEW_USAGE_BASED@featurePatchesMsg" value="true"/>
           </uix:contents>
           <uix:end>
             <uix:flowLayout>
               <uix:contents>
                  <uix:submitButton formName="featurePatchesForm" textBinding="FP_GO@featurePatchesMsg" value="go"/>
               </uix:contents>
             </uix:flowLayout>
           </uix:end>
          </uix:messageChoice>
            <oem:table 
              summaryBinding="FBP_PATCHES@dbFeaturePatchesBundle@servletRequest"
              width="100%" 
              blockSize="25"
              formSubmitted="true"
              name="recoTable" 
              dataSourceProp="recoTable"
              beanKey="featurePatchesRecoBean"
              alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest"
              >

            <uix:tableSelection>
            <uix:multipleSelection
              rendered="true"
              shortDesc="SELECT"
              selectedBinding="rowSelected">
              <uix:submitButton
                name="event"
		value="applyPatch"
                rendered="true"
                textBinding="SCHED_APPLY@featurePatchesMsg"/>
            </uix:multipleSelection>
          </uix:tableSelection>
          </oem:table>
          <uix:tip>
             <uix:contents>
             <uix:styledText styleClass="OraTipText" textBinding="FP_PREREQ_TIP@featurePatchesMsg"/>
             </uix:contents>
          </uix:tip>
          </uix:header>
           <%--uix:spacer height="15"/>
            <%@ include file="/database/featurePatches/featurePatchesLabeledFieldsInc.jspf" --%>
           <uix:spacer height="10"/>
          <%@ include file="/database/featurePatches/featurePatchesRelatedLinks.jspf" %>

        </uix:pageLayout>
      </db:form>
    </uix:body>

  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>
