<%--
  -- Page:        haConfigAdvisor.jsp
  -- Controller:  oracle.sysman.db.ha.HAController
  -- Bean:        oracle.sysman.emo.ha.HAConfigAdvisorBean
  --
  -- Description: Displays the Configuration Advisor page (table).
  --
  --  MODIFIED    (MM/DD/YY)
  --     gallison  08/29/08 - 
  --     sdizdar   08/28/08 - created
  --%>

<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ page import="oracle.sysman.emo.ha.HAConfigAdvisorBean" %>
<%@ page import="oracle.sysman.emo.ha.HABean" %>

<uix:renderingContext configuration="dashboardConfig" id="renderingContext">
  <uix:bundle name="HABundle" class="oracle.sysman.db.rsc.ha.HAPageMsg"/>
  <uix:bundle name="DBMsgBundle" class="oracle.sysman.db.rsc.inst.DBMsg"/>
  <uix:bundle name="mntrResourceBundle" class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="sdkUIBundle" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer> 
      <uix:head titleBinding="CONFIG_ADVISOR_DESC@HABundle@servletRequest"/> 
      <meta http-equiv="Refresh" content=<%=request.getAttribute("pageRefresh") %>>
    </uix:metaContainer> 
    
  <uix:body>
    <db:form name="configAdvisor" 
             destination="/em/console/database/haConsole" 
             copyParams="target,type">

      <uix:pageLayout titleBinding="configAdvisorHeader@HABean@servletRequest">
        <%@ include file=" /oemGlobal.jspf"%>
        <uix:formValue name="pageName" value="/database/ha/haConfigAdvisor"/>
        <uix:tableLayout cellSpacing="0" width="100%">
          <uix:dataScope currentDataBinding="HAConfigAdvisorBean@servletRequest">

            <uix:rowLayout width="100%">
              <uix:cellFormat>
              <db:link textBinding="MAA@HABundle@servletRequest"
                        destination="http://www.oracle.com/technology/deploy/availability/htdocs/maa.htm" />
              <uix:styledText styleClass="OraTipText" textBinding="MAA_DESC@HABundle@servletRequest" />
              <uix:styledText styleClass="OraTipText" textBinding="MAA_DESC2@HABundle@servletRequest" />
              <uix:styledText styleClass="OraTipText" textBinding="MAA_DESC3@HABundle@servletRequest" />
              </uix:cellFormat>
            </uix:rowLayout>            

            <uix:rowLayout width="100%">
                <uix:spacer height="5"  />
            </uix:rowLayout>            

<% 
    HABean haBean = ((HABean)(request.getAttribute("HABean")));
    if (haBean != null && haBean.getIsEnterpriseMode()) {
%>

          <uix:tableLayout cellSpacing="2" width="100%">

        <uix:switcher childNameBinding="isMaaCompliant@HABean@servletRequest" >
         <uix:case name="true">          
              <uix:rowLayout width="100%">
                <uix:cellFormat hAlign="right"  width="10%" wrappingDisabled="true">
                 <uix:messagePrompt promptBinding="MAA_SUMMARY@HABundle@servletRequest" renderedBinding="isMaaCompliant@HABean@servletRequest"/>
                </uix:cellFormat>
                <uix:cellFormat >
                  <uix:spacer width="5" />
                 <uix:styledText styleClass="OraDataText" textBinding="maaLevel@HABean@servletRequest" renderedBinding="isMaaCompliant@HABean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>      
        </uix:case>
         <uix:case name="false">          
              <uix:rowLayout width="100%">
                <uix:cellFormat hAlign="right"  wrappingDisabled="true">
                 <uix:messagePrompt promptBinding="MAA_SUMMARY@HABundle@servletRequest" />
                </uix:cellFormat>
                <uix:cellFormat >
                  <uix:spacer width="5" />
                   <uix:styledText styleClass="OraDataText" textBinding="maaSummary@HABean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>      
        </uix:case>
        </uix:switcher>
        <uix:switcher childNameBinding="isMaaCompliant@HABean@servletRequest" >
         <uix:case name="false">   
              <uix:rowLayout width="100%">
                <uix:cellFormat hAlign="right"  wrappingDisabled="true">
                 <uix:messagePrompt promptBinding="RECOMMENDATION@HABundle@servletRequest" />
                </uix:cellFormat>
                <uix:cellFormat >
                  <uix:spacer width="5" />
                  <uix:styledText styleClass="OraDataText" textBinding="maaRecommendation@HABean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>      
        </uix:case>
        </uix:switcher>
            </uix:tableLayout >
<% } %>

            <uix:rowLayout width="100%">
                <uix:spacer width="5"  />
            </uix:rowLayout>            

          <uix:tableLayout width="100%">
            <uix:rowLayout >

              <uix:cellFormat hAlign="left" >
                <uix:styledText styleClass="OraPromptText" labeledNodeId="refreshChoiceID" textBinding="SHOW@HABundle@servletRequest"/>
                <uix:choice name="showAllTxn" id="showAllTxnID" 
                    onChange="submitForm('configAdvisor', true, {'event':'configAdvisor'})"
                    selectedValueBinding="maaConfigStatus@HABean@servletRequest" >
                  <uix:option textBinding="RECOMMENDATIONS_ONLY@HABundle@servletRequest"  value="1" />
                  <uix:option textBinding="ALL_SOLUTIONS@HABundle@servletRequest"  value="3" />
                </uix:choice>

             </uix:cellFormat>

            </uix:rowLayout>
          </uix:tableLayout>
          
            <uix:rowLayout vAlign="middle">                
                <uix:stackLayout>
                    <uix:table name                 = "haConfigAdvisorBean" 
                               alternateTextBinding = "maaNoData@HABean@servletRequest"
                               formSubmitted        = "true"
                               summaryBinding       = "maaNoData@HABean@servletRequest"             
                               width                =  "100%"
                               tableDataBinding     = "<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                               minValue             = "1"
                               valueBinding         = "<%= UIXDataSource.S_START_INDEX_ATTR %>"
                               blockSizeBinding     = "<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                               maxValueBinding      = "<%= UIXDataSource.S_NUM_ROWS_ATTR %>">
                                                
                          <uix:tableFormat tableBanding="rowBanding"/>
                          <uix:column>
                           <uix:columnHeader>
                            <uix:sortableHeader textBinding="OUTAGE_TYPE@HABundle@servletRequest" sortable="true"/>    
                           </uix:columnHeader>  
                           <uix:spacer height="1" width="120"/>
                           <uix:columnFormat columnDataFormat="textFormat"/>
                           <uix:styledText textBinding="OUTAGE_TYPE"/>
                           <uix:spacer height="13" width="120"/>
                          </uix:column>

                          <uix:column>
                           <uix:columnHeader>
                            <uix:sortableHeader textBinding="ORACLE_SOLUTION@HABundle@servletRequest" sortable="true"/>
                           </uix:columnHeader>  
                           <uix:spacer height="1" width="100"/>
                           <uix:columnFormat columnDataFormat="textFormat" />
                            <uix:switcher childNameBinding="ORACLE_IS_SUPPORTED" >
                             <uix:case name="true">          
                               <uix:link textBinding="ORACLE_SOL_TEXT" destinationBinding="ORACLE_SOL_URL"/>
                            </uix:case>
                             <uix:case name="false">          
                             <uix:styledText textBinding="ORACLE_SOL_TEXT"/>
                            </uix:case>
                            </uix:switcher>
                           <uix:spacer height="13" width="100"/>
                          </uix:column>

                          <uix:column>
                           <uix:columnHeader>
                            <uix:sortableHeader textBinding="PRIORITY@HABundle@servletRequest" sortable="true"/>
                           </uix:columnHeader>  
                           <uix:spacer height="1" width="10"/>
                           <uix:columnFormat width="40" columnDataFormat="iconButtonFormat" />
                           <uix:link textBinding="ORACLE_PRI_TEXT_INDEX" />
                           <uix:spacer height="13" width="10"/>
                          </uix:column>

                            <uix:column renderedBinding="showMaaForAllDatabases@HABean@servletRequest">
                             <uix:columnHeader>
                              <uix:sortableHeader textBinding="TARGET_NAME_ROLE@HABundle@servletRequest"sortable="true"/>
                             </uix:columnHeader>  
                             <uix:spacer height="1" width="10"/>
                             <uix:columnFormat width="40" columnDataFormat="textFormat" />
                             <uix:link textBinding="NAME_ROLE" />
                             <uix:spacer height="13" width="10"/>
                            </uix:column>

                          <uix:column>
                           <uix:columnHeader>
                            <uix:sortableHeader textBinding="CONFIGURATION_STATUS@HABundle@servletRequest" sortable="true"/>
                           </uix:columnHeader>  
                           <uix:spacer height="1" width="10"/>
                           <uix:columnFormat width="40"  columnDataFormat="iconButtonFormat" />
                           <uix:image sourceBinding="ORACLE_IMAGE" shortDescBinding="ORACLE_IMAGE_DESC"/>
                           <uix:spacer height="13" width="10"/>
                          </uix:column>

                          <uix:column>
                           <uix:columnHeader>
                            <uix:sortableHeader textBinding="BENEFITS@HABundle@servletRequest" sortable="true"/>
                           </uix:columnHeader> 
                           <uix:spacer height="1" width="100"/>
                           <uix:columnFormat columnDataFormat="textFormat" />
                           <uix:text textBinding="BENEFITS" />
                           <uix:spacer height="13" width="100"/>
                          </uix:column>

                        </uix:table>
	            </uix:stackLayout>
	        </uix:rowLayout>
          </uix:dataScope>
	</uix:tableLayout>
    
        <uix:tip> <uix:styledText styleClass="OraInlineInfoText" 
        textBinding="REFRESH_ADVISOR@HABundle@servletRequest" />
        </uix:tip>

	<uix:tableLayout renderedBinding="showMountedTip@HABean@servletRequest">
              <uix:rowLayout width="100%">
                <uix:cellFormat hAlign="right"  wrappingDisabled="true">
                  <uix:image source="/em/images/sysdash_unknown.gif"/>
                </uix:cellFormat>
                <uix:cellFormat >
                  <uix:spacer width="5" />
                   <uix:styledText styleClass="OraInlineInfoText" textBinding="maaRefreshTip@HABean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>      
	</uix:tableLayout>

      <uix:header textBinding="HA_LINKS@HABundle@servletRequest" >                    
        <uix:stackLayout>
          <uix:contents>
          <uix:tableLayout width="100%">
           <uix:contents>
            <uix:rowLayout>
             <uix:contents>
              <uix:cellFormat vAlign="top" >
               <uix:contents>               
            <uix:borderLayout>
             <uix:contents>        
                <uix:link  textBinding="HA_OPS@HABundle@servletRequest" destinationBinding="availTabDest@HABean@servletRequest"  />
             </uix:contents>
            </uix:borderLayout>     
               </uix:contents>
              </uix:cellFormat>
  
           </uix:contents>
              </uix:rowLayout> 

          </uix:contents>
         </uix:tableLayout>
          </uix:contents>
        </uix:stackLayout>
       </uix:header>


        <uix:pageButtons>
          <uix:pageButtonBar>
             <uix:submitButton styleClass="OraInstructionText" 
                                  textBinding="REFRESH_BUTTON@mntrResourceBundle" 
                                  shortDescBinding="REFRESH_DESC@HABundle@servletRequest"
                                  name="event" value="updateConfigStatus"/>  
            <uix:submitButton textBinding="OK@DBMsgBundle"  name="event" value="configAdvisorDone" formName="configAdvisor"
                              shortDescBinding="OK@DBMsgBundle"  />
         </uix:pageButtonBar>
        </uix:pageButtons>
     </uix:pageLayout>
   </db:form>

   </uix:body>
  </uix:document>
 </uix:renderingContext>
 
