<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.emo.ha.HABean" %>

<uix:renderingContext configuration="dashboardConfig" id="renderingContext"> <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="HABundle" class="oracle.sysman.db.rsc.ha.HAPageMsg"/>
  <uix:bundle name="DBMsgBundle" class="oracle.sysman.db.rsc.inst.DBMsg"/>
  <uix:bundle name="mntrResourceBundle" class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="sdkUIBundle" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

  <script language="javascript"> 
    function setFocus() {
      <%
      boolean showServices = ((HABean)request.getAttribute("HABean")).getFocusServices();
      if(showServices) {
      %> 
           window.location.href = "#SERVICES";
      <%
      }     
      %>      
</script>
  <uix:document> 
<%@ include file="/enablePPR.jspf" %>
    <uix:metaContainer> 
      <uix:head titleBinding="HA_CONSOLE@HABundle@servletRequest"/> 
      <meta http-equiv="Refresh" content=<%=request.getAttribute("pageRefresh") %>>
    </uix:metaContainer> 
    <uix:body onLoad="setFocus()">

    <db:form name="availForm"  destination="/em/console/database/haConsole" copyParams="target,type">
      <uix:pageLayout titleBinding="highAvailabilityHeader@HABean@servletRequest">
        <%@ include file=" /oemGlobal.jspf"%>
        <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="info"  destTableBinding="msgUrls@servletRequest" errorTableBinding="info@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:tableLayout width="100%" >
            
          <%-- In this rowLayout show the Line on the top--%>
          <uix:rowLayout styleClass="OraEmDashboardGroupHeaderLine">
            <uix:cellFormat height="2">
              <uix:styledText text=" " />
            </uix:cellFormat>
          </uix:rowLayout>
            
          <%-- In this rowLayout show the name and refresh,etc--%>
          <uix:rowLayout styleClassBinding="targetHeaderBackground@HABean@servletRequest">
            <uix:rowLayout width="100%">
              <uix:cellFormat height="25" vAlign="middle" hAlign="left" width="25%"  wrappingDisabled="true">
                <uix:styledText styleClass="DashInlineTextBold" 
                                textBinding="CURRENT_VIEW@HABundle@servletRequest"  renderedBinding="isDataGuard@DGBean@HABean@servletRequest"  /> 
                <uix:spacer width="5"  renderedBinding="isDataGuard@DGBean@HABean@servletRequest" />
                <uix:switcher childNameBinding="isDataGuard@DGBean@HABean@servletRequest">
                 <uix:case name="true">
                  <uix:styledText styleClass="DashInlineTextBold" textBinding="targetName@HABean@servletRequest" destinationBinding="targetHeaderDest@HABean@servletRequest" /> 
                </uix:case>
                 <uix:case name="false">
                  <uix:styledText styleClass="DashInlineTextBold" textBinding="targetHeader@HABean@servletRequest" destinationBinding="targetHeaderDest@HABean@servletRequest" /> 
                </uix:case>
                </uix:switcher>
               <uix:spacer width="5"  />
               <uix:image sourceBinding="availImage@AVBean@HABean@servletRequest" shortDescBinding="availStatusStr@AVBean@HABean@servletRequest" />
              </uix:cellFormat>

              <uix:cellFormat hAlign="right" height="22" vAlign="middle" width="35%">
               <uix:image sourceBinding="statusImage@HABean@servletRequest" renderedBinding="showStatusBar@HABean@servletRequest"
                    shortDescBinding="REFRESHING@HABundle@servletRequest" />
                <uix:spacer width="5" renderedBinding="showStatusBar@HABean@servletRequest" />
                <uix:styledText styleClass="OraEmDashboardTimeDate" renderedBinding="showStatusBar@HABean@servletRequest" 
                                textBinding="statusText@HABean@servletRequest" />
                <uix:spacer width="5" renderedBinding="showStatusBar@HABean@servletRequest" />
              </uix:cellFormat>

              <uix:cellFormat hAlign="right" height="22" vAlign="bottom" width="50%">
                <uix:styledText styleClass="OraEmDashboardPageRefresh" labeledNodeId="refreshChoiceID"
                                textBinding="PAGE_REFRESHED_TIME@sdkUIBundle"/>
                <uix:spacer width="5"/>
                <uix:styledText styleClass="OraEmDashboardTimeDate"  
                                textBinding="timestamp@HABean@servletRequest"/>
                <uix:spacer width="5"/>  
                <uix:submitButton styleClass="OraInstructionText" 
                                  textBinding="REFRESH_BUTTON@mntrResourceBundle" 
                                  shortDescBinding="REFRESH_DESC@HABundle@servletRequest"
                                  name="event" value="updateStatus"/>  
              </uix:cellFormat>
    
              <uix:cellFormat hAlign="right" height="22" vAlign="bottom" >
                <uix:spacer width="5"/>
                <uix:choice name="refreshChoice" id="refreshChoiceID" 
                    onChange="submitForm('availForm', true, {'event':'switchRefresh'})"
                    selectedValueBinding="refreshChoice@HABean@servletRequest" >
                  <uix:option textBinding="MANUALLY_REFRESH@DBMsgBundle" value="99999" />
                  <uix:option textBinding="REFRESH_1MIN@HABundle@servletRequest" value="60" />
                  <uix:option textBinding="REFRESH_5MIN@HABundle@servletRequest" value="300" />
                </uix:choice>
                </uix:cellFormat>
               </uix:rowLayout>
              </uix:rowLayout>
            
            <%-- In this rowLayout show the Line at the bottom--%>
            <uix:rowLayout styleClass="OraEmDashboardGroupHeaderNormalLine">
              <uix:cellFormat height="1">
                <uix:styledText text= " "/>
              </uix:cellFormat>
            </uix:rowLayout>
            
            <uix:rowLayout>
              <uix:spacer height="4"/>
            </uix:rowLayout>            
        </uix:tableLayout>

        <uix:contextSwitcher>
          <uix:tableLayout width="100%" >
            <uix:rowLayout>

              <uix:cellFormat height="22" vAlign="middle" hAlign="left" width="50%"  wrappingDisabled="true">
                <uix:link  textBinding="toggleViewText@HABean@servletRequest"  styleClass="OraEmDashboardPageRefresh" destinationBinding="toggleViewDest@HABean@servletRequest"  />
                <uix:spacer width="10"/>
                <uix:link  textBinding="CUSTOMIZE@HABundle@servletRequest"  styleClass="OraEmDashboardPageRefresh" destinationBinding="optionsDest@HABean@servletRequest"  />
              </uix:cellFormat>
              <uix:spacer width="10"/>

             <uix:cellFormat height="22" vAlign="middle" hAlign="left" width="50%"  wrappingDisabled="true">
              <uix:styledText  textBinding="SWITCH_TO@HABundle@servletRequest"  styleClass="OraEmDashboardPageRefresh"  
                  renderedBinding="isDataGuard@DGBean@HABean@servletRequest" labeledNodeId="targetSwitcher" />
             </uix:cellFormat>
             <uix:cellFormat vAlign="middle" wrappingDisabled="true">
              <uix:spacer width="1"/>
              <oem:choice name="newTarget" id="targetSwitcher"
                  onChange="submitForm('availForm', true, {'event':'switchTo','pageNum':'3'})"
                  optionsBinding="DGList@servletRequest"
                  selectedValueBinding="switcherName@DGBean@HABean@servletRequest"
                 renderedBinding="isDataGuard@DGBean@HABean@servletRequest" />
             </uix:cellFormat>     

         </uix:rowLayout> 

          </uix:tableLayout >
        </uix:contextSwitcher>

        <uix:include node="avail.jsp" />         


        <%@ include file="/database/ha/br.jspf" %>
        
        <uix:switcher childNameBinding="showRacDG@HABean@servletRequest">
         <uix:case name="RAC">
          <uix:flowLayout>
           <uix:contents>               
            <uix:rawText>
              <a name="SERVICES" id="SERVICES"/>
             </uix:rawText>    
            <uix:include node="cs.jsp" />         
            <uix:include node="dg.jsp" />         
           </uix:contents>               
          </uix:flowLayout>
         </uix:case>
          <uix:case name="DG_NO_RAC">
          <uix:flowLayout>
           <uix:contents>               
            <uix:include node="dg.jsp" />         
           </uix:contents>               
          </uix:flowLayout>
         </uix:case>
          <uix:case name="BOTH">
          <uix:flowLayout>
           <uix:contents>               
            <uix:include node="dg.jsp" />         
            <uix:rawText>
              <a name="SERVICES" id="SERVICES"/>
             </uix:rawText>    
            <uix:include node="cs.jsp" />         
           </uix:contents>               
          </uix:flowLayout>
         </uix:case>
        </uix:switcher>

      <uix:include node="strms.jsp" />         

      <uix:header textBinding="HA_LINKS@HABundle@servletRequest" >                    
        <uix:stackLayout>
          <uix:contents>
          <uix:tableLayout width="100%">
           <uix:contents>
            <uix:rowLayout>
             <uix:contents>
              <uix:cellFormat vAlign="top" widthBinding="firstColWidth@HABean@servletRequest">
               <uix:contents>               
            <uix:borderLayout>
             <uix:contents>        
               <db:link textBinding="ALL_METRICS@HABundle@servletRequest" destination="/console/metrics/allMetrics" 
                  copyParams="target,type"/>
             </uix:contents>
            </uix:borderLayout>     
               </uix:contents>
              </uix:cellFormat>
  
            <uix:cellFormat vAlign="top" widthBinding="secondColWidth@HABean@servletRequest">
              <uix:contents>
            <uix:borderLayout>
             <uix:contents>        
                <uix:link  textBinding="HA_OPS@HABundle@servletRequest" destinationBinding="availTabDest@HABean@servletRequest"  />
             </uix:contents>
            </uix:borderLayout>     
              </uix:contents>
             </uix:cellFormat>

            <uix:cellFormat vAlign="top" widthBinding="thirdColWidth@HABean@servletRequest">
              <uix:contents>
            <uix:borderLayout>
             <uix:contents>        
             </uix:contents>
            </uix:borderLayout>     
              </uix:contents>
             </uix:cellFormat>
              
           </uix:contents>
              </uix:rowLayout> 
            <uix:rowLayout>
             <uix:contents>
              <uix:cellFormat vAlign="top" widthBinding="firstColWidth@HABean@servletRequest">
               <uix:contents>               
            <uix:borderLayout>
             <uix:contents>        
                  <db:link textBinding="METRIC_SETTINGS@HABundle@servletRequest"
                      destination="/console/metrics/target/metricThresholds" copyParams="target,type"/>
             </uix:contents>
            </uix:borderLayout>     
               </uix:contents>
              </uix:cellFormat>
  
            <uix:cellFormat vAlign="top" widthBinding="secondColWidth@HABean@servletRequest">
              <uix:contents>
            <uix:borderLayout>
             <uix:contents>        
             </uix:contents>
            </uix:borderLayout>     
              </uix:contents>
             </uix:cellFormat>
           </uix:contents>
              </uix:rowLayout> 
          </uix:contents>
         </uix:tableLayout>
          </uix:contents>
        </uix:stackLayout>
       </uix:header>
      </uix:pageLayout> 
      
    </db:form>	
    </uix:body>
  </uix:document>
</uix:renderingContext>
