<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext configuration="dashboardConfig" id="renderingContext"> <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="HABundle" class="oracle.sysman.db.rsc.ha.HAPageMsg"/>
  <uix:bundle name="DBMsgBundle" class="oracle.sysman.db.rsc.inst.DBMsg"/>
  <uix:bundle name="mntrResourceBundle" class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="sdkUIBundle" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

  <uix:document> 
    <uix:metaContainer> 
      <uix:head titleBinding="OPT_TITLE@HABundle@servletRequest"/> 
    </uix:metaContainer> 
    <uix:body>
    <db:form name="optionsForm" destination="/em/console/database/haConsole" copyParams="target,type">
        <uix:formValue name="pageName" value="/database/ha/haConsole" />

      <uix:pageLayout titleBinding="optionsHeader@HABean@servletRequest" >
        <%@ include file=" /oemGlobal.jspf"%>
        <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="info" errorTableBinding="info@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>

       <uix:pageButtons>
        <uix:pageButtonBar>
          <uix:contents>
            <uix:submitButton textBinding="OK@HABundle@servletRequest" name="event" value="updateEvents" formName="optionsForm" />
          </uix:contents>
         </uix:pageButtonBar>
        </uix:pageButtons>

       <uix:tableLayout width="100%">
         <uix:contents>

          <uix:header textBinding="OPT_EVENT@HABundle@servletRequest" >
            <uix:stackLayout>
              <uix:contents>

              <uix:rowLayout>
               <uix:contents>
                <uix:styledText styleClass="OraInstructionText" textBinding="SHOW@HABundle@servletRequest" labeledNodeId="ShowAllID"/>
                <uix:spacer width="2"/>         
                  <uix:choice name="eventView" id="ShowAllID" selectedValueBinding="eventView@HABean@servletRequest" >
                    <uix:option textBinding="ALL_EVENTS@HABundle@servletRequest" value="showAll" />
                    <uix:option textBinding="CRITICAL_EVENTS@HABundle@servletRequest" value="showCritical" />
                    <uix:option textBinding="WARNING_EVENTS@HABundle@servletRequest" value="showWarning" />
                    <uix:option textBinding="INFO_EVENTS@HABundle@servletRequest" value="showInfo" />
                  </uix:choice>
                <uix:spacer width="4"/>         
                <uix:styledText styleClass="OraInstructionText" textBinding="TIME_PERIOD@HABundle@servletRequest" labeledNodeId="ShowTimeID"/>
                <uix:spacer width="2"/>         
                <uix:choice name="eventViewTime" id="ShowTimeID" selectedValueBinding="eventViewTime@HABean@servletRequest" >
                  <uix:option textBinding="LAST_DAY@HABundle@servletRequest" value="showDay" />
                  <uix:option textBinding="LAST_7_DAYS@HABundle@servletRequest" value="showWeek" />
                  <uix:option textBinding="LAST_31_DAYS@HABundle@servletRequest" value="showMonth" />
                  <uix:option textBinding="LAST_ALL@HABundle@servletRequest" value="showAllTime" />
                </uix:choice>
               </uix:contents>
              </uix:rowLayout>

            </uix:contents>        
          </uix:stackLayout>
        </uix:header>

        <uix:header textBinding="FORMATTING_OPTIONS@HABundle@servletRequest"  >
        <uix:stackLayout>
          <uix:contents>
             <uix:rowLayout>
              <uix:contents>
              <uix:styledText styleClass="OraInstructionText" text=""/>
              <uix:checkBox name="showHighlights" 
                            styleClass="OraFieldText" 
                            textBinding="OPT_HIGH_DESC@HABundle@servletRequest" 
                            checkedBinding="showHighlights@HABean@servletRequest" />
                      
           </uix:contents>
          </uix:rowLayout>
             <uix:rowLayout>
              <uix:contents>
              <uix:styledText styleClass="OraInstructionText" text=""/>
              <uix:checkBox name="shortNames" 
                            styleClass="OraFieldText" 
                            textBinding="SHORT_NAMES@HABundle@servletRequest" 
                            checkedBinding="shortNames@HABean@servletRequest" />
           </uix:contents>
          </uix:rowLayout>

          <uix:rowLayout>
           <uix:contents>
             <uix:spacer width="20"/>         
              <uix:styledText styleClass="OraInstructionText" text=""/>
              <uix:styledText styleClass="OraInlineInfoText" textBinding="SHORT_NAMES_DESC@HABundle@servletRequest" />
           </uix:contents>
          </uix:rowLayout>
                      

         </uix:contents>        
        </uix:stackLayout>
      </uix:header>

      <uix:header textBinding="OPT_REFRESH@HABundle@servletRequest"  >
      <uix:stackLayout>
        <uix:contents>
  
       <uix:tableLayout width="70%">
         <uix:contents>
        <uix:rowLayout>
         <uix:contents>
           <uix:spacer width="20"/>         
            <uix:styledText styleClass="OraInstructionText" text=""/>
            <uix:styledText styleClass="OraInlineInfoText" textBinding="REFRESH_DESC1@HABundle@servletRequest"/>
         </uix:contents>
        </uix:rowLayout>
         </uix:contents>
        </uix:tableLayout>

        <uix:rowLayout>
         <uix:contents>
        <uix:styledText styleClass="OraInstructionText" text=""/>
          <uix:radioButton name="statusRefreshOption" value="0"
                      styleClass="OraFieldText" 
                      textBinding="REFRESH_NONE@HABundle@servletRequest"
                      selectedValueBinding="statusRefreshOption@HABean@servletRequest" />
         </uix:contents>
        </uix:rowLayout>
        <uix:rowLayout>
         <uix:contents>
           <uix:spacer width="20"/>         
            <uix:styledText styleClass="OraInstructionText" text=""/>
            <uix:styledText styleClass="OraInlineInfoText" textBinding="REFRESH_NONE_DESC@HABundle@servletRequest"/>
         </uix:contents>
        </uix:rowLayout>

        <uix:rowLayout>
         <uix:contents>
        <uix:styledText styleClass="OraInstructionText" text=""/>
          <uix:radioButton name="statusRefreshOption" value="10"
                      styleClass="OraFieldText" 
                      textBinding="OPT_REFRESH_S@HABundle@servletRequest"
                      selectedValueBinding="statusRefreshOption@HABean@servletRequest" />
         </uix:contents>
        </uix:rowLayout>
        <uix:rowLayout>
         <uix:contents>
           <uix:spacer width="20"/>         
            <uix:styledText styleClass="OraInstructionText" text=""/>
            <uix:styledText styleClass="OraInlineInfoText" textBinding="OPT_REFRESH_D1@HABundle@servletRequest"/>
         </uix:contents>
        </uix:rowLayout>
        <uix:rowLayout>
         <uix:contents>
        <uix:styledText styleClass="OraInstructionText" text=""/>
          <uix:radioButton name="statusRefreshOption" value="20"
                      styleClass="OraFieldText" 
                      textBinding="OPT_REFRESH_ALL@HABundle@servletRequest"
                      selectedValueBinding="statusRefreshOption@HABean@servletRequest" />
         </uix:contents>
        </uix:rowLayout>
        <uix:rowLayout>
         <uix:contents>
           <uix:spacer width="20"/>         
            <uix:styledText styleClass="OraInstructionText" text=""/>
            <uix:styledText styleClass="OraInlineInfoText" textBinding="OPT_REFRESH_D2@HABundle@servletRequest"/>
         </uix:contents>
        </uix:rowLayout>
          
        </uix:contents>        
      </uix:stackLayout>
    </uix:header>

      <uix:header textBinding="OPT_HIST@HABundle@servletRequest"  >
          <uix:stackLayout>
            <uix:contents>
            <uix:rowLayout>
             <uix:contents>
              <uix:styledText styleClass="OraInstructionText" text=""/>
              <uix:radioButton name="chartRefreshOption" value="1"
                            styleClass="OraFieldText" 
                            textBinding="OPT_HIST_NONE@HABundle@servletRequest" 
                            selectedValueBinding="chartRefreshOption@HABean@servletRequest" />
              <uix:radioButton name="chartRefreshOption" value="2"
                            styleClass="OraFieldText" 
                            textBinding="OPT_HIST_2HR@HABundle@servletRequest" 
                            selectedValueBinding="chartRefreshOption@HABean@servletRequest" />
              <uix:radioButton name="chartRefreshOption" value="10"
                            styleClass="OraFieldText" 
                            textBinding="OPT_HIST_10HR@HABundle@servletRequest" 
                            selectedValueBinding="chartRefreshOption@HABean@servletRequest" />                        
             </uix:contents>
            </uix:rowLayout>

        </uix:contents>        
      </uix:stackLayout>
    </uix:header>

     <uix:header textBinding="OPT_CS@HABundle@servletRequest" >
      <uix:stackLayout>
        <uix:contents>

        <uix:rowLayout>
         <uix:contents>
        <uix:styledText styleClass="OraInstructionText" text=""/>
        <uix:radioButton name="csChartOption" value="cpuload"
                      styleClass="OraFieldText" 
                      textBinding="SVC_TPUT@HABundle@servletRequest"
                      selectedValueBinding="csChartOption@HABean@servletRequest" />
        <uix:radioButton name="csChartOption" value="avg_response_time"
                      styleClass="OraFieldText" 
                      textBinding="SVC_AVG_RESP@HABundle@servletRequest"
                      selectedValueBinding="csChartOption@HABean@servletRequest" />
         </uix:contents>
        </uix:rowLayout>

        <uix:rowLayout>
         <uix:contents>
            <uix:styledText styleClass="OraInstructionText" text=""/>
            <uix:checkBox name="csChartType" 
                          styleClass="OraFieldText" 
                          textBinding="OPT_SHOW_LINE@HABundle@servletRequest"
                          checkedBinding="csChartType@HABean@servletRequest" 
                           />
         </uix:contents>
        </uix:rowLayout>
        <uix:rowLayout>
         <uix:contents>
           <uix:spacer width="20"/>         
            <uix:styledText styleClass="OraInstructionText" text=""/>
            <uix:styledText styleClass="OraInlineInfoText" textBinding="OPT_SHOW_DESC@HABundle@servletRequest" />
         </uix:contents>
        </uix:rowLayout>
        </uix:contents>        
      </uix:stackLayout>
    </uix:header>


    </uix:contents>        
   </uix:tableLayout>

  </uix:pageLayout> 
      
    </db:form>	
    </uix:body>
  </uix:document>
</uix:renderingContext>
