<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%@ page import="oracle.cabo.ui.UIConstants" %>
<%@ page import="oracle.sysman.db.uix.DBConstants" %>
<%@ page import="oracle.sysman.dbTarget.db.hm.ctlr.DBHealthUIConstants" %>
<%@ page import="oracle.sysman.dbTarget.db.hm.ctlr.DBHealthMsgID" %>


<jsp:useBean id="DBHealthPageView"
             scope="request"
             type="oracle.sysman.dbTarget.db.hm.ctlr.DBHealthPageView"/>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="HDMMsg"
  	    class="oracle.sysman.db.rsc.inst.HDMMsg"/>
  <uix:bundle name="DBMsg"
  	    class="oracle.sysman.db.rsc.inst.DBMsg"/>
  <uix:bundle name="DBHealthMsg"
              class="oracle.sysman.dbTarget.db.hm.ctlr.DBHealthMsg"/>
  <uix:bundle name="sdkMessageBundle"
  	    class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  
  <oem:setURLEncoder id="renderingContext"/>
  
  <%@ include file="../instance/hdm/waitTimeChartScripts.jspf" %>
  <uix:document>
  
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:dataScope currentDataBinding="DBHealthPageView@servletRequest">
      <uix:body>
  
        <uix:pageLayout titleBinding='<%=DBHealthMsgID.TITLE_DB_HEALTH_PAGE+"@DBHealthMsg"%>'>
  
          <%@ include file="/database/global.jspf" %>
  
          <uix:form name="foo" method="POST" destination="/console/database/hm/DBHealth">
  	  <uix:formValue name="event" value=""/>
            <uix:formValue name="direction" value=""/>
            <uix:formValue name="iconIndex" value=""/>
            <uix:formValue name="<%= DBConstants.TARGET_TYPE_PAGE_PROPERTY%>" 
                          valueBinding = '<%= DBConstants.TARGET_TYPE_PAGE_PROPERTY+"@results@DBHealthPageView@servletRequest"%>'/>
            <uix:formValue name="<%= DBConstants.TARGET_PAGE_PROPERTY%>" 
                           valueBinding = '<%= DBConstants.TARGET_PAGE_PROPERTY+"@results@DBHealthPageView@servletRequest"%>'/>
  	  <uix:formValue name="pageName" value="/database/hm/DBHealth"/>
  
          <%-- REFRESH --%>
          <uix:tableLayout width="100%" cellSpacing="2">
            <uix:rowLayout hAlign="right">
              <uix:cellFormat>
                <uix:rowLayout>
                  <uix:styledText styleClass="OraTipText"
                                  textBinding="PAGE_REFRESHED_TIME@sdkMessageBundle"/>
                  <uix:spacer width="5"/>
                  <uix:styledText styleClass="OraTipLabel"
                                  textBinding="refreshTime"/>
                  <uix:spacer width="10"/>
                  <uix:button textBinding="REFRESH@sdkMessageBundle"
                              onClick="submitForm('foo', true, {event:'doLoad'})" />
                </uix:rowLayout>
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>


            <uix:stackLayout>
              <uix:tableLayout cellSpacing="5">
  
                <uix:rowLayout>
                  <uix:styledText textBinding='<%=DBHealthMsgID.DESC_DBHEALTH+"@DBHealthMsg"%>'
                                  styleClass="OraPromptText"/>
                </uix:rowLayout>
                <uix:rowLayout>
                  <oem:chart titleBinding='<%=DBHealthMsgID.HEADER_DBHEALTH_INCIDENT+"@DBHealthMsg"%>'
                             chartType="timeSeriesBarChart"
                             yAxisLabelBinding='<%=DBHealthMsgID.TITLE_INCIDENT_Y_AXIS+"@DBHealthMsg"%>'
                             yAxisWidth="30"
                             width="780"
                             height="130"
                             timeLabelAlignment="wholeXAxis"
                             xAxisMinBinding="alertMinX"
                             xAxisMaxBinding="alertMaxX"
                             legendVisible="external"
                             legendPosition="east" 
                             noDataMessageBinding='<%=DBHealthMsgID.MSG_NO_INCIDENTS+"@DBHealthMsg" %>'
                             orientation="vertical"
                             stacked="true"
                             barWidth="25">
  
                   <uix:contents>
                    <oem:boundChartDataSource 
                         chartDataSourceBinding="incidentChartDataSource"/>
                    <oem:imageMap imageMapDataSourceBinding="incidentImageMap" />
                    <oem:chartColumn
                         isKey="true"
                         displayLabel=""
                         sourceIndex="0"/>
                                
                    <oem:chartColumn
                        isTimeColumn="true"
                        displayLabel="Time"
                        sourceIndex="1"/>
  
                    <oem:chartColumn
                        displayLabel=""
                        sourceIndex="2"/>
  
                   </uix:contents>
                  </oem:chart>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <oem:chart
                         titleBinding='<%=DBHealthMsgID.HEADER_DBHEALTH_ADDM+"@DBHealthMsg"%>'
                         chartType="timeSeriesChart"
                         width="850"
                         height="130"
                         timeGranularity="SECOND"
                         orientation="vertical"
                         seriesColorsAutomatic="true"
                         legendPosition="east" 
                         legendVisible="true"
                         fill="cumulative"
                         yAxisLabelBinding="ACTIVE_SESSIONS@DBMsg"
                         titleVisible="true"
                         xAxisMinBinding="alertMinX"
                         xAxisMaxBinding="alertMaxX"
                         yAxisWidth="30"
                         format="svg"
                         colorPaletteBinding="nonStaticPickerColors@waitsChart@waitsBean@servletRequest"
                         axisMaxBinding="maxValue@waitsBean@servletRequest"
                         svgHighlightLegend="true">
                     <uix:contents>
                      <oem:timeSelector
                           intervalTimeSec="1800"
                           height="20"
                           selectionDest="svgIconClicked"
                           selectionDestType="JavaScript"
                           selectionAltTextBinding="CLICK_TO_SELECT_RUNS@HDMMsgBundle@servletRequest"
                           position="south"
                           timebandDataSourceBinding="timebands@waitsBean@servletRequest"
                           xAxisScrollDest="scroll_timechart"
                           xAxisScrollDestType="JavaScript"
                           xAxisScrollPrev="false"
                           xAxisScrollPrevAltTextBinding="GO_BACKWARD@DBMsg"
                           xAxisScrollNext="false"
                           xAxisScrollNextAltTextBinding="GO_FORWARD@DBMsg"
                           showBorder="false">
                      </oem:timeSelector>
                      <oem:boundChartDataSource 
                           chartDataSourceBinding="chartDataSource@waitsBean@servletRequest"/>               
                      <oem:chartColumn                                   
                           isKey="true" 
                           displayLabel=""
                           sourceIndex="0"/>
                      <oem:chartColumn
                           isTimeColumn="true"
                           displayLabel="Time"
                           sourceIndex="1"/>
                      <oem:chartColumn                                   
                           displayLabel=""
                           sourceIndex="2"/>
                     </uix:contents>      
                    </oem:chart>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
              <uix:rowLayout>
                <uix:spacer width="5"/>
                <oem:chart titleBinding='<%=DBHealthMsgID.HEADER_DBHEALTH_ALERT+"@DBHealthMsg"%>'
                           chartType="timeSeriesBarChart"
                           width="780"
                           height="130"
                           yAxisWidth="30"
                           yAxisLabelBinding='<%=DBHealthMsgID.TITLE_ALERT_Y_AXIS+"@DBHealthMsg"%>'
                           legendVisible="external"
                           legendPosition="east"
                           timeLabelAlignment="wholeXAxis"
                           xAxisMinBinding="alertMinX"
                           xAxisMaxBinding="alertMaxX"
                           timeGranularity="SECOND"
                           noDataMessageBinding='<%=DBHealthMsgID.MSG_NO_ALERTS+"@DBHealthMsg" %>'
                           orientation="vertical"
                           stacked="true"
                           barWidth="25">
  
                 <uix:contents>
                  <oem:boundChartDataSource 
                        chartDataSourceBinding="alertChartDataSource"/>
                  <oem:chartColumn
                       isKey="true"
                       displayLabel=""
                       sourceIndex="0"/>
                                
                  <oem:chartColumn
                      isTimeColumn="true"
                      displayLabel="Time"
                      sourceIndex="1"/>
  
                  <oem:chartColumn
                      displayLabel=""
                      sourceIndex="2"/>
  
                 </uix:contents>
  
                </oem:chart>
              </uix:rowLayout>
              <uix:rowLayout>
  	      <uix:tip>
                  <uix:styledText textBinding="LEGEND_TEXT@sdkMessageBundle"/>
                  <uix:link textBinding="ICON_LEGEND_HEADER@HDMMsg" destinationBinding="iconLegendUrl@servletRequest"/>  
                </uix:tip>
              </uix:rowLayout>
            </uix:stackLayout>
          </uix:form>
          <oem:relatedLinks/>
        </uix:pageLayout>
      </uix:body>
    </uix:dataScope>
  </uix:document>
</uix:renderingContext>
