<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>


  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <uix:pageLayout>
    <%@ include file="/database/global.jspf" %>

    <uix:switcher childNameBinding="stateChange@servletRequest">
      <uix:case name="true">
        <oem:messageBox messageTypeBinding="stateChangeMessageType@servletRequest"
	      errorTableBinding="msgBox@servletRequest"
                             destTableBinding="msgUrls@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
      </uix:case>
    </uix:switcher>

    <uix:form name="foo" method="post" destination="/console/database/home">

    <uix:header textBinding="header@defaultBean@servletRequest">





     <uix:subTabLayout>
        <uix:subTabs>
          <uix:subTabBar selectedIndex="0">
              <uix:link textBinding="HOME@DBMsgBundle@servletRequest"/>
              <uix:link textBinding="PERFORMANCE_HEADER@DBMsgBundle@servletRequest"
                 destinationBinding="healthDest@servletRequest"/>
              <uix:link textBinding="ADMINISTRATION@DBMsgBundle@servletRequest"
                 destinationBinding="adminDest@servletRequest"/>
          </uix:subTabBar>
        </uix:subTabs>





        <uix:tableLayout width="100%" cellSpacing="2">

	    <uix:rowLayout hAlign="right">
            <uix:cellFormat>
                  <uix:rowLayout>
                    <uix:styledText styleClass="OraInlineInfoText" 
                              textBinding="DATA_RETRIEVED@DBMsgBundle@servletRequest"/>
                    <uix:spacer width="10"/>
                    <uix:styledText styleClass="OraInlineInfoText" 
                              textBinding="lastUpdatedTime@defaultBean@servletRequest"/>
                    <uix:spacer width="10"/>
                    <uix:image sourceBinding="refreshImage@servletRequest"
                              destinationBinding="refreshDest@servletRequest" />
                  </uix:rowLayout>
            </uix:cellFormat>
          </uix:rowLayout>

            <uix:rowLayout vAlign="top">


                <!-- ...................  General Section .................. -->

                <uix:stackLayout>

                  <uix:header textBinding="GENERAL@DBMsgBundle@servletRequest">



                    <uix:borderLayout>
                      <uix:rowLayout>
                       <uix:stackLayout>
                       
                      <uix:switcher childNameBinding="isEmbeddedNonEMUser@servletRequest">
                        <uix:case name="true">
                           <uix:rowLayout hAlign="right">
                              <uix:cellFormat hAlign="right">
                                <uix:button textBinding="CHANGE_STATE@DBMsgBundle@servletRequest"
                                  destinationBinding="changeStateUrl@servletRequest"/>
                              </uix:cellFormat>
                            </uix:rowLayout>   
                        </uix:case>
                      </uix:switcher>

                    <uix:switcher childNameBinding="isEmbeddedNonEMUser@servletRequest">
                      <uix:case name="true">
                      <uix:spacer height="20" />
                     </uix:case>
                    </uix:switcher>       
                           
                        <uix:tableLayout hAlign="left">


                         <uix:rowLayout>
                              <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                  <uix:styledText styleClass="OraPromptText"
                                    textBinding="CURRENT_STATUS@DBMsgBundle@servletRequest"/>

                              </uix:cellFormat>
                              <uix:spacer width="8"/>
                              <uix:cellFormat wrappingDisabled="true">

                                <uix:styledText styleClass="OraDataText"
                                  textBinding="status@defaultBean@servletRequest"/>
                                <uix:spacer width="8"/>

                              </uix:cellFormat>
                              <uix:spacer width="8"/>
                              <uix:cellFormat>


                              </uix:cellFormat>
                            </uix:rowLayout>


                            <uix:rowLayout renderedBinding="startedOrHigher@defaultBean@servletRequest">
                              <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                  <uix:styledText styleClass="OraPromptText"
                                    textBinding="UP_SINCE_TEXT@DBMsgBundle@servletRequest"/>
                              </uix:cellFormat>
                              <uix:spacer width="8"/>
                              <uix:cellFormat wrappingDisabled="true">

                              <uix:styledText styleClass="OraDataText"
                                textBinding="startupTime@defaultBean@servletRequest"/>
                             </uix:cellFormat>
                            </uix:rowLayout>

                           

                            <uix:rowLayout renderedBinding="startedOrHigher@defaultBean@servletRequest">

                              <uix:cellFormat hAlign="right" wrappingDisabled="true">

                                  <uix:styledText styleClass="OraPromptText"
                                    textBinding="INSTANCE_NAME@DBMsgBundle@servletRequest"/>

                              </uix:cellFormat>
                              <uix:spacer width="8"/>
                              <uix:cellFormat wrappingDisabled="true">
                              <uix:styledText styleClass="OraDataText"
                                textBinding="instanceName@defaultBean@servletRequest"/>
                              </uix:cellFormat>
                            </uix:rowLayout>

                            <uix:rowLayout renderedBinding="startedOrHigher@defaultBean@servletRequest" >

                              <uix:cellFormat hAlign="right" wrappingDisabled="true">

                                  <uix:styledText styleClass="OraPromptText"
                                    textBinding="VERSION@DBMsgBundle@servletRequest"/>

                              </uix:cellFormat>
                              <uix:spacer width="8"/>
                              <uix:cellFormat wrappingDisabled="true">
                              <uix:styledText styleClass="OraDataText"
                                textBinding="version@defaultBean@servletRequest"/>
                               </uix:cellFormat>
                            </uix:rowLayout>

                            <uix:rowLayout renderedBinding="startedOrHigher@defaultBean@servletRequest">
                              <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                  <uix:styledText styleClass="OraPromptText"
                                    textBinding="HOST@DBMsgBundle@servletRequest" />
                              </uix:cellFormat>
                              <uix:spacer width="8"/>
                              <uix:cellFormat wrappingDisabled="true">
                              <uix:styledText styleClass="OraDataText" 
                              textBinding="host@defaultBean@servletRequest"/>
                               </uix:cellFormat>
                            </uix:rowLayout>

                           
                           


                            <uix:rowLayout renderedBinding="mountedOrHigher@defaultBean@servletRequest">
                              <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                  <uix:styledText styleClass="OraPromptText"
                                    textBinding="LOG_MODE@DBMsgBundle@servletRequest" />
                              </uix:cellFormat>
                              <uix:spacer width="8"/>
                              <uix:cellFormat wrappingDisabled="true">
                              <uix:styledText styleClass="OraDataText"
                                textBinding="archiveLogMode@defaultBean@servletRequest" />
                              </uix:cellFormat>
                            </uix:rowLayout> 







                        </uix:tableLayout>
                     </uix:stackLayout>
                    </uix:rowLayout> 


                  <!--  end of table of General info  -->


                  <!--  Traffic Light... -->
                  <uix:left>
                    <uix:image sourceBinding="trafficImage@servletRequest"/>
                  </uix:left> 

              </uix:borderLayout>
               <uix:spacer height="10" />
          </uix:header>

      </uix:stackLayout> 



           </uix:rowLayout>

      </uix:tableLayout>


      

 <%--   <uix:tableLayout renderedBinding="showNormal@defaultBean@servletRequest">
      <oem:relatedLinks />
    </uix:tableLayout>




      <uix:spacer height="15"/> --%>

      </uix:subTabLayout>

      </uix:header>
      <uix:spacer height="5"/>


     </uix:form>
    </uix:pageLayout>
    </uix:body>


  </uix:document>
</uix:renderingContext>

