<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%--

 How to use this file:

 The following attributes must be set in ServletRequest:
  "backUrl"     - URL for OK button
  "deleteMsg"   - Brief information for page 
--%>


<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="INFORMATION@uixDBObjectBundle@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
      
       <% if (request.getAttribute("msgTable") != null) {%>
        <uix:pageLayout messageType="info">
            <%@ include file="/database/globalPopup.jspf" %>
          

         <uix:stackLayout>
           <uix:rowLayout>
             <uix:styledText styleClass="OraDataText"
                             textBinding="msgText@msgTable@servletRequest"/>
           </uix:rowLayout>
         </uix:stackLayout>   

          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:button textBinding="OK@uixDBObjectBundle@servletRequest" 
                      destinationBinding="backURL@servletRequest"
                      shortDescBinding="OK@uixDBObjectBundle@servletRequest"/>
            </uix:pageButtonBar>
          </uix:pageButtons>
        </uix:pageLayout>
      <%}%>  

      <% if (request.getAttribute("errorBean") != null) {%>
        <uix:pageLayout renderedBinding="rendered@errorBean@servletRequest"
                        messageTypeBinding="messageType@errorBean@servletRequest">
            <%@ include file="/database/globalPopup.jspf" %>
          
           <uix:switcher childNameBinding="rendered@errorBean@servletRequest">
             <uix:case name="true">
               <uix:rowLayout width="100%">
                   <uix:styledText styleClass="OraDataText"
                                  textBinding="message@errorBean@servletRequest"/>
                 
               </uix:rowLayout>
             </uix:case>
           </uix:switcher>

           <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:button textBinding="OK@uixDBObjectBundle@servletRequest" 
                      destinationBinding="backURL@servletRequest"
                      shortDescBinding="OK@uixDBObjectBundle@servletRequest"/>
            </uix:pageButtonBar>
          </uix:pageButtons>
        </uix:pageLayout>
      <%}%>

      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>



