<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%@ page import="oracle.sysman.dbTarget.swb.console.hm.HMMsgID"%>
<uix:renderingContext id="renderingContext">
<uix:bundle name="advisorTasksMsg"
	    class="oracle.sysman.db.rsc.inst.AdvisorTasksMsg"/>
<uix:bundle name="dbMsg"
	    class="oracle.sysman.db.rsc.inst.DBMsg"/>
<uix:bundle name="SDKMsg"
	    class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
 <uix:bundle name="HMMsg"
             class="oracle.sysman.dbTarget.swb.console.hm.HMMsg"/>

<oem:setURLEncoder id="renderingContext"/>

<uix:document>

<%@ include file="/oemTitle.jspf" %>

<uix:body>

<db:form name="advisorTasks" destinationBinding="formDest@servletRequest" copyParams="target,type,dbPageNum">

<uix:formValue name="advisorURL" value=""/>
<uix:formValue name="advisoryCentralURL" value=""/>

<uix:pageLayout>
<%@ include file="/database/global.jspf" %>
<%@ include file="/sdk/page/pageMsgBox.jspf" %>

    <uix:switcher childNameBinding="refreshChoice@servletRequest">
      <uix:case name="RT_15">
        <uix:rawText>
          <meta http-equiv="Refresh" content='15;<%=request.getAttribute("refreshDest")%>' >
        </uix:rawText>
      </uix:case>
    </uix:switcher>

<uix:header textBinding="ADVISORY_CENTRAL@advisorTasksMsg">
<%-- Warning/Error display --%>
<oem:messageBox messageType="info"
                errorTableBinding="info@servletRequest"
                titleTextKey="titleText" mainTextKey="mainText"/>
<oem:messageBox messageType="error"
                errorTableBinding="errors@servletRequest"
                titleTextKey="titleText" mainTextKey="mainText"/>
<uix:switcher childNameBinding="version11gOrHigher@servletRequest">
  <uix:case name="true">
    <uix:subTabBar orientation="top">
      <uix:contents>
        <uix:link textBinding="TAB_ADVISOR_CENTRAL@HMMsg"
                  selected="true"/>
        <uix:link textBinding="TAB_CHECKER_CENTRAL@HMMsg"
                destinationBinding = "checkerCentralDest@servletRequest"/>
      </uix:contents>
    </uix:subTabBar>
  </uix:case>
</uix:switcher>

<%-- REFRESH --%>
<uix:tableLayout width="100%" cellSpacing="2">
<uix:rowLayout hAlign="right">
  <uix:cellFormat>
    <uix:rowLayout>
    <%--
      <uix:styledText styleClass="OraTipText"
           textBinding="PAGE_REFRESHED_TIME@SDKMsg"/>
      <uix:spacer width="5"/>
      <uix:styledText styleClass="OraTipLabel"
           textBinding="lastUpdatedTime@defaultBean@servletRequest"/>
	   --%>
      <uix:styledText styleClass="OraTipText"   textBinding="VIEW_DATA_LABEL@dbMsg"/>
      <uix:spacer width="10"/>
            <uix:choice name="refreshChoice" id="view_choice" onChange="submitForm('advisorTasks', true, {'event':'changeRefreshChoice'})" selectedValueBinding="refreshChoice@servletRequest">
              <uix:option textBinding="REAL_TIME_AUTO_15_SEC@dbMsg"
                        value="RT_15"/>
              <uix:option textBinding="REAL_TIME_MANUAL@dbMsg"
                        value="RT_MAN" />
            </uix:choice>
    <%--
      <uix:spacer width="10"/>
      <uix:button textBinding="REFRESH@SDKMsg"
            destinationBinding="refreshDest@servletRequest" />
	   --%>
    </uix:rowLayout>
  </uix:cellFormat>
</uix:rowLayout>
</uix:tableLayout>

<%@ include file="advisorList.jspf" %>

<%-- use links instead of choice box for advisors launching
<uix:tableLayout width="100%" cellSpacing="2">
<uix:rowLayout hAlign="right">
<uix:messageChoice selectedIndex="1" prompt="Launch Advisor">
  <uix:contents>
  <uix:option text="HDM"/>
  <uix:option text="SQL Tuning Advisor"/>
  <uix:option text="SQL Access Advisor"/>
  <uix:option text="Space Advisor"/>
  </uix:contents>
</uix:messageChoice>
<uix:button text="Go"/>
</uix:rowLayout>
</uix:tableLayout>
--%>

<%-- Advisor Tasks Table --%>
<uix:header textBinding="ADVISOR_TASKS@advisorTasksMsg">
<uix:rowLayout width = "100%">
  <uix:cellFormat hAlign="right">
    <uix:submitButton textBinding="CHANGE_GLOBAL_PARAMETERS@advisorTasksMsg"
	            name="event"
		    value="changeDefaultParameters" />
  </uix:cellFormat>
</uix:rowLayout>
<uix:header textBinding="SEARCH@advisorTasksMsg">
<uix:stackLayout>
<uix:tableLayout>
<uix:rowLayout hAlign="left">
  <uix:styledText styleClass="OraPromptText" textBinding="SEARCH_DESC@advisorTasksMsg"/>
</uix:rowLayout>
</uix:tableLayout>
<uix:tableLayout cellSpacing="2">
<uix:rowLayout>
  <uix:stackLayout>
  <uix:styledText labeledNodeId="advisoryName" styleClass="OraPromptText" textBinding="ADVISORY_TYPE_LABEL@advisorTasksMsg"/>
  <oem:choice name="advisoryNameFilter"
		     selectedValueBinding="advisoryNameFilter@advisorTasksDS@servletRequest"
		     optionsBinding="allAdvisoryTypes@advisorTasksDS@servletRequest" />
  </uix:stackLayout>
  <uix:stackLayout>
  <uix:styledText labeledNodeId="taskName" styleClass="OraPromptText" textBinding="TASK_NAME_LABEL@advisorTasksMsg"/>
  <uix:textInput id="taskName" name="taskNameFilter"
		     textBinding="taskNameFilter@advisorTasksDS@servletRequest" />
  </uix:stackLayout>
  <uix:stackLayout>
  <uix:styledText labeledNodeId="advisorRuns" styleClass="OraPromptText" textBinding="ADVISOR_RUNS@advisorTasksMsg"/>
  <uix:choice name="advisorRunsFilter" id="advisorRuns" selectedValueBinding="advisorRunsFilter@advisorTasksDS@servletRequest">
  	<uix:contents
		childDataBinding="advisorRunsTypes@advisorTasksDS@servletRequest">
		<uix:option textBinding="text" valueBinding="val" />
  	</uix:contents>
  </uix:choice>
  </uix:stackLayout>
  <uix:stackLayout>
  <uix:styledText labeledNodeId="taskStatus" styleClass="OraPromptText" textBinding="STATUS@advisorTasksMsg"/>
  <uix:rowLayout>
  <oem:choice name="taskStatusFilter"
		     selectedValueBinding="taskStatusFilter@advisorTasksDS@servletRequest"
		     optionsBinding="allTaskStatusTypes@advisorTasksDS@servletRequest" />
  <uix:submitButton textBinding="GO_BTN@advisorTasksMsg"
	            name="event"
		    value="reload" />
  </uix:rowLayout>
  </uix:stackLayout>
</uix:rowLayout>
</uix:tableLayout>
<%-- Add Search Hint under the UI --%> 
<uix:styledText styleClass="OraInlineInfoText" 
                textBinding="SEARCH_HINT@advisorTasksMsg" />
</uix:stackLayout>
</uix:header>
<uix:header textBinding="RESULT@advisorTasksMsg">
<oem:table name="advisorTasksUIDS"
           summaryBinding="RESULT@advisorTasksMsg"
           width="100%" beanKey="advisorTasksDS" blockSize="25"
           dataSourceProp="advisorTasksUIDS"
           copyParams="target,type,dbPageNum"
	   formSubmitted="true"
	   alternateTextBinding="NO_ITEM_FOUND@advisorTasksMsg">
  <uix:tableSelection>
    <uix:singleSelection shortDescBinding="SELECT@uixDBObjectBundle@servletRequest"
            selectedIndexBinding="visibleSelectedIndex@advisorTasksDS@servletRequest">
      <%-- uix:submitButton textBinding="VIEW_BTN@advisorTasksMsg"
			name="event"
			value="viewTask"/ --%>
      <uix:submitButton textBinding="VIEW_RESULT_BTN@advisorTasksMsg"
			name="event" 
			value="viewResultTask"/>
      <%-- uix:submitButton textBinding="EDIT_BTN@advisorTasksMsg"
			name="event"
			value="editTask"/ --%>
      <uix:submitButton textBinding="DELETE_BTN@advisorTasksMsg"
			name="event"
			value="deleteTask" />
      <uix:messagePrompt labeledNodeId="actionLabel" promptBinding= "ACTION_LABEL@advisorTasksMsg" />
      <oem:choice name="selectedAdvOperation" id="actionLabel"
	   selectedValueBinding="selectedAdvOperation@defaultBean@servletRequest"
	   optionsBinding="advOperations@defaultBean@servletRequest" />
<%--
	   onChange="submitForm('advisorTasks', true, {'event':'doOperation'})"/>
--%>
      <uix:submitButton textBinding="GO_BTN@advisorTasksMsg"
			name="event"
			value="doOperation" />
    </uix:singleSelection>
  </uix:tableSelection>
</oem:table>
</uix:header>
</uix:header>

<%-- comment out for 10i beta 2 release --%>
<%-- %@ include file="defaultSettings.jspf" --%>
<uix:spacer height="10"/>
<uix:switcher childNameBinding="version11gOrHigher@servletRequest">
  <uix:case name="true">
    <uix:subTabBar orientation="bottom">
      <uix:contents>
        <uix:link textBinding='<%= HMMsgID.TAB_ADVISOR_CENTRAL+"@HMMsg"%>'
                  selected="true"/>
        <uix:link textBinding='<%=HMMsgID.TAB_CHECKER_CENTRAL+"@HMMsg"%>'
                destinationBinding = "checkerCentralDest@servletRequest"/>
      </uix:contents>
    </uix:subTabBar>
  </uix:case>
</uix:switcher>

</uix:header>
</uix:pageLayout>

</db:form>

</uix:body>

</uix:document>
</uix:renderingContext>
