<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 

<uix:renderingContext id="renderingContext">
<uix:bundle name="advisorTasksMsg"
	    class="oracle.sysman.db.rsc.inst.AdvisorTasksMsg"/>
<uix:bundle name="uixDBObjectMsg"
	    class="oracle.sysman.db.rsc.DBObjectMsg"/>

<oem:setURLEncoder id="renderingContext"/> 

<uix:document> 

<%@ include file="/oemTitle.jspf" %>

<uix:body>    

<db:form name="changeExpiration" destination="/console/database/instance/advisorTasks" copyParams="target,type,dbPageNum">

<uix:formValue name="pageName" value="/database/instance/advfrwk/changeDefaultExpiration"/>
<uix:pageLayout titleBinding="CHANGE_GLOBAL_PARAMETERS@advisorTasksMsg">
<%@ include file="/database/global.jspf" %>


<%-- Warning/Error display --%>
<oem:messageBox messageType="info" 
                errorTableBinding="info@servletRequest"
                titleTextKey="titleText" mainTextKey="mainText"/>
<oem:messageBox messageType="error" 
                errorTableBinding="errors@servletRequest"
                titleTextKey="titleText" mainTextKey="mainText"/>

<uix:header textBinding="ALL_TASK_PARAMETERS@advisorTasksMsg">
<uix:tableLayout cellSpacing="2">

<uix:rowLayout>
<uix:messageTextInput promptBinding="EXPIRES_IN_LABEL@advisorTasksMsg"
		      name="defaultExpiresIn"
                      columns="10"
		      textBinding="defaultExpiresIn@defaultBean@servletRequest"
                      tipBinding="SET_DEFAULT_EXPIRATION_DESC@advisorTasksMsg">
</uix:messageTextInput>
</uix:rowLayout>
</uix:tableLayout>
</uix:header>


<uix:header textBinding="ADDM_TASK_PARAMETERS@advisorTasksMsg">
<uix:tableLayout cellSpacing="2">

<uix:rowLayout>
<uix:messageTextInput promptBinding="DBIO_EXPECTED@advisorTasksMsg"
		      name="defaultADDMDbIOExpected"
                      columns="5"
		      textBinding="defaultADDMDbIOExpected@defaultBean@servletRequest"
                      tipBinding="SET_DBIO_EXPECTED_DESC@advisorTasksMsg">
<uix:onSubmitValidater>
<uix:decimal/>
</uix:onSubmitValidater>
</uix:messageTextInput>
</uix:rowLayout>
</uix:tableLayout>
</uix:header>

<uix:pageButtons>
<uix:pageButtonBar>
<uix:submitButton textBinding="LAUNCH_EXECUTE_SQL@uixDBObjectBundle@servletRequest"
                  renderedBinding="launchExecuteSQLRendered@objectBean@servletRequest"
                  name="event" 
                  value="launchExecuteSQL" />

<uix:button textBinding="CANCEL@uixDBObjectMsg"
	destinationBinding="backURL@servletRequest"/>
<uix:submitButton textBinding="OK@uixDBObjectMsg"
	name="event" value="doChangeDefaultParameters" />
</uix:pageButtonBar>
</uix:pageButtons>

</uix:pageLayout>

</db:form>

</uix:body>

</uix:document> 
</uix:renderingContext> 
