<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 

<uix:renderingContext id="renderingContext">
<uix:bundle name="advisorTasksMsg"
	    class="oracle.sysman.db.rsc.inst.AdvisorTasksMsg"/>
<uix:bundle name="uixDBObjectMsg"
	    class="oracle.sysman.db.rsc.DBObjectMsg"/>

<oem:setURLEncoder id="renderingContext"/> 

<uix:document> 

<%@ include file="/oemTitle.jspf" %>

<uix:body>    

<db:form name="changeExpiration" destinationBinding="formDest@servletRequest" copyParams="target,type,dbPageNum">
<uix:formValue name="pageName" valueBinding="pageName@servletRequest"/>

<uix:pageLayout titleBinding="CHANGE_EXPIRATION_PAGE@advisorTasksMsg">
<%@ include file="/database/global.jspf" %>


<%-- Warning/Error display --%>
<oem:messageBox messageType="info" 
                errorTableBinding="info@servletRequest"
                titleTextKey="titleText" mainTextKey="mainText"/>
<oem:messageBox messageType="error" 
                errorTableBinding="errors@servletRequest"
                titleTextKey="titleText" mainTextKey="mainText"/>

<uix:tableLayout>
<uix:rowLayout>
<uix:messageTextInput promptBinding="EXPIRES_IN_LABEL@advisorTasksMsg"
		      name="selectedExpiresIn"
                      columns="10"
		      textBinding="selectedExpiresIn@defaultBean@servletRequest">
</uix:messageTextInput>
</uix:rowLayout>
</uix:tableLayout>
<uix:pageButtons>
<uix:pageButtonBar>
<uix:button textBinding="CANCEL@uixDBObjectMsg"
	destinationBinding="backURL@servletRequest"/>
<uix:submitButton textBinding="OK@uixDBObjectMsg"
	name="event" value="doChangeExpiration" />
</uix:pageButtonBar>
</uix:pageButtons>

</uix:pageLayout>

</db:form>

</uix:body>

</uix:document> 
</uix:renderingContext> 
