<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<uix:bundle name="advisorTasksMsg"
	    class="oracle.sysman.db.rsc.inst.AdvisorTasksMsg"/>
<uix:bundle name="uixDBObjectMsg"
	    class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="ScheduleBundle"
          class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

<oem:setURLEncoder id="renderingContext"/>

<uix:document>

<%@ include file="/oemTitle.jspf" %>

<uix:body>

<db:form name="reschedule" destinationBinding="formDest@servletRequest" copyParams="target,type,dbPageNum">
<uix:formValue name="pageName" valueBinding="pageName@servletRequest"/>

<uix:pageLayout titleBinding="RESCHEDULE_PAGE@advisorTasksMsg">

<%-- Warning/Error display --%>
<oem:messageBox messageType="info"
                errorTableBinding="info@servletRequest"
                titleTextKey="titleText" mainTextKey="mainText"/>
<oem:messageBox messageType="error"
                errorTableBinding="errors@servletRequest"
                titleTextKey="titleText" mainTextKey="mainText"/>

<%@ include file="/database/global.jspf" %>

<uix:spacer height="5"/>

<uix:tableLayout cellSpacing="5">
<%-- START TIME ZONE --%>
<uix:cellFormat hAlign="right">
<uix:styledText  styleClass="oraPromptText" labeledNodeId="timeZone"
     textBinding="TIME_ZONE@ScheduleBundle"
/>
</uix:cellFormat>
<uix:cellFormat>
<oem:choice
     name="startTimeZoneSB" id="timeZone"
     optionsBinding="timeZonesSB@scheduleBean@servletRequest"
     selectedValueBinding="startTimeZoneSB@scheduleBean@servletRequest"
/>
</uix:cellFormat>
</uix:tableLayout>

<%@ include file="/sdk/schedule/start.jspf" %>

<uix:pageButtons>
<uix:pageButtonBar>
<uix:button textBinding="CANCEL@uixDBObjectMsg"
	destinationBinding="backURL@servletRequest"/>
<uix:submitButton textBinding="OK@uixDBObjectMsg"
	name="event" value="doReschedule" />
</uix:pageButtonBar>
</uix:pageButtons>
</uix:pageLayout>

</db:form>

</uix:body>

</uix:document>
</uix:renderingContext>
