<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 

<uix:renderingContext id="renderingContext">
<uix:bundle name="dbMsg"
	    class="oracle.sysman.db.rsc.inst.DBMsg"/>
<uix:bundle name="sqlMsg"
	    class="oracle.sysman.db.rsc.inst.SQLMsg"/>
<uix:bundle name="spiaMsg"
	    class="oracle.sysman.db.rsc.inst.SPIAMsg"/>
<oem:setURLEncoder id="renderingContext"/> 
<uix:document> 
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
        <db:form name="foo" destination="/console/database/instance/sqlFrontpage"
                copyParams="target,type,dbPageNum,advisoryCentralURL">
        <uix:pageLayout>
        <%@ include file="/database/global.jspf" %>
        <uix:header textBinding="SQL_ADVISORS@dbMsg">
            <uix:styledText styleClass="OraInstructionText" 
                textBinding="SQL_ADVISORS_FRONT_PG_DESC@sqlMsg" />
            <uix:spacer height="15"/>
            <%-- sql Access Advisor --%>
            <uix:header textBinding="SQLACCESS_ADVISOR@dbMsg">
                <uix:tableLayout width="100%">
                <uix:rowLayout>
                    <uix:cellFormat width="20%" 
                        vAlign="top"
                        hAlign="end">
                    <oem:license>
                        <uix:styledText textBinding="SQLACCESS_ADVISOR@dbMsg"
                            destinationBinding="saaDest@servletRequest" />
                    </oem:license>
                    </uix:cellFormat>
                    <uix:cellFormat width="15" />
                    <uix:cellFormat>
                        <uix:styledText styleClass="OraInstructionText" 
                            textBinding="SQL_ACCESS_ADVISOR_DESC@sqlMsg" />                
                    </uix:cellFormat>
                </uix:rowLayout>
                </uix:tableLayout>
            </uix:header>
            <%-- sql Tuning Advisor --%>
            <uix:header textBinding="SQL_TUNING_ADVISOR@dbMsg">
                <uix:tableLayout width="100%">
                <uix:rowLayout>
                    <uix:cellFormat width="20%" 
                            vAlign="top"
                            hAlign="end">
                        <uix:styledText textBinding="SQL_TUNING_ADVISOR@dbMsg"
                            destinationBinding="staDest@servletRequest" />
                    </uix:cellFormat>
                    <uix:cellFormat width="15" />
                    <uix:cellFormat>
                        <uix:styledText styleClass="OraInstructionText" 
                            textBinding="SQL_TUNING_ADVISOR_DESC@sqlMsg" />                
                    </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                    <uix:cellFormat width="20%" 
                            vAlign="top"
                            hAlign="end">
                        <uix:styledText textBinding="AUTOMATIC_SQL_TUNING_RESULTS@dbMsg"
                            destinationBinding="autoStaResultsDest@servletRequest" 
                            renderedBinding="version11gOrHigher@servletRequest" />
                    </uix:cellFormat>
                    <uix:cellFormat width="15" />
                    <uix:cellFormat>
                        <uix:styledText styleClass="OraInstructionText" 
                            textBinding="AUTOMATIC_SQL_TUNING_RESULTS_DESC@sqlMsg" />                
                    </uix:cellFormat>
                </uix:rowLayout>
                </uix:tableLayout>
            </uix:header>
            <%-- sql Repair Advisor --%>
            <uix:header textBinding="SQL_DIAG_ADVISOR@dbMsg">
                <uix:rowLayout>
                    <uix:styledText styleClass="OraInstructionText" 
                        textBinding="SQL_DIAG_ADVISOR_DESC@sqlMsg" />
                </uix:rowLayout>
                <uix:spacer height="5"/>
                <uix:tableLayout width="100%">
                <uix:rowLayout>
                    <uix:cellFormat width="20%" 
                            vAlign="top"
                            hAlign="end">
                        <uix:styledText styleClass="OraTipText" 
                                textBinding="SQL_INCIDENT_ANALYSIS@dbMsg"/>
                    </uix:cellFormat>
                    <uix:cellFormat width="15" />
                    <uix:cellFormat>
                        <uix:rowLayout>
                            <uix:styledText styleClass="OraInstructionText" 
                                textBinding="SQL_INCIDENT_ANALYSIS_DESC@sqlMsg" /> 
                        </uix:rowLayout>
                        <uix:rowLayout>
                            <uix:styledText textBinding="SQL_INCIDENT_ANALYSIS_LINK@sqlMsg"
                                destinationBinding="supportWorkbenchDest@servletRequest" />                        
                        </uix:rowLayout>
                    </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                    <uix:cellFormat width="20%" 
                            vAlign="top"
                            hAlign="end">
                        <uix:styledText styleClass="OraTipText" 
                                textBinding="SQL_FAILURE_ANALYSIS@dbMsg" />
                    </uix:cellFormat>
                    <uix:cellFormat width="15" />
                    <uix:cellFormat>
                        <uix:rowLayout>
                            <uix:styledText styleClass="OraInstructionText" 
                                textBinding="SQL_FAILURE_ANALYSIS_DESC@sqlMsg" />                
                        </uix:rowLayout>
                        <uix:rowLayout>
                            <uix:styledText textBinding="SQL_FAILURE_ANALYSIS_LINK@sqlMsg"
                                destinationBinding="sqlWorksheetDest@servletRequest" />                        
                        </uix:rowLayout>
                    </uix:cellFormat>
                </uix:rowLayout>
                </uix:tableLayout>
            </uix:header>
            <%-- SQL Performance Analyzer --%>
            <%-- uix:header textBinding="SPIA@spiaMsg">
                <uix:tableLayout width="100%">
                <uix:rowLayout>
                    <uix:cellFormat width="20%" 
                        vAlign="top"
                        hAlign="end">
                        <uix:styledText textBinding="SPIA@spiaMsg"
                            destinationBinding="spiaDest@servletRequest" />
                    </uix:cellFormat>
                    <uix:cellFormat width="15" />
                    <uix:cellFormat>
                        <uix:styledText styleClass="OraInstructionText" 
                            textBinding="SQL_PERFORMANCE_ANALYZER_DESC@sqlMsg"
                            renderedBinding="version11gOrHigher@servletRequest" />                
                    </uix:cellFormat>
                </uix:rowLayout>
                </uix:tableLayout>
            </uix:header --%>    
        </uix:header>
        </uix:pageLayout>
        </db:form>
    </uix:body>
</uix:document>
</uix:renderingContext>
