<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<script language="JavaScript">
function onClickDateRange()
{
    var mostRecentValue = false;
    var timeIntervalValue = true;

    if (document.getElementById('timeInterval').checked)
    {
        mostRecentValue = true;
        timeIntervalValue = false;
    }

    document.getElementById('mostRecentNumber').disabled = mostRecentValue;
    document.getElementById('mostRecentUnit').disabled = mostRecentValue;
    document.getElementById('startEndDate').disabled = timeIntervalValue;
}
</script>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head
        titleBinding="adrAlertLogSearchPageTitle@defaultBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body onLoad="onClickDateRange()">
      <db:form
        name="form"
        destinationBinding="destination@defaultBean@servletRequest"
        copyParams="target,type,cancelURL"
        method="post">

        <uix:formValue
          name="pageName"
          value="/database/instance/alertlog/adr/adrAlertLogSearch"/>

        <uix:pageLayout>
          <%@ include file="/database/global.jspf" %>
          <%@ include file="/database/instance/alertlog/adr/errors.jspf" %>

          <uix:header
            textBinding="adrAlertLogSearchPageHeader@defaultBean@servletRequest">
            <%@ include file="/database/instance/alertlog/adr/adrAlertLogTop.jspf" %>

            <uix:hideShowHeader
              id="searchHeader"
              partialRenderMode="self"
              formSubmitted="true"
              disclosedBinding="searchShown@defaultBean@servletRequest"
              textBinding="SEARCH_CRITERIA@defaultBundle@servletRequest">
              <uix:tableLayout width="100%">
                <uix:rowLayout>
                  <uix:cellFormat vAlign="top" hAlign="left">
                    <uix:header
                      textBinding="DATE_RANGE@defaultBundle@servletRequest">
  
                      <uix:rowLayout>
                        <uix:flowLayout>
                          <oem:radioButton
                            id="mostRecent"
                            name="dateRangeType"
                            shortDescBinding="MOST_RECENT@defaultBundle@servletRequest"
                            selectedValueBinding="dateRangeType@defaultBean@servletRequest"
                            selected="true"
                            textBinding="MOST_RECENT@defaultBundle@servletRequest"
                            value="MOST_RECENT"
                            onClick="onClickDateRange()"/>
                          <uix:textInput
                            name="mostRecentNumber"
                            shortDescBinding="MOST_RECENT@defaultBundle@servletRequest"
                            columns="1"
                            maximumLength="3"
                            textBinding="mostRecentNumber@defaultBean@servletRequest">
                            <uix:onSubmitValidater>
                              <uix:decimal minValue="0"/>
                            </uix:onSubmitValidater>
                          </uix:textInput>
                          <uix:choice
                            id="mostRecentUnit"
                            name="mostRecentUnit"
                            shortDescBinding="MOST_RECENT@defaultBundle@servletRequest"
                            selectedValueBinding="mostRecentUnit@defaultBean@servletRequest">
                            <uix:option textBinding="MINUTES@defaultBundle@servletRequest" value="MINUTES"/>
                            <uix:option textBinding="HOURS@defaultBundle@servletRequest" value="HOURS"/>
                            <uix:option textBinding="DAYS@defaultBundle@servletRequest" value="DAYS"/>
                            <uix:option textBinding="WEEKS@defaultBundle@servletRequest" value="WEEKS"/>
                          </uix:choice>
                        </uix:flowLayout>
                      </uix:rowLayout>
  
                      <uix:spacer height="5"/>
  
                      <uix:rowLayout>
                        <oem:radioButton
                          id="timeInterval"
                          name="dateRangeType"
                          selectedValueBinding="dateRangeType@defaultBean@servletRequest"
                          selected="false"
                          textBinding="TIME_INTERVAL@defaultBundle@servletRequest"
                          value="TIME_INTERVAL"
                          onClick="onClickDateRange()"/>
                      </uix:rowLayout>
  
                      <uix:spacer height="5"/>
  
                      <uix:rowLayout id="startEndDate">
                        <uix:spacer width="20"/>
                        <uix:cellFormat>
                          <uix:rowLayout>
                            <uix:messageDateField
                              id="startDate"
                              name="startDate"
                              promptBinding="START_DATE@sdkBundle@servletRequest"
                              valueBinding="startDate@defaultBean@servletRequest"
                              tipBinding="startDateTip@defaultBean@servletRequest">
                              <uix:onSubmitValidater>
                                <uix:date dateStyle="medium"/>
                              </uix:onSubmitValidater>
                            </uix:messageDateField>
                          </uix:rowLayout>
  
                          <uix:spacer height="10"/>
  
                          <uix:rowLayout>
                            <uix:messageChoice
                              id="startTimeHour"
                              name="startTimeHour"
                              promptBinding="START_TIME@sdkBundle@servletRequest"
                              shortDescBinding="START_TIME@sdkBundle@servletRequest"
                              selectedValueBinding="startTimeHour@defaultBean@servletRequest">
                              <uix:option text="01" value="1"/>
                              <uix:option text="02" value="2"/>
                              <uix:option text="03" value="3"/>
                              <uix:option text="04" value="4"/>
                              <uix:option text="05" value="5"/>
                              <uix:option text="06" value="6"/>
                              <uix:option text="07" value="7"/>
                              <uix:option text="08" value="8"/>
                              <uix:option text="09" value="9"/>
                              <uix:option text="10" value="10"/>
                              <uix:option text="11" value="11"/>
                              <uix:option text="12" value="0"/>
                            </uix:messageChoice>
                            <uix:choice
                              id="startTimeMinute"
                              name="startTimeMinute"
                              shortDescBinding="START_TIME@sdkBundle@servletRequest"
                              selectedValueBinding="startTimeMinute@defaultBean@servletRequest">
                              <uix:option text="00" value="0"/>
                              <uix:option text="01" value="1"/>
                              <uix:option text="02" value="2"/>
                              <uix:option text="03" value="3"/>
                              <uix:option text="04" value="4"/>
                              <uix:option text="05" value="5"/>
                              <uix:option text="06" value="6"/>
                              <uix:option text="07" value="7"/>
                              <uix:option text="08" value="8"/>
                              <uix:option text="09" value="9"/>
                              <uix:option text="10" value="10"/>
                              <uix:option text="11" value="11"/>
                              <uix:option text="12" value="12"/>
                              <uix:option text="13" value="13"/>
                              <uix:option text="14" value="14"/>
                              <uix:option text="15" value="15"/>
                              <uix:option text="16" value="16"/>
                              <uix:option text="17" value="17"/>
                              <uix:option text="18" value="18"/>
                              <uix:option text="19" value="19"/>
                              <uix:option text="20" value="20"/>
                              <uix:option text="21" value="21"/>
                              <uix:option text="22" value="22"/>
                              <uix:option text="23" value="23"/>
                              <uix:option text="24" value="24"/>
                              <uix:option text="25" value="25"/>
                              <uix:option text="26" value="26"/>
                              <uix:option text="27" value="27"/>
                              <uix:option text="28" value="28"/>
                              <uix:option text="29" value="29"/>
                              <uix:option text="30" value="30"/>
                              <uix:option text="31" value="31"/>
                              <uix:option text="32" value="32"/>
                              <uix:option text="33" value="33"/>
                              <uix:option text="34" value="34"/>
                              <uix:option text="35" value="35"/>
                              <uix:option text="36" value="36"/>
                              <uix:option text="37" value="37"/>
                              <uix:option text="38" value="38"/>
                              <uix:option text="39" value="39"/>
                              <uix:option text="40" value="40"/>
                              <uix:option text="41" value="41"/>
                              <uix:option text="42" value="42"/>
                              <uix:option text="43" value="43"/>
                              <uix:option text="44" value="44"/>
                              <uix:option text="45" value="45"/>
                              <uix:option text="46" value="46"/>
                              <uix:option text="47" value="47"/>
                              <uix:option text="48" value="48"/>
                              <uix:option text="49" value="49"/>
                              <uix:option text="50" value="50"/>
                              <uix:option text="51" value="51"/>
                              <uix:option text="52" value="52"/>
                              <uix:option text="53" value="53"/>
                              <uix:option text="54" value="54"/>
                              <uix:option text="55" value="55"/>
                              <uix:option text="56" value="56"/>
                              <uix:option text="57" value="57"/>
                              <uix:option text="58" value="58"/>
                              <uix:option text="59" value="59"/>
                            </uix:choice>
                            <oem:radioButton
                              id="startAm"
                              name="startAmPm"
                              value="AM_VALUE"
                              selectedValueBinding="startAmPm@defaultBean@servletRequest"
                              textBinding="AM_LABEL@sdkBundle@servletRequest"
                              shortDescBinding="AM_LABEL@sdkBundle@servletRequest"
                              styleClass="OraInstructionText"/>
                            <oem:radioButton
                              id="startPm"
                              name="startAmPm"
                              value="PM_VALUE"
                              selectedValueBinding="startAmPm@defaultBean@servletRequest"
                              textBinding="PM_LABEL@sdkBundle@servletRequest"
                              shortDescBinding="PM_LABEL@sdkBundle@servletRequest"
                              styleClass="OraInstructionText"/>
                          </uix:rowLayout>
                        </uix:cellFormat>
  
                        <uix:spacer width="20"/>
                        <uix:cellFormat>
                          <uix:rowLayout>
                            <uix:messageDateField
                              id="endDate"
                              name="endDate"
                              promptBinding="END_DATE@sdkBundle@servletRequest"
                              valueBinding="endDate@defaultBean@servletRequest"
                              messageTypeBinding="endDateMessageType@defaultBean@servletRequest"
                              messageBinding="endDateMessage@defaultBean@servletRequest"
                              tipBinding="endDateTip@defaultBean@servletRequest">
                              <uix:onSubmitValidater>
                                <uix:date dateStyle="medium"/>
                              </uix:onSubmitValidater>
                            </uix:messageDateField>
                          </uix:rowLayout>
  
                          <uix:spacer height="10"/>
  
                          <uix:rowLayout>
                            <uix:messageChoice
                              id="endTimeHour"
                              name="endTimeHour"
                              promptBinding="END_TIME@sdkBundle@servletRequest"
                              shortDescBinding="END_TIME@sdkBundle@servletRequest"
                              selectedValueBinding="endTimeHour@defaultBean@servletRequest">
                              <uix:option text="01" value="1"/>
                              <uix:option text="02" value="2"/>
                              <uix:option text="03" value="3"/>
                              <uix:option text="04" value="4"/>
                              <uix:option text="05" value="5"/>
                              <uix:option text="06" value="6"/>
                              <uix:option text="07" value="7"/>
                              <uix:option text="08" value="8"/>
                              <uix:option text="09" value="9"/>
                              <uix:option text="10" value="10"/>
                              <uix:option text="11" value="11"/>
                              <uix:option text="12" value="0"/>
                            </uix:messageChoice>
                            <uix:choice
                              id="endTimeMinute"
                              name="endTimeMinute"
                              shortDescBinding="END_TIME@sdkBundle@servletRequest"
                              selectedValueBinding="endTimeMinute@defaultBean@servletRequest">
                              <uix:option text="00" value="0"/>
                              <uix:option text="01" value="1"/>
                              <uix:option text="02" value="2"/>
                              <uix:option text="03" value="3"/>
                              <uix:option text="04" value="4"/>
                              <uix:option text="05" value="5"/>
                              <uix:option text="06" value="6"/>
                              <uix:option text="07" value="7"/>
                              <uix:option text="08" value="8"/>
                              <uix:option text="09" value="9"/>
                              <uix:option text="10" value="10"/>
                              <uix:option text="11" value="11"/>
                              <uix:option text="12" value="12"/>
                              <uix:option text="13" value="13"/>
                              <uix:option text="14" value="14"/>
                              <uix:option text="15" value="15"/>
                              <uix:option text="16" value="16"/>
                              <uix:option text="17" value="17"/>
                              <uix:option text="18" value="18"/>
                              <uix:option text="19" value="19"/>
                              <uix:option text="20" value="20"/>
                              <uix:option text="21" value="21"/>
                              <uix:option text="22" value="22"/>
                              <uix:option text="23" value="23"/>
                              <uix:option text="24" value="24"/>
                              <uix:option text="25" value="25"/>
                              <uix:option text="26" value="26"/>
                              <uix:option text="27" value="27"/>
                              <uix:option text="28" value="28"/>
                              <uix:option text="29" value="29"/>
                              <uix:option text="30" value="30"/>
                              <uix:option text="31" value="31"/>
                              <uix:option text="32" value="32"/>
                              <uix:option text="33" value="33"/>
                              <uix:option text="34" value="34"/>
                              <uix:option text="35" value="35"/>
                              <uix:option text="36" value="36"/>
                              <uix:option text="37" value="37"/>
                              <uix:option text="38" value="38"/>
                              <uix:option text="39" value="39"/>
                              <uix:option text="40" value="40"/>
                              <uix:option text="41" value="41"/>
                              <uix:option text="42" value="42"/>
                              <uix:option text="43" value="43"/>
                              <uix:option text="44" value="44"/>
                              <uix:option text="45" value="45"/>
                              <uix:option text="46" value="46"/>
                              <uix:option text="47" value="47"/>
                              <uix:option text="48" value="48"/>
                              <uix:option text="49" value="49"/>
                              <uix:option text="50" value="50"/>
                              <uix:option text="51" value="51"/>
                              <uix:option text="52" value="52"/>
                              <uix:option text="53" value="53"/>
                              <uix:option text="54" value="54"/>
                              <uix:option text="55" value="55"/>
                              <uix:option text="56" value="56"/>
                              <uix:option text="57" value="57"/>
                              <uix:option text="58" value="58"/>
                              <uix:option text="59" value="59"/>
                            </uix:choice>
                            <oem:radioButton
                              id="endAm"
                              name="endAmPm"
                              value="AM_VALUE"
                              selectedValueBinding="endAmPm@defaultBean@servletRequest"
                              textBinding="AM_LABEL@sdkBundle@servletRequest"
                              shortDescBinding="AM_LABEL@sdkBundle@servletRequest"
                              styleClass="OraInstructionText"/>
                            <oem:radioButton
                              id="endPm"
                              name="endAmPm"
                              value="PM_VALUE"
                              selectedValueBinding="endAmPm@defaultBean@servletRequest"
                              textBinding="PM_LABEL@sdkBundle@servletRequest"
                              shortDescBinding="PM_LABEL@sdkBundle@servletRequest"
                              styleClass="OraInstructionText"/>
                          </uix:rowLayout>

                        </uix:cellFormat>
                      </uix:rowLayout>
  
                      <uix:rowLayout id="goButton">
                        <uix:switcher
                          childNameBinding="advancedSearchShown@defaultBean@servletRequest">
                          <uix:case name="false">
                          <uix:stackLayout>
                            <uix:spacer height="5"/>
                            <uix:submitButton
                              textBinding="GO@sdkBundle@servletRequest"
                              shortDescBinding="GO@sdkBundle@servletRequest"
                              event="searchLog"/>
                            </uix:stackLayout>
                          </uix:case>
                        </uix:switcher>  
                      </uix:rowLayout>

                    </uix:header>
                  </uix:cellFormat>
  
                  <uix:cellFormat vAlign="top" hAlign="right">
                    <uix:header
                      textBinding="MESSAGE_TYPES@defaultBundle@servletRequest">
                      <uix:rowLayout>
                        <uix:cellFormat vAlign="top">
                          <uix:stackLayout>
                            <uix:checkBox
                              name="messageTypeIncidentError"
                              textBinding="INCIDENT_ERROR@defaultBundle@servletRequest"
                              selectedValueBinding="messageTypeIncidentError@defaultBean@servletRequest"
                              value="1"/>
                            <uix:checkBox
                              name="messageTypeError"
                              textBinding="ERROR@defaultBundle@servletRequest"
                              selectedValueBinding="messageTypeError@defaultBean@servletRequest"
                              value="1"/>
                          </uix:stackLayout>
                        </uix:cellFormat>
  
                        <uix:spacer width="5"/>
  
                        <uix:cellFormat vAlign="top">
                          <uix:stackLayout>
                            <uix:checkBox
                              name="messageTypeWarning"
                              textBinding="WARNING@defaultBundle@servletRequest"
                              selectedValueBinding="messageTypeWarning@defaultBean@servletRequest"
                              value="1"/>
                            <uix:checkBox
                              name="messageTypeNotification"
                              textBinding="NOTIFICATION@defaultBundle@servletRequest"
                              selectedValueBinding="messageTypeNotification@defaultBean@servletRequest"
                              value="1"/>
                          </uix:stackLayout>
                        </uix:cellFormat>
  
                        <uix:spacer width="5"/>
  
                        <uix:cellFormat vAlign="top">
                          <uix:stackLayout>
                            <uix:checkBox
                              name="messageTypeTrace"
                              textBinding="TRACE@defaultBundle@servletRequest"
                              selectedValueBinding="messageTypeTrace@defaultBean@servletRequest"
                              value="1"/>
                            <uix:checkBox
                              name="messageTypeUnknown"
                              textBinding="UNKNOWN@defaultBundle@servletRequest"
                              selectedValueBinding="messageTypeUnknown@defaultBean@servletRequest"
                                value="1"/>
                          </uix:stackLayout>
                        </uix:cellFormat>
                      </uix:rowLayout>
  
                      <uix:spacer height="20"/>
  
                      <uix:rowLayout>
                        <uix:spacer width="20"/>
                        <uix:cellFormat vAlign="top">
                          <uix:messagePrompt
                            promptBinding="MESSAGE_TEXT@defaultBundle@servletRequest"/>
                        </uix:cellFormat>
  
                        <uix:spacer width="10"/>
  
                        <uix:cellFormat vAlign="top">
                          <uix:stackLayout>
                            <uix:textInput
                              name="messageText"
                              columns="64"
                              maximumLength="256"
                              shortDescBinding="MESSAGE_TEXT@defaultBundle@servletRequest"
                              textBinding="messageText@defaultBean@servletRequest"/>
                            <uix:checkBox
                              name="messageTextRegularExpression"
                              textBinding="REGULAR_EXPRESSION@defaultBundle@servletRequest"
                              selectedValueBinding="messageTextRegularExpression@defaultBean@servletRequest"
                              value="1"/>
                          </uix:stackLayout>
                        </uix:cellFormat>
                      </uix:rowLayout>
  
                      <uix:spacer height="20"/>
  
                      <uix:rowLayout>
                        <uix:labeledFieldLayout>
                          <uix:messageTextInput
                            name="maximumEntriesRetrieved"
                            promptBinding="MAXIMUM_ENTRIES_RETRIEVED@defaultBundle@servletRequest"
                            shortDescBinding="MAXIMUM_ENTRIES_RETRIEVED@defaultBundle@servletRequest"
                            textBinding="maximumEntriesRetrieved@defaultBean@servletRequest"
                            columns="2"
                            maximumLength="5">
                            <uix:onSubmitValidater>
                              <uix:decimal minValue="0"/>
                            </uix:onSubmitValidater>
                          </uix:messageTextInput>
  
                          <uix:messageTextInput
                            name="entriesPerPage"
                            promptBinding="ENTRIES_PER_PAGE@defaultBundle@servletRequest"
                            shortDescBinding="ENTRIES_PER_PAGE@defaultBundle@servletRequest"
                            textBinding="entriesPerPage@defaultBean@servletRequest"
                            columns="2"
                            maximumLength="5">
                            <uix:onSubmitValidater>
                              <uix:decimal minValue="0"/>
                            </uix:onSubmitValidater>
                          </uix:messageTextInput>
                        </uix:labeledFieldLayout>
                      </uix:rowLayout>
  
                    </uix:header>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
  
              <uix:tableLayout width="100%">
                <uix:rowLayout>
                  <uix:hideShowHeader
                    id="advancedSearchHeader"
                    partialRenderMode="multiple"
                    partialTargets="goButton"
                    formSubmitted="true"
                    disclosedBinding="advancedSearchShown@defaultBean@servletRequest"
                    textBinding="ADVANCED_SEARCH_OPTIONS@defaultBundle@servletRequest">
                    <uix:rowLayout>
                      <uix:messageChoice
                        id="logMessageField"
                        name="logMessageField"
                        selectedValueBinding="logMessageField@logMessageFieldsBean@servletRequest"
                        promptBinding="LOG_MESSAGE_FIELD@defaultBundle@servletRequest"
                        shortDescBinding="LOG_MESSAGE_FIELD@defaultBundle@servletRequest">
                        <uix:contents
                          childDataBinding="logMessageFields@logMessageFieldsBean@servletRequest">
                          <uix:option
                            textBinding="textKey"
                            valueBinding="valueKey"/>
                        </uix:contents>
                      </uix:messageChoice>
                      <uix:spacer width="5"/>
                      <uix:button
                        renderedBinding="logMessageFieldsAvailable@logMessageFieldsBean@servletRequest"
                        shortDescBinding="ADD_ROW@defaultBundle@servletRequest"
                        textBinding="ADD_ROW@defaultBundle@servletRequest"
                        onClick="submitForm('form', true, { event:'addRows',source:'logMessageFieldsUIDataSource',size:'1' })"/>
                    </uix:rowLayout>
                    <uix:spacer height="3"/>
                    <oem:table 
                      summaryBinding="FILTER_BY_LOG_MESSAGE_FIELDS@defaultBundle@servletRequest"
                      width="100%" 
                      blockSizeBinding="blockSize@logMessageFieldsBean@servletRequest"
                      formSubmitted="true"
                      id="logMessageFieldsTable"
                      partialRenderMode="self"
                      name="logMessageFieldsUIDataSource" 
                      dataSourceProp="logMessageFieldsUIDataSource"
                      beanKey="logMessageFieldsBean"
                      alternateTextBinding="NO_ITEMS_FOUND@sdkBundle@servletRequest">
                    </oem:table>

                    <uix:rowLayout>
                      <uix:switcher
                        childNameBinding="advancedSearchShown@defaultBean@servletRequest">
                        <uix:case name="true">
                        <uix:stackLayout>
                          <uix:spacer height="5"/>
                          <uix:submitButton
                            textBinding="GO@sdkBundle@servletRequest"
                            shortDescBinding="GO@sdkBundle@servletRequest"
                            event="searchLog"/>
                          </uix:stackLayout>
                        </uix:case>
                      </uix:switcher>  
                    </uix:rowLayout>

                  </uix:hideShowHeader>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:hideShowHeader>

            <uix:spacer height="5"/>
            <uix:separator/>

            <%@ include file="/database/instance/alertlog/adr/adrAlertLogEntries.jspf" %>

          </uix:header>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
