<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/setRefreshRate.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="adrAlertLogTaskProcessingPageTitle@defaultBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form name="form"
        destinationBinding="destination@defaultBean@servletRequest"
        method="post" copyParams="target,type">

        <uix:formValue name="pageName"
          value="/database/instance/alertlog/adr/adrAlertLogTaskProcessing"/>

        <uix:pageLayout
          titleBinding="adrAlertLogTaskProcessingPageHeader@defaultBean@servletRequest">
          <%@ include file="/database/global.jspf" %>
          <%@ include file="/database/instance/alertlog/adr/errors.jspf" %>

          <uix:pageStatus>
            <uix:stackLayout>
              <uix:styledText
                textBinding="LOG_TASK_STATUS@defaultBundle@servletRequest"
                styleClass="OraInstructionTextStrong"/>
              <uix:styledText
                textBinding="CANCEL_OPERATION@defaultBundle@servletRequest"
                styleClass="OraInstructionText"/>
            </uix:stackLayout>
          </uix:pageStatus>

          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton
                textBinding="CANCEL@sdkBundle@servletRequest"
                name="event"
                value="cancelTask"/>
             </uix:pageButtonBar>
          </uix:pageButtons>

          <uix:spacer height="20"/>

          <uix:processing
            timeInterval="<%=processingPageInterval%>">
            <uix:styledText
              textBinding="LOG_TASK_RUNNING@defaultBundle@servletRequest"
              styleClass="OraProcessingStatusFixed"/>
          </uix:processing>

          <uix:spacer height="10"/>

          <uix:tip
            textBinding="PROMPT_OPERATION_CONTINUE@defaultBundle@servletRequest"/>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
