<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>

<%@ page import="oracle.sysman.eml.PageNames" %>
<%@ page import="oracle.sysman.emSDK.eml.EmlConstants" %>
<%@ page import="oracle.cabo.ui.partial.PartialPageUtils"%>

<% oracle.cabo.share.util.CaboHttpUtils.setNoCacheHeaders(response); %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="SDKUIResourceBundle" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="JobsResourceBundle" class="oracle.sysman.resources.eml.jobs.JobsResource"/>
  <uix:bundle name="MntrResourceBundle" class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="MultiTargetResourceBundle" class="oracle.sysman.eml.rsc.target.MultiTargetMsg"/>
  <uix:bundle name="DbRscInstBundle" class="oracle.sysman.db.rsc.inst.DBMsg"/>
  <uix:bundle name="AlertLogBundle" class="oracle.sysman.db.rsc.inst.AlertLogMsg"/>
 <%
  String dest = (String)request.getSession().getAttribute("processingDoneDestination");
  if (dest != null)
  {
    PartialPageUtils.forceRedirectURL(renderingContext, dest);
    request.getSession().removeAttribute("processingDoneDestination");
  }
  %>
  
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

      <uix:contents>
      
        <uix:form name="alertLogContent"  method="post">
        
          <uix:pageLayout titleBinding="title@alertLogContent@servletRequest">

            <%@ include file="/enablePPR.jspf" %>
            <%@ include file="/oemGlobal.jspf" %>

            <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
            <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

              
<uix:header rendered="true" textBinding="SEARCH_CRITERIA@DbRscInstBundle">     



<uix:styledText styleClass="OraInstructionText"
                textBinding="SEARCH_DESCRIPTION@AlertLogBundle"/>

<uix:tableLayout cellSpacing="5">
  <uix:rowLayout vAlign="top">
    <uix:cellFormat  hAlign="right">
      <uix:messageDateField id="startDate" 
                            shortDescBinding="BEGIN_DATE@DbRscInstBundle"
                            name="startDate"
                            valueBinding="startDate@alertLogContent@servletRequest"
                            promptBinding="BEGIN_DATE@DbRscInstBundle"
                            tipBinding="dateTip@alertLogContent@servletRequest"
                            columns="10">
        <uix:onSubmitValidater>
          <uix:date dateStyle="medium" />
        </uix:onSubmitValidater>
      </uix:messageDateField>
    </uix:cellFormat>
    <uix:spacer width="10" />
    <uix:messageChoice promptBinding="TIME@SDKUIResourceBundle"                   
                       styleClass="OraPromptText"
                       name="startHour" 
                       id="startHour" 
                       shortDescBinding="HOURS@SDKUIResourceBundle"
                       selectedValueBinding="startHour@alertLogContent@servletRequest">
                  <uix:contents>
                     <uix:option text="" value=""/>
                     <uix:option text="1" value="1"/>
                     <uix:option text="2" value="2"/>
                     <uix:option text="3" value="3"/>
                     <uix:option text="4" value="4"/>
                     <uix:option text="5" value="5"/>
                     <uix:option text="6" value="6"/>
                     <uix:option text="7" value="7"/>
                     <uix:option text="8" value="8"/>
                     <uix:option text="9" value="9"/>
                     <uix:option text="10" value="10"/>
                     <uix:option text="11" value="11"/>
                     <uix:option text="12" value="12"/>
                  </uix:contents>
    </uix:messageChoice>          
    <uix:styledText text=":" styleClass="OraPromptText"/>
    <uix:choice name="startMin" id="startMin" 
                  shortDescBinding="MINUTES@SDKUIResourceBundle"
                  selectedValueBinding="startMin@@alertLogContent@servletRequest">
        <uix:contents>
          <uix:option text="" value=""/>
          <uix:option text="00" value="00"/>
          <uix:option text="05" value="05"/>                
          <uix:option text="10" value="10"/>                 
          <uix:option text="15" value="15"/>
          <uix:option text="20" value="20"/>
          <uix:option text="25" value="25"/>
          <uix:option text="30" value="30"/>
          <uix:option text="35" value="35"/>
          <uix:option text="40" value="40"/>
          <uix:option text="45" value="45"/>
          <uix:option text="50" value="50"/>
          <uix:option text="55" value="55"/>
        </uix:contents> 
    </uix:choice>                 
    <uix:spacer width="5"/>
    <uix:radioButton textBinding="AM_LABEL@SDKUIResourceBundle"
                     name="startTime"
                     selectedValueBinding="startTime@alertLogContent@servletRequest"
                     value="am"/>
    <uix:radioButton textBinding="PM_LABEL@SDKUIResourceBundle"
                     name="startTime"
                     selectedValueBinding="startTime@alertLogContent@servletRequest"
                     value="pm"/>
  </uix:rowLayout>

  <uix:rowLayout vAlign="top">
    <uix:cellFormat  hAlign="right">
      <uix:messageDateField id="endDate" 
                            shortDescBinding="END_DATE@SDKUIResourceBundle"
                            name="endDate"
                            valueBinding="endDate@alertLogContent@servletRequest"
                            promptBinding="END_DATE@SDKUIResourceBundle"
                            tipBinding="dateTip@alertLogContent@servletRequest"
                            columns="10">
        <uix:onSubmitValidater>
          <uix:date dateStyle="medium" />
        </uix:onSubmitValidater>
      </uix:messageDateField>
    </uix:cellFormat>
    <uix:spacer width="10" />
    <uix:messageChoice promptBinding="TIME@SDKUIResourceBundle"                   
                       styleClass="OraPromptText"
                       name="endHour" 
                       id="endHour" 
                       shortDescBinding="HOURS@SDKUIResourceBundle"
                       selectedValueBinding="endHour@alertLogContent@servletRequest">
                  <uix:contents>
                     <uix:option text="" value=""/>
                     <uix:option text="1" value="1"/>
                     <uix:option text="2" value="2"/>
                     <uix:option text="3" value="3"/>
                     <uix:option text="4" value="4"/>
                     <uix:option text="5" value="5"/>
                     <uix:option text="6" value="6"/>
                     <uix:option text="7" value="7"/>
                     <uix:option text="8" value="8"/>
                     <uix:option text="9" value="9"/>
                     <uix:option text="10" value="10"/>
                     <uix:option text="11" value="11"/>
                     <uix:option text="12" value="12"/>
                  </uix:contents>
    </uix:messageChoice>          
    <uix:styledText text=":" styleClass="OraPromptText"/>
    <uix:choice name="endMin" id="endMin" 
                  shortDescBinding="MINUTES@SDKUIResourceBundle"
                  selectedValueBinding="endMin@@alertLogContent@servletRequest">
        <uix:contents>
          <uix:option text="" value=""/>
          <uix:option text="00" value="00"/>
          <uix:option text="05" value="05"/>                
          <uix:option text="10" value="10"/>                 
          <uix:option text="15" value="15"/>
          <uix:option text="20" value="20"/>
          <uix:option text="25" value="25"/>
          <uix:option text="30" value="30"/>
          <uix:option text="35" value="35"/>
          <uix:option text="40" value="40"/>
          <uix:option text="45" value="45"/>
          <uix:option text="50" value="50"/>
          <uix:option text="55" value="55"/>
        </uix:contents> 
    </uix:choice>                 
    <uix:spacer width="5"/>
    <uix:radioButton textBinding="AM_LABEL@SDKUIResourceBundle"
                     name="endTime"
                     selectedValueBinding="endTime@alertLogContent@servletRequest"
                     value="am"/>
    <uix:radioButton textBinding="PM_LABEL@SDKUIResourceBundle"
                     name="endTime"
                     selectedValueBinding="endTime@alertLogContent@servletRequest"
                     value="pm"/>
  </uix:rowLayout>
  
   <uix:rowLayout vAlign="top">
     <uix:submitButton textBinding="GO@DbRscInstBundle"
                       shortDescBinding="GO@DbRscInstBundle"
                       name="event"
                       value="searchAlertLog"
                       />
   </uix:rowLayout> 

</uix:tableLayout>
</uix:header>
            <uix:tableLayout width="100%">
              <uix:rowLayout>
                <uix:spacer width="12"/>
                <uix:separator/>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:spacer width="12"/>
                <uix:stackLayout>
                  <uix:borderLayout id="Targets_Table">
                    <uix:left>
                      <uix:switcher 
                          childNameBinding="executionResultsAvailable@alertLogContent@servletRequest">
                        <uix:case name="false">
                          <uix:styledText
                              styleClass="OraInstructionText"
                              textBinding="willBeExecutedInfo@alertLogContent@servletRequest"/>
                        </uix:case>
                        <uix:case name="true">
                          <uix:borderLayout>
                            <uix:left>
                              <uix:labeledFieldLayout 
                                  renderedBinding="executionResultsAvailable@alertLogContent@servletRequest"
                                  labelWidth="10%" columns="2">
                                <uix:messageStyledText
                                    contentStyleClass="OraDataText"
                                    promptBinding="SUCCEEDED@MultiTargetResourceBundle"
                                    textBinding="numSucceeded@alertLogContent@servletRequest"/>
                                <uix:messageStyledText
                                    contentStyleClass="OraDataText"
                                    promptBinding="FAILED@MultiTargetResourceBundle"
                                    textBinding="numFailed@alertLogContent@servletRequest"/>
                              </uix:labeledFieldLayout>
                            </uix:left>
                            <uix:right>
                              <uix:labeledFieldLayout 
                                  renderedBinding="executionResultsAvailable@alertLogContent@servletRequest"
                                  labelWidth="10%" columns="1">
                                <uix:messageStyledText
                                    contentStyleClass="OraDataText"
                                    promptBinding="EXECUTED@MultiTargetResourceBundle"
                                    textBinding="formattedExecuteDate@alertLogContent@servletRequest"/>
                              </uix:labeledFieldLayout>
                            </uix:right>
                          </uix:borderLayout>
                        </uix:case>
                      </uix:switcher>
                    </uix:left>
                    <uix:right>
                      <uix:tableLayout width="100%">
                        <uix:rowLayout hAlign="right">
                          <uix:cellFormat wrappingDisabled="true">
                            <uix:pageButtonBar>                                
                              <oem:targetSelection
                                  textBinding="ADD@SDKUIResourceBundle"/>
                            </uix:pageButtonBar>
                          </uix:cellFormat>
                        </uix:rowLayout>
                      </uix:tableLayout>
                    </uix:right>
                  </uix:borderLayout>

                  <uix:dataScope
                      currentDataBinding="alertLogContentTable@alertLogContent@servletRequest">

                    <uix:table
                        id="Targets"
                        name="alertLogContentTable" 
                        formSubmitted="true"
                        showAll="yes"                       
                        width="100%"
                        partialRenderMode="self"
                        summaryBinding="TARGETS_TABLE@MultiTargetResourceBundle"
                        allDetailsEnabledBinding="renderShowAllHideAllDetailsLinks"
                        detailDisclosureBinding="detailDisclosureList"
                        tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                        valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                        maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                        blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>"
                        alternateTextBinding="NO_TARGETS_FOUND@MultiTargetResourceBundle">

                      <uix:detail>
                        <uix:tableLayout width="100%">
                        
                         <uix:rowLayout renderedBinding="renderLogContentLines">
                            <uix:cellFormat hAlign="left">
                               <uix:styledText styleClass="OraPromptText"
                                               textBinding="LINES_RETURNED@AlertLogBundle"/>
                            
                            <uix:spacer width="5"/>
                              <uix:styledText styleClass="OraDataText"
                                              textBinding="logContentLines"/>                           
                            </uix:cellFormat>                                              
                          </uix:rowLayout>
                         
                          <uix:rowLayout>
                            <uix:cellFormat hAlign="left">                            
                              <uix:rawText text="<pre>"/>                              
                                <uix:text
                                    textBinding="results"/>
                              <uix:rawText text="</pre>"/>                           
                            </uix:cellFormat>
                          </uix:rowLayout>
                          <uix:rowLayout renderedBinding="renderDetailsColumnShowMore">
                            <uix:cellFormat hAlign="left">
                              <uix:styledText
                                  text=". . ."
                                  shortDescBinding="RESULTS_TRUNCATED@MultiTargetResourceBundle"
                                  styleClass="OraInstructionTextStrong"/>
                             <uix:spacer width="20"/>
                              <uix:link
                                  textBinding="COMPLETE_EXECUTION_RESULTS@MultiTargetResourceBundle"
                                  destinationBinding="detailsColumnShowMoreDestination"/>
                            </uix:cellFormat>
                          </uix:rowLayout>
                        </uix:tableLayout>
                      </uix:detail>

                      <%-- Database column - only displayed with Execute SQL --%>
                      <uix:column renderedBinding="renderDatabaseColumn">
                        <uix:columnHeader>
                          <uix:sortableHeader 
                              textBinding="NAME@SDKUIResourceBundle"
                              sortableBinding="databaseColumnSortable"/>
                        </uix:columnHeader> 
                        <uix:columnFormat columnDataFormat="textFormat"/>
                        <uix:messageStyledText
                            textBinding="databaseColumn"
                            destinationBinding="databaseColumnDestination"
                            messageBinding="databaseColumnMessage"
                            messageTypeBinding="databaseColumnMessageType">
                        </uix:messageStyledText>
                      </uix:column>

                      <%-- Target Type column - only displayed with Execute SQL --%>
                      <uix:column renderedBinding="renderDatabaseColumn">
                        <uix:columnHeader>
                          <uix:sortableHeader 
                              textBinding="TYPE@MultiTargetResourceBundle"
                              sortableBinding="targetTypeColumnSortable"/>
                        </uix:columnHeader> 
                        <uix:columnFormat columnDataFormat="textFormat"/>
                        <uix:messageStyledText
                            textBinding="targetTypeColumn">
                        </uix:messageStyledText>
                      </uix:column>

                      <%-- Host column - always displayed --%>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:sortableHeader 
                              textBinding="HOST@MultiTargetResourceBundle"
                              sortableBinding="hostColumnSortable"/>
                        </uix:columnHeader> 
                        <uix:columnFormat columnDataFormat="textFormat"/>
                        <uix:messageStyledText
                            textBinding="hostColumn"
                            destinationBinding="hostColumnDestination"
                            messageBinding="hostColumnMessage"
                            messageTypeBinding="hostColumnMessageType">
                        </uix:messageStyledText>
                      </uix:column>

                      <%-- Execution Status column - always displayed --%>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:sortableHeader 
                              textBinding="EXECUTION_STATUS@MultiTargetResourceBundle"
                              sortableBinding="executionStatusColumnSortable"/>
                        </uix:columnHeader> 
                        <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                        <uix:image
                            shortDescBinding="executionStatusColumn"
                            sourceBinding="executionStatusColumnIcon"
                            destinationBinding="executionStatusColumnDestination"
                            textBinding="NO_EXECUTION_CONDUCTED@MultiTargetResourceBundle"/>
                      </uix:column>

                      <%-- Elapsed Time column - always displayed --%>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:sortableHeader 
                              textBinding="EXEC_TABLE_RUNNING_TIME_COLUMN@JobsResourceBundle"
                              sortableBinding="elapsedTimeColumnSortable"/>
                        </uix:columnHeader> 
                        <uix:columnFormat columnDataFormat="numberFormat"/>
                        <uix:messageStyledText
                            textBinding="elapsedTimeColumn">
                        </uix:messageStyledText>
                      </uix:column>

                      <%-- Remove column - always displayed --%>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:sortableHeader 
                              textBinding="REMOVE@SDKUIResourceBundle"/>
                        </uix:columnHeader> 
                        <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                        <uix:image
                            shortDescBinding="REMOVE@SDKUIResourceBundle"
                            sourceBinding="removeColumnIcon"
                            onClickBinding="removeColumnDestination"/>
                      </uix:column>

                    </uix:table>
                  </uix:dataScope>

                  <uix:messageText
                      messageBinding="(TARGETS_TABLE@MultiTargetResourceBundle)@messages@servletRequest"
                      messageTypeBinding="(TARGETS_TABLE@MultiTargetResourceBundle)@messageTypes@servletRequest"/>

                </uix:stackLayout>
              </uix:rowLayout>
        
            </uix:tableLayout>

    
            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton
                    textBinding="OK@SDKUIResourceBundle"
                    name="event"
                    value="ok"/>
              </uix:pageButtonBar>
            </uix:pageButtons>
          </uix:pageLayout>
        </uix:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>
