<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%@ page import="oracle.sysman.eml.PageNames" %>
<%@ page import="oracle.sysman.emSDK.eml.EmlConstants" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="MultiTargetResourceBundle" class="oracle.sysman.eml.rsc.target.MultiTargetMsg"/>

  <uix:document>
 
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:contents>
        <uix:form name="alertLogContentProcessing" method="post">
          <uix:pageLayout>

            <%@ include file="/enablePPR.jspf" %>
            <%@ include file="/oemGlobal.jspf" %>

            <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
            </uix:messages>

            <uix:header
                textBinding="procPageHeader@alertLogContent@servletRequest"
                icon="/em/images/processl.gif">

              <uix:borderLayout>
                <uix:left>
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="procPageInstrWait@alertLogContent@servletRequest"/>
                </uix:left>
                <uix:right>
                  <uix:tableLayout width="100%">
                    <uix:rowLayout hAlign="right">
                      <uix:submitButton
                          name="event"
                          value="cancelProcessing"
                          textBinding="CANCEL@MultiTargetResourceBundle"/>
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:right>
              </uix:borderLayout>

              <uix:tableLayout width="100%" hAlign="center">

                <uix:rowLayout>
                  <uix:borderLayout>
                  <uix:left>
                    <uix:styledText
                        styleClass="OraInstructionText"
                        textBinding="procPageInstrCancel@alertLogContent@servletRequest"/>
                  </uix:left>
                  </uix:borderLayout>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:spacer height="20"/>
                </uix:rowLayout>
 
                <uix:rowLayout hAlign="center">
                  <uix:cellFormat hAlign="center">
                    <uix:stackLayout>
                      <uix:contents>
                        <uix:processing
                            id="executeProcessingControl"
                            timeIntervalBinding="refreshRate@alertLogContent@servletRequest">
                          <uix:contents>
                            <uix:labeledFieldLayout labelWidth="75%">
                              <uix:contents>
                                <%-- currently executing targets --%>
                                <uix:messageStyledText
                                    styleClass="OraDataText"
                                    promptBinding="currentlyExecutingPrompt@alertLogContent@servletRequest"
                                    textBinding="executionItem0@alertLogContent@servletRequest"/>
                                <uix:messageStyledText 
                                    styleClass="OraDataText"
                                    renderedBinding="executionItem1Rendered@alertLogContent@servletRequest"
                                    textBinding="executionItem1@alertLogContent@servletRequest"/>
                                <uix:messageStyledText 
                                    styleClass="OraDataText"
                                    renderedBinding="executionItem2Rendered@alertLogContent@servletRequest"
                                    textBinding="executionItem2@alertLogContent@servletRequest"/>
                                <uix:messageStyledText 
                                    styleClass="OraDataText"
                                    renderedBinding="executionItem3Rendered@alertLogContent@servletRequest"
                                    textBinding="executionItem3@alertLogContent@servletRequest"/>
                                <uix:messageStyledText 
                                    styleClass="OraDataText"
                                    renderedBinding="executionItem4Rendered@alertLogContent@servletRequest"
                                    textBinding="executionItem4@alertLogContent@servletRequest"/>
                                <%-- other info: succeeded, failed, num remaining --%>
                                <uix:messagePrompt
                                    promptBinding="SUCCEEDED@MultiTargetResourceBundle"/>
                                <uix:styledText
                                    styleClass="OraDataText"
                                    textBinding="numSucceeded@alertLogContent@servletRequest"/>
                                <uix:messagePrompt
                                    promptBinding="FAILED@MultiTargetResourceBundle"/>
                                <uix:styledText
                                    styleClass="OraDataText"
                                    textBinding="numFailed@alertLogContent@servletRequest"/>
                                <uix:messagePrompt
                                    promptBinding="REMAINING@MultiTargetResourceBundle"/>
                                <uix:styledText
                                    styleClass="OraDataText"
                                    textBinding="numRemainingForDisplay@alertLogContent@servletRequest"/>
                              </uix:contents>
                            </uix:labeledFieldLayout>
                          </uix:contents>
                        </uix:processing>
                      </uix:contents>
                    </uix:stackLayout>
                  </uix:cellFormat>
                </uix:rowLayout>

              </uix:tableLayout>
            </uix:header>

            <uix:contentFooter>
              <uix:pageButtonBar>
                <uix:submitButton 
                    name="event"
                    value="cancelProcessing"
                    textBinding="CANCEL@MultiTargetResourceBundle"/>
              </uix:pageButtonBar>
            </uix:contentFooter>

          </uix:pageLayout>
        </uix:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>

