<%@ include file="/sdk/oemTop.jspf" %>
<!-- ========== Alert Log Monitoring Configuration Page ========== -->

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">

  <uix:bundle name="SDKMsgs" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="DBMsgs" class="oracle.sysman.db.rsc.inst.DBMsg"/>

  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>
<%@ include file="/oemTitle.jspf" %>
    <uix:styleSheet/>
    <uix:body>
      <uix:form name="alertLogConf"
                destination="/console/database/instance/alertlog">

        <uix:formValue name="pageName"
                       value="/database/instance/alertlog"/>

        <uix:formValue name="target"
                       valueBinding="targetName@alertLogBean@servletRequest"/>
        <uix:formValue name="type"
                       valueBinding="targetType@alertLogBean@servletRequest"/>

        <uix:pageLayout>
<%@ include file="/database/global.jspf" %>

          <%-- .......... Inline Message Box .......... --%>
          <uix:switcher childNameBinding="showResult@servletRequest">
            <uix:case name="true">
              <uix:messageBox messageTypeBinding="resultStatus@servletRequest"
                              messageBinding="resultMessage@servletRequest"/>
            </uix:case>
          </uix:switcher>

          <uix:header textBinding="ALERTLOG_ENTRIES_CUSTOMIZE@DBMsgs">

            <uix:styledText styleClass="OraInstructionText"
                            textBinding="ALERTLOG_CONFIG_PAGE_DESC@DBMsgs"/>

            <%-- .......... Alert Log Properties .......... --%>
            <uix:header textBinding="ALERTLOG_CONFIG_PROPERTY_HEADER@DBMsgs">
              <uix:stackLayout>
                <uix:styledText styleClass="OraInstructionText"
                                textBinding="ALERTLOG_CONFIG_IGNORE_DESC@DBMsgs"/>
                <uix:spacer height="10"/>
                <uix:tableLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right" vAlign="center"
                                    wrappingDisabled="true">
                      <uix:messagePrompt promptBinding="ALERTLOG_CONFIG_IGNORE_LABEL@DBMsgs"
                                         labeledNodeId="ignorePattern"/>
                    </uix:cellFormat>
                    <uix:spacer width="10"/>
                    <uix:cellFormat hAlign="left" vAlign="center">
                      <uix:textInput textBinding="ignorePattern@alertLogBean@servletRequest"
                                     columns="45"
                                     name="ignorePattern"
                                     nodeID="ignorePattern"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:spacer width="0"/>
                    <uix:spacer width="10"/>
                    <uix:cellFormat hAlign="left" vAlign="top">
                      <uix:tip>
                        <uix:tableLayout>
                          <uix:rowLayout>
                            <uix:styledText styleClass="OraTipText"
                                            textBinding="ALERTLOGCONFIG_IGNORETIP@DBMsgs"/>
                          </uix:rowLayout>
                          <uix:rowLayout>
                            <uix:rowLayout>
                              <uix:cellFormat vAlign="top">
                                <uix:styledText styleClass="OraTipLabel"
                                                textBinding="EXAMPLE@DBMsgs"/>
                              </uix:cellFormat>
                              <uix:spacer width="5"/>
                              <uix:styledText styleClass="OraTipText"
                                              textBinding="ALERTLOGCONFIG_IGNORE_EXAMPLE@DBMsgs"/>
                            </uix:rowLayout>
                          </uix:rowLayout>
                        </uix:tableLayout>
                      </uix:tip>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>
<%--
                <uix:spacer height="10"/>
                <uix:rowLayout>
                  <uix:cellFormat vAlign="top">
                    <uix:styledText styleClass="OraTipLabel"
                                    textBinding="NOTE@DBMsgs"/>
                  </uix:cellFormat>
                  <uix:spacer width="5"/>
                  <uix:styledText styleClass="OraTipText"
                                  textBinding="ALERTLOG_CONFIG_IGNORE_NOTE@DBMsgs"/>
                </uix:rowLayout>
  --%>
              </uix:stackLayout>
            </uix:header>

            <%-- .......... Alert Log Thresholds .......... --%>
            <uix:header textBinding="ALERTLOG_CONFIG_THRESHOLD_HEADER@DBMsgs">
              <uix:stackLayout>
<%--
                <uix:styledText styleClass="OraInstructionText"
                                textBinding="ALERTLOG_CONFIG_CATEGORY_DESC@DBMsgs"/>
                <uix:spacer height="10"/>
  --%>
                <uix:styledText styleClass="OraInstructionText"
                                textBinding="ALERTLOG_CONFIG_THRESHOLD_DESC@DBMsgs"/>
                <uix:spacer height="10"/>
                <uix:tableLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right" vAlign="center"
                                    wrappingDisabled="true">
                      <uix:messagePrompt promptBinding="ALERTLOG_CONFIG_THRESHOLD_LABEL_CRITICAL@DBMsgs"
                                         labeledNodeId="criticalThreshold"/>
                    </uix:cellFormat>
                    <uix:spacer width="10"/>
                    <uix:cellFormat hAlign="left" vAlign="center">
                      <uix:textInput textBinding="criticalThreshold@alertLogBean@servletRequest"
                                     columns="45"
                                     name="criticalThreshold"
                                     nodeID="criticalThreshold"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right" vAlign="center"
                                    wrappingDisabled="true">
                      <uix:messagePrompt promptBinding="ALERTLOG_CONFIG_THRESHOLD_LABEL_WARNING@DBMsgs"
                                         labeledNodeId="warningThreshold"/>
                    </uix:cellFormat>
                    <uix:spacer width="10"/>
                    <uix:cellFormat hAlign="left" vAlign="center">
                      <uix:textInput textBinding="warningThreshold@alertLogBean@servletRequest"
                                     columns="45"
                                     name="warningThreshold"
                                     nodeID="warningThreshold"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:spacer width="0"/>
                    <uix:spacer width="10"/>
                    <uix:cellFormat hAlign="left" vAlign="top">
                      <uix:tip>
                        <uix:tableLayout>
                          <uix:rowLayout>
                            <uix:styledText styleClass="OraTipText"
                                            textBinding="ALERTLOG_CONFIG_THRESHOLD_TIP@DBMsgs"/>
                          </uix:rowLayout>
                          <uix:rowLayout>
                            <uix:rowLayout>
                              <uix:cellFormat vAlign="top">
                                <uix:styledText styleClass="OraTipLabel"
                                                textBinding="EXAMPLE@DBMsgs"/>
                              </uix:cellFormat>
                              <uix:spacer width="5"/>
                              <uix:styledText styleClass="OraTipText"
                                              textBinding="ALERTLOGCONFIG_THRESHOLD_EXAMPLE@DBMsgs"/>
                            </uix:rowLayout>
                          </uix:rowLayout>
                        </uix:tableLayout>
                      </uix:tip>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>
              </uix:stackLayout>
            </uix:header>

            <uix:spacer height="10"/>
            <uix:tableLayout>
              <uix:rowLayout>
                <uix:cellFormat vAlign="top">
                  <uix:styledText styleClass="OraTipLabel"
                                  textBinding="NOTE@DBMsgs"/>
                </uix:cellFormat>
                <uix:spacer width="5"/>
                <uix:styledText styleClass="OraTipText"
                                textBinding="ALERTLOG_CONFIG_IGNORE_NOTE@DBMsgs"/>
              </uix:rowLayout>

              <uix:rowLayout>
                <uix:cellFormat vAlign="top">
                  <uix:styledText styleClass="OraTipLabel"
                                  textBinding="NOTE@DBMsgs"/>
                </uix:cellFormat>
                <uix:spacer width="5"/>
                <uix:styledText styleClass="OraTipText"
                                textBinding="ALERTLOG_CONFIG_THRESHOLD_NOTE@DBMsgs"/>
              </uix:rowLayout>
            </uix:tableLayout>
          </uix:header>

          <%-- .......... Button Bar .......... --%>
          <uix:contentFooter>
            <uix:pageButtonBar>
              <uix:button textBinding="CANCEL@SDKMsgs"
                          destinationBinding="cancelDest@servletRequest"/>
              <uix:submitButton textBinding="APPLY@SDKMsgs"
                                formName="alertLogConf"
                                name="event"
                                value="setProperties"
                                disabledBinding="queryFailed@alertLogBean@servletRequest"/>
            </uix:pageButtonBar>
          </uix:contentFooter>
        </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>

</uix:renderingContext>
