<%@ include file="/sdk/oemTop.jspf" %>
<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<db:script src="/database/utils.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:bundle name="AutoSqlTuneBundle" class="oracle.sysman.db.rsc.inst.AutoSqlTuneMsg"/>
  
<uix:document>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

<uix:body>                
<%-- HTML Form --%>
<db:form name="configForm" method="POST" destination="autoSqlTuneConfig" copyParams="target,type">
  <uix:formValue name="pageName" value="/database/instance/autosta/config"/>      
 
<uix:pageLayout titleBinding="AUTOSQLTUNE_SETTINGS@AutoSqlTuneBundle">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

         <uix:spacer height="10"/>
        <uix:tableLayout cellSpacing="5">
            <uix:rowLayout>
               <uix:contents>
                 <uix:cellFormat hAlign="right">
                   <uix:messagePrompt promptBinding="MAX_TIME_TUNING@AutoSqlTuneBundle" labeledNodeId="localTimeLimit"/> 
                 </uix:cellFormat> 
      		     <uix:textInput id="localTimeLimit" name="localTimeLimit" textBinding="localTimeLimit@defaultBean@servletRequest"  >
                 <uix:onSubmitValidater>
                    <uix:decimal/>
                 </uix:onSubmitValidater>
                 </uix:textInput>
               </uix:contents>
            </uix:rowLayout>
                
           <uix:rowLayout>
                   <uix:contents>
                     <uix:cellFormat hAlign="right">
                      <uix:messagePrompt promptBinding="AUTO_PROFILES@AutoSqlTuneBundle"/> 
                     </uix:cellFormat>      
                     <uix:cellFormat>         
                      <uix:radioButton name="acceptProfile"
                          textBinding="YES@AutoSqlTuneBundle"
                          value="TRUE"
                          selectedValueBinding="acceptProfile@defaultBean@servletRequest" />      
                      <uix:radioButton name="acceptProfile"
                          textBinding="NO@AutoSqlTuneBundle"
                          value="FALSE"
                          selectedValueBinding="acceptProfile@defaultBean@servletRequest" /> 
                     </uix:cellFormat>                          
                   </uix:contents>
            </uix:rowLayout>
                
            <uix:rowLayout>
               <uix:contents>
                 <uix:cellFormat hAlign="right">
                   <uix:messagePrompt promptBinding="MAX_PROFILE_EXEC@AutoSqlTuneBundle" labeledNodeId="maxProfileExec"/> 
                 </uix:cellFormat> 
      		     <uix:textInput id="maxProfileExec" name="maxProfileExec" textBinding="maxProfileExec@defaultBean@servletRequest" >
                 <uix:onSubmitValidater>
                    <uix:decimal/>
                 </uix:onSubmitValidater>
                 </uix:textInput>
               </uix:contents>
            </uix:rowLayout>   
            
            <uix:rowLayout>
               <uix:contents>
                 <uix:cellFormat hAlign="right">
                   <uix:messagePrompt promptBinding="MAX_PROFILE_ALL@AutoSqlTuneBundle" labeledNodeId="maxProfileAll"/> 
                 </uix:cellFormat> 
      		     <uix:textInput id="maxProfileAll" name="maxProfileAll" textBinding="maxProfileAll@defaultBean@servletRequest" >
                 <uix:onSubmitValidater>
                    <uix:decimal/>
                 </uix:onSubmitValidater>
                 </uix:textInput>
               </uix:contents>
            </uix:rowLayout>               
        </uix:tableLayout>        
  <%-- Create/Edit Buttons --%> 
  <uix:pageButtons>
    <uix:pageButtonBar>
          <jsp:include page="/database/schema/pageButtonInclude.jsp" />
          <uix:ref refID="pageButtonInclude" />
    </uix:pageButtonBar>
  </uix:pageButtons>
  
</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 



