<%@ include file = "/sdk/oemTop.jspf"  %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/>
    <uix:bundle name="SDKUIResourceBundle" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>    
    <uix:bundle name="DbRscInstBundle" class="oracle.sysman.db.rsc.inst.DBMsg"/>
    <uix:bundle name="AutoSqlTuneBundle" class="oracle.sysman.db.rsc.inst.AutoSqlTuneMsg"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

      <uix:contents>
      
        <uix:form name="customForm"  method="post">
           
          <uix:pageLayout titleBinding="CUSTOM_TIME_PERIOD@AutoSqlTuneBundle">
 <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
            <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
            <%@ include file="/enablePPR.jspf" %>
            <%@ include file="/oemGlobal.jspf" %>

        
              
<uix:tableLayout cellSpacing="5">
  <uix:rowLayout vAlign="top">
    <uix:cellFormat  hAlign="right">
      <uix:messageDateField id="beginDay" 
                            shortDescBinding="BEGIN_DATE@DbRscInstBundle"
                            name="beginDay"
                            valueBinding="beginDay@defaultBean@servletRequest"
                            promptBinding="BEGIN_DATE@DbRscInstBundle"
                            tipBinding="dateTip@defaultBean@servletRequest"
                            columns="10">
        <uix:onSubmitValidater>
          <uix:date dateStyle="medium" />
        </uix:onSubmitValidater>
      </uix:messageDateField>
    </uix:cellFormat>
    <uix:spacer width="10" />
    <uix:messageChoice promptBinding="TIME@SDKUIResourceBundle"                   
                       styleClass="OraPromptText"
                       name="beginHour" 
                       id="beginHour" 
                       shortDescBinding="HOURS@SDKUIResourceBundle"
                       selectedValueBinding="beginHour@defaultBean@servletRequest">
                  <uix:contents>
                     <uix:option text="1" value="1"/>
                     <uix:option text="2" value="2"/>
                     <uix:option text="3" value="3"/>
                     <uix:option text="4" value="4"/>
                     <uix:option text="5" value="5"/>
                     <uix:option text="6" value="6"/>
                     <uix:option text="7" value="7"/>
                     <uix:option text="8" value="8"/>
                     <uix:option text="9" value="9"/>
                     <uix:option text="10" value="10"/>
                     <uix:option text="11" value="11"/>
                     <uix:option text="12" value="12"/>
                  </uix:contents>
    </uix:messageChoice>          
    <uix:styledText text=":" styleClass="OraPromptText"/>
    <uix:choice name="beginMin" id="beginMin" 
                  shortDescBinding="MINUTES@SDKUIResourceBundle"
                  selectedValueBinding="beginMin@@defaultBean@servletRequest">
        <uix:contents>          
          <uix:option text="00" value="00"/>
          <uix:option text="05" value="05"/>                
          <uix:option text="10" value="10"/>                 
          <uix:option text="15" value="15"/>
          <uix:option text="20" value="20"/>
          <uix:option text="25" value="25"/>
          <uix:option text="30" value="30"/>
          <uix:option text="35" value="35"/>
          <uix:option text="40" value="40"/>
          <uix:option text="45" value="45"/>
          <uix:option text="50" value="50"/>
          <uix:option text="55" value="55"/>
        </uix:contents> 
    </uix:choice>                 
    <uix:spacer width="5"/>
    <uix:radioButton textBinding="AM_LABEL@SDKUIResourceBundle"
                     name="beginTime"
                     selectedValueBinding="beginTime@defaultBean@servletRequest"
                     value="am"/>
    <uix:radioButton textBinding="PM_LABEL@SDKUIResourceBundle"
                     name="beginTime"
                     selectedValueBinding="beginTime@defaultBean@servletRequest"
                     value="pm"/>
  </uix:rowLayout>

  <uix:rowLayout vAlign="top">
    <uix:cellFormat  hAlign="right">
      <uix:messageDateField id="endDay" 
                            shortDescBinding="END_DATE@SDKUIResourceBundle"
                            name="endDay"
                            valueBinding="endDay@defaultBean@servletRequest"
                            promptBinding="END_DATE@SDKUIResourceBundle"
                            tipBinding="dateTip@defaultBean@servletRequest"
                            columns="10">
        <uix:onSubmitValidater>
          <uix:date dateStyle="medium" />
        </uix:onSubmitValidater>
      </uix:messageDateField>
    </uix:cellFormat>
    <uix:spacer width="10" />
    <uix:messageChoice promptBinding="TIME@SDKUIResourceBundle"                   
                       styleClass="OraPromptText"
                       name="endHour" 
                       id="endHour" 
                       shortDescBinding="HOURS@SDKUIResourceBundle"
                       selectedValueBinding="endHour@defaultBean@servletRequest">
                  <uix:contents>                     
                     <uix:option text="1" value="1"/>
                     <uix:option text="2" value="2"/>
                     <uix:option text="3" value="3"/>
                     <uix:option text="4" value="4"/>
                     <uix:option text="5" value="5"/>
                     <uix:option text="6" value="6"/>
                     <uix:option text="7" value="7"/>
                     <uix:option text="8" value="8"/>
                     <uix:option text="9" value="9"/>
                     <uix:option text="10" value="10"/>
                     <uix:option text="11" value="11"/>
                     <uix:option text="12" value="12"/>
                  </uix:contents>
    </uix:messageChoice>          
    <uix:styledText text=":" styleClass="OraPromptText"/>
    <uix:choice name="endMin" id="endMin" 
                  shortDescBinding="MINUTES@SDKUIResourceBundle"
                  selectedValueBinding="endMin@@defaultBean@servletRequest">
        <uix:contents>
          <uix:option text="00" value="00"/>
          <uix:option text="05" value="05"/>                
          <uix:option text="10" value="10"/>                 
          <uix:option text="15" value="15"/>
          <uix:option text="20" value="20"/>
          <uix:option text="25" value="25"/>
          <uix:option text="30" value="30"/>
          <uix:option text="35" value="35"/>
          <uix:option text="40" value="40"/>
          <uix:option text="45" value="45"/>
          <uix:option text="50" value="50"/>
          <uix:option text="55" value="55"/>
        </uix:contents> 
    </uix:choice>                 
    <uix:spacer width="5"/>
    <uix:radioButton textBinding="AM_LABEL@SDKUIResourceBundle"
                     name="endTime"
                     selectedValueBinding="endTime@defaultBean@servletRequest"
                     value="am"/>
    <uix:radioButton textBinding="PM_LABEL@SDKUIResourceBundle"
                     name="endTime"
                     selectedValueBinding="endTime@defaultBean@servletRequest"
                     value="pm"/>
  </uix:rowLayout>
  
</uix:tableLayout>
            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton
                    textBinding="CANCEL@SDKUIResourceBundle"
                    name="event"
                    value="cusCancel"/>
                <uix:submitButton
                    textBinding="OK@SDKUIResourceBundle"
                    name="event"
                    value="cusOK"/>
              </uix:pageButtonBar>
            </uix:pageButtons>
            
          </uix:pageLayout>
        </uix:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>