<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">  
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="AutoSqlTuneBundle" class="oracle.sysman.db.rsc.inst.AutoSqlTuneMsg"/>
  <uix:bundle name="sqlMsg"	    class="oracle.sysman.db.rsc.inst.SQLMsg"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <db:form name="detailsForm" destination="autoSqlTune" copyParams="target,type,task_id,taskName,taskUser">    
      <uix:formValue name="pageName" value="details"/> 
      <uix:formValue name="finding_filter" valueBinding="findingFilter@defaultBean@servletRequest"/> 
           <uix:pageLayout> 
        <%@ include file="/database/global.jspf" %> 
       <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>        
       <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/> 
        <%-- 
        ---- Main Header
        --%>
        <uix:header textBinding="detailPageHeader@defaultBean@servletRequest">
         <uix:stackLayout>
              <uix:labeledFieldLayout columns="2" renderedBinding="isManual@defaultBean@servletRequest">
                <uix:styledText styleClass="OraPromptText" textBinding="RST_STATUS@sqlMsg"/>
                <uix:styledText styleClass="OraDataText" textBinding="status@taskAttributes@defaultBean@servletRequest"/>

                <uix:styledText styleClass="OraPromptText" textBinding="RST_TUNING_SET_OWNER@sqlMsg" />
                <uix:styledText styleClass="OraDataText" textBinding="owner@taskAttributes@defaultBean@servletRequest"/>
                
                <uix:styledText styleClass="OraPromptText" textBinding="RST_STARTED@sqlMsg"/>
                <uix:styledText styleClass="OraDataText" textBinding="started@taskAttributes@defaultBean@servletRequest"/>

                <uix:styledText styleClass="OraPromptText"
                                textBinding="RST_TUNING_SET_NAME@sqlMsg"/>
                <uix:styledText styleClass="OraDataText"
                                textBinding="name@taskAttributes@defaultBean@servletRequest"/>

                <uix:styledText styleClass="OraPromptText" textBinding="RST_COMPLETED@sqlMsg"/>
                <uix:styledText styleClass="OraDataText" textBinding="completed@taskAttributes@defaultBean@servletRequest"/>

                <uix:styledText styleClass="OraPromptText" textBinding="RST_TIME_LIMIT@sqlMsg"/>
                <uix:styledText styleClass="OraDataText" textBinding="time_limit@taskAttributes@defaultBean@servletRequest"/>

                
                <uix:styledText styleClass="OraPromptText" textBinding="RST_RUNNING_TIME@sqlMsg"/>
                <uix:styledText styleClass="OraDataText" textBinding="running_time@taskAttributes@defaultBean@servletRequest"/>
              </uix:labeledFieldLayout>
              
          <uix:tableLayout width="100%" renderedBinding="isAuto@defaultBean@servletRequest">
           <uix:rowLayout>
            <uix:cellFormat hAlign="left" >
            <uix:tableLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" >
                  <uix:messagePrompt promptBinding="BEGIN_DATE@AutoSqlTuneBundle"/>
                </uix:cellFormat>
                  <uix:spacer width="10"/>  
                  <uix:styledText styleClass="OraDataText" 
                                  textBinding="startStr@defaultBean@servletRequest" />
              </uix:rowLayout>
            </uix:tableLayout>
            </uix:cellFormat> 
            <uix:cellFormat hAlign="left" >
            <uix:tableLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" >
                  <uix:messagePrompt promptBinding="END_DATE@AutoSqlTuneBundle"/>
                </uix:cellFormat>
                  <uix:spacer width="10"/>
                  <uix:styledText styleClass="OraDataText" 
                                  textBinding="endStr@defaultBean@servletRequest" />
              </uix:rowLayout>
            </uix:tableLayout>
            </uix:cellFormat>
           </uix:rowLayout>
          </uix:tableLayout>
            <uix:spacer width="5"/> 
<%--             
          <uix:styledText styleClass="OraInstructionText" 
                          textBinding="statements@defaultBean@servletRequest" />
--%> 

<%-- KEY SQL PROFILE --%>
   <uix:switcher childNameBinding="isKeySqlProfile@defaultBean@@servletRequest">
      <uix:case name="true">

         <uix:header textBinding="TASK_STATUS@AutoSqlTuneBundle">
              <uix:tableLayout>
                <uix:rowLayout>
                  <uix:spacer width="10"/>   
                  <uix:flowLayout>
                  <uix:styledText styleClass="OraInstructionText" 
                         textBinding="AUTOSQLTUNE_STATUS@AutoSqlTuneBundle" />
                  <uix:spacer width="5"/>                         
                  <uix:styledText styleClass="OraDataText" 
                         textBinding="status@defaultBean@servletRequest" />
                  <uix:spacer width="10"/>                                      
                  <uix:submitButton textBinding="CONFIGURE@AutoSqlTuneBundle" name="event" value="doConfig" />                                     
                  </uix:flowLayout>                         
                </uix:rowLayout>              
                <uix:rowLayout>
                  <uix:spacer width="10"/>      
                  <uix:flowLayout>
                  <uix:styledText styleClass="OraInstructionText" 
                         textBinding="AUTO_PROFILES_STATUS@AutoSqlTuneBundle" />
                  <uix:spacer width="5"/>                         
                  <uix:styledText styleClass="OraDataText" 
                         textBinding="profileStatus@defaultBean@servletRequest" />
                  <uix:spacer width="10"/>                                      
                  <uix:spacer height="0" width="3" />
                  <uix:button textBinding="CONFIGURE@AutoSqlTuneBundle"
                             destinationBinding="autoSqlTuneConfigLink@servletRequest"/>

                  </uix:flowLayout>                         
                </uix:rowLayout>
              </uix:tableLayout>
                 
         </uix:header> 
     </uix:case>
   </uix:switcher>

                        
          <uix:header textBinding="RECOMMENDATIONS@AutoSqlTuneBundle">
            <uix:tableLayout width="100%">
	    <uix:rowLayout>
              <uix:styledText styleClass="OraInstructionText" 
                              textBinding="RECOMMEND_DESC@AutoSqlTuneBundle" />
	    </uix:rowLayout>
	    <uix:rowLayout>
         
		     <uix:switcher childNameBinding="dbVersionGTE112@servletRequest">
		     <uix:case name="true">
              <uix:table width="100%"
                         name="sql"
                         tableDataBinding="sqlList@defaultBean@servletRequest"
                         columnFormatsBinding="sqlColFormats@defaultBean@pageContext"
                         columnHeaderDataBinding="sqlColHeader@defaultBean@servletRequest" 
                         alternateTextBinding = "NO_SQL_FOUND@AutoSqlTuneBundle"
                         blockSizeBinding="sqlBlockSize@defaultBean@servletRequest"
                         valueBinding="sqlValue@defaultBean@servletRequest" 
                         minValueBinding="sqlMinValue@defaultBean@servletRequest" 
                         maxValueBinding="sqlMaxValue@defaultBean@servletRequest"
                         formSubmitted="true"
                         summaryBinding="RECOMMENDATIONS@AutoSqlTuneBundle"> 
                   <uix:tableFormat tableBanding="rowBanding"/>
                  
                   <uix:columnHeaderStamp>
                     <uix:sortableHeader textBinding="text" sortableBinding="sortable"/>
                   </uix:columnHeaderStamp>
                   
                   <uix:contents>
                     <uix:styledText textBinding="sqlText"/> 
                     <uix:styledText textBinding="schema"/> 
                     <uix:link textBinding="sqlId" destinationBinding="sqlIdDest" />
                     <uix:styledText textBinding="benefits_cumul_sql_dbtime_saved"/> 
                     <uix:styledText textBinding="benefits_perexec_percentage"/> 
                     <uix:image sourceBinding="statsIcon"  shortDescBinding="statsDesc" />
                     <uix:dataScope>
                       <uix:styledText textBinding="benefit"/>  
                       <uix:image sourceBinding="profileIcon"  shortDescBinding="profileDesc" />
                     </uix:dataScope>
                     <uix:dataScope>
                      <uix:styledText textBinding="ibenefit"/>                      
                      <uix:image sourceBinding="indexIcon"  shortDescBinding="indexDesc" />
                     </uix:dataScope>
                     <uix:image sourceBinding="restructureIcon"  shortDescBinding="restructureDesc" />
                     <uix:image sourceBinding="altIcon"  shortDescBinding="altDesc" />
                     <uix:image sourceBinding="miscIcon"  shortDescBinding="miscDesc" />
                     <uix:image sourceBinding="timeOutIcon"  shortDescBinding="timeOutDesc" />
                     <uix:image sourceBinding="errIcon"  shortDescBinding="errDesc" />

                     <uix:styledText textBinding="startDate" renderedBinding="isAuto@defaultBean@servletRequest"/>
                     <uix:formValue id="execID" name="execID" valueBinding="execID"/> 
                   </uix:contents>
                   <uix:tableSelection>
                   <uix:singleSelection selectedIndexBinding="selectedIndex@defaultBean@servletRequest" shortDescBinding="RECOMMENDATIONS@AutoSqlTuneBundle">
                      <uix:submitButton textBinding="VIEW_RECOMMEND@AutoSqlTuneBundle" name="event" value="viewRecomm" />
                      <uix:submitButton textBinding="IMPLEMENT_ALL_PROFILES@AutoSqlTuneBundle" name="event" value="implementAllProfiles" />
                   </uix:singleSelection>
                   </uix:tableSelection>
                 </uix:table>   
		     </uix:case>
		     <uix:default>
              <uix:table width="100%"
                         name="sql"
                         tableDataBinding="sqlList@defaultBean@servletRequest"
                         columnFormatsBinding="sqlColFormats@defaultBean@pageContext"
                         columnHeaderDataBinding="sqlColHeader@defaultBean@servletRequest" 
                         alternateTextBinding = "NO_SQL_FOUND@AutoSqlTuneBundle"
                         blockSizeBinding="sqlBlockSize@defaultBean@servletRequest"
                         valueBinding="sqlValue@defaultBean@servletRequest" 
                         minValueBinding="sqlMinValue@defaultBean@servletRequest" 
                         maxValueBinding="sqlMaxValue@defaultBean@servletRequest"
                         formSubmitted="true"
                         summaryBinding="RECOMMENDATIONS@AutoSqlTuneBundle"> 
                   <uix:tableFormat tableBanding="rowBanding"/>
                  
                   <uix:columnHeaderStamp>
                     <uix:sortableHeader textBinding="text" sortableBinding="sortable"/>
                   </uix:columnHeaderStamp>
                   
                   <uix:contents>
                     <uix:styledText textBinding="sqlText"/> 
                     <uix:styledText textBinding="schema"/> 
                     <uix:link textBinding="sqlId" destinationBinding="sqlIdDest" />
                     <uix:image sourceBinding="statsIcon"  shortDescBinding="statsDesc" />
                     <uix:dataScope>
                       <uix:styledText textBinding="benefit"/>  
                       <uix:image sourceBinding="profileIcon"  shortDescBinding="profileDesc" />
                     </uix:dataScope>
                     <uix:dataScope>
                      <uix:styledText textBinding="ibenefit"/>                      
                      <uix:image sourceBinding="indexIcon"  shortDescBinding="indexDesc" />
                     </uix:dataScope>
                     <uix:image sourceBinding="restructureIcon"  shortDescBinding="restructureDesc" />
                     <uix:image sourceBinding="miscIcon"  shortDescBinding="miscDesc" />
                     <uix:image sourceBinding="errIcon"  shortDescBinding="errDesc" />

                     <uix:styledText textBinding="startDate" renderedBinding="isAuto@defaultBean@servletRequest"/>
                     <uix:formValue id="execID" name="execID" valueBinding="execID"/> 
                   </uix:contents>
                   <uix:tableSelection>
                   <uix:singleSelection selectedIndexBinding="selectedIndex@defaultBean@servletRequest" shortDescBinding="RECOMMENDATIONS@AutoSqlTuneBundle">
                      <uix:submitButton textBinding="VIEW_RECOMMEND@AutoSqlTuneBundle" name="event" value="viewRecomm" />
                      <uix:submitButton textBinding="IMPLEMENT_ALL_PROFILES@AutoSqlTuneBundle" name="event" value="implementAllProfiles" />
                   </uix:singleSelection>
                   </uix:tableSelection>
                 </uix:table>   
		     </uix:default>
		     </uix:switcher>
	    </uix:rowLayout>
	    <uix:rowLayout>
       <uix:tableLayout cellSpacing="8">        
        <uix:rowLayout hAlign="left">
          <uix:cellFormat>
              <uix:styledText textBinding="LEGEND@AutoSqlTuneBundle" styleClass="OraPromptText"/> 
          </uix:cellFormat>                
          <uix:cellFormat>          
            <uix:flowLayout>
               <uix:image sourceBinding="findImage@servletRequest" shortDescBinding="FIND@AutoSqlTuneBundle" />
                <uix:spacer height="0" width="5" />
                <uix:styledText styleClass="OraInstructionText"
                                   textBinding="RECOMMENDED@AutoSqlTuneBundle"/>
            </uix:flowLayout>                                   
          </uix:cellFormat>      

          <uix:cellFormat>          
            <uix:flowLayout>
               <uix:image sourceBinding="implImage@servletRequest" />
                <uix:spacer height="0" width="5" />
                <uix:styledText styleClass="OraInstructionText"
                                   textBinding="IMPLEMENTED@AutoSqlTuneBundle"/>
            </uix:flowLayout>                                   
          </uix:cellFormat>                         
     <%--                                  
             <uix:cellFormat>          
            <uix:flowLayout>
               <uix:image sourceBinding="downImage@servletRequest" />
                <uix:spacer height="0" width="5" />
                <uix:styledText styleClass="OraInstructionText"
                                   textBinding="VERIFIED_HARMFUL@AutoSqlTuneBundle"/>
            </uix:flowLayout>                                   
          </uix:cellFormat>                                   
          <uix:cellFormat>          
            <uix:flowLayout>
               <uix:image sourceBinding="upImage@servletRequest" />
                <uix:spacer height="0" width="5" />
                <uix:styledText styleClass="OraInstructionText"
                                   textBinding="VERIFIED_BENEFICIAL@AutoSqlTuneBundle"/>
            </uix:flowLayout>                                   
          </uix:cellFormat>  
--%>       
        </uix:rowLayout>
      </uix:tableLayout>                                  
        </uix:rowLayout>
      </uix:tableLayout>                                  
         </uix:header>

         </uix:stackLayout>
        </uix:header>    
     <uix:tableLayout>
     <uix:rowLayout renderedBinding="dbVersionGTE112@servletRequest">
     <uix:cellFormat onMouseOver="document.getElementById('testLayer1').style.visibility='visible';return false;">
     <uix:spacer width="5" height="5"/>
     </uix:cellFormat>
     </uix:rowLayout>
     </uix:tableLayout>
<%--
     <uix:rawText renderedBinding="dbVersionGTE112@servletRequest" styleClass="OraText" textBinding="detailXML@defaultBean@servletRequest"/>
--%>
      </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>

</uix:renderingContext>

