<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">  
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="AutoSqlTuneBundle" class="oracle.sysman.db.rsc.inst.AutoSqlTuneMsg"/>
  <uix:bundle name="sqlMsg"	    class="oracle.sysman.db.rsc.inst.SQLMsg"/>


  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <db:form name="summaryForm" destination="autoSqlTune"
      copyParams="target,type,taskUser,taskName">
       <uix:formValue name="task_id" valueBinding="taskId@defaultBean@servletRequest"/>
       <uix:formValue name="startDateLong" valueBinding="startDateLong@defaultBean@servletRequest"/>
       <uix:formValue name="filter" value="none"/>
      <uix:formValue name="endDateLong" valueBinding="endDateLong@defaultBean@servletRequest"/>

      <uix:pageLayout>
        <%@ include file="/database/global.jspf" %>
       <oem:messageBox messageType="info"
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
       <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <%--
        ---- Main Header
        --%>
        <uix:header textBinding="summaryPageHeader@defaultBean@servletRequest">

              <uix:labeledFieldLayout columns="2">
                <uix:styledText styleClass="OraPromptText" textBinding="RST_STATUS@sqlMsg"/>
                <uix:styledText styleClass="OraDataText" textBinding="status@taskAttributes@defaultBean@servletRequest"/>

                <uix:styledText styleClass="OraPromptText" textBinding="RST_TUNING_SET_OWNER@sqlMsg" />
                <uix:styledText styleClass="OraDataText" textBinding="owner@taskAttributes@defaultBean@servletRequest"/>

                <uix:styledText styleClass="OraPromptText" textBinding="RST_STARTED@sqlMsg"/>
                <uix:styledText styleClass="OraDataText" textBinding="started@taskAttributes@defaultBean@servletRequest"/>

                <uix:styledText styleClass="OraPromptText"
                                textBinding="RST_TUNING_SET_NAME@sqlMsg"/>
                <uix:styledText styleClass="OraDataText"
                                textBinding="name@taskAttributes@defaultBean@servletRequest"/>

                <uix:styledText styleClass="OraPromptText" textBinding="RST_COMPLETED@sqlMsg"/>
                <uix:styledText styleClass="OraDataText" textBinding="completed@taskAttributes@defaultBean@servletRequest"/>

                <uix:styledText styleClass="OraPromptText" textBinding="RST_TIME_LIMIT@sqlMsg"/>
                <uix:styledText styleClass="OraDataText" textBinding="time_limit@taskAttributes@defaultBean@servletRequest"/>

                
                <uix:styledText styleClass="OraPromptText" textBinding="RST_RUNNING_TIME@sqlMsg"/>
                <uix:styledText styleClass="OraDataText" textBinding="running_time@taskAttributes@defaultBean@servletRequest"/>
              </uix:labeledFieldLayout>
              
              <uix:spacer height="5"/>
  <uix:stackLayout>
  
      <uix:header textBinding="OVERALL_STATS@AutoSqlTuneBundle">
        <uix:tableLayout  cellSpacing="5">
          <uix:rowLayout>
            <uix:cellFormat hAlign="right">
              <uix:messagePrompt promptBinding="DISTINCT_SQL@AutoSqlTuneBundle"/>
              <uix:spacer width="5"/>
              <uix:styledText styleClass="OraDataText" 
                              textBinding="distinctSql@defaultBean@servletRequest" />
              <uix:spacer width="10"/>
		<uix:switcher childNameBinding="distinctSql@defaultBean@servletRequest">
		<uix:case name="0">
		<uix:spacer width="1" />
		</uix:case>
		<uix:default>
		<uix:submitButton textBinding="SHOW_ALL_RESULTS@AutoSqlTuneBundle" name="event" value="viewReport" />
		</uix:default>
		</uix:switcher>
            </uix:cellFormat>
          </uix:rowLayout>
        </uix:tableLayout>
     

         <uix:tableLayout>
            <uix:rowLayout>
            
             <uix:cellFormat vAlign="top" hAlign="left" width="30%">
           <uix:header textBinding="SQL_STATUS@AutoSqlTuneBundle">
            <oem:chart
                 chartType="pieChart"
                 titleVisible="false"
                 width="350"
                 height="200"
                 pieValuesInLegend="value"
                 shadowEffect="none"
                 legendPosition="south"
                 pieSlicesFromColumn="false"
                 showSlicePercentLabels="true"
                 hideZeroSlices="false"
                 noDataMessageBinding="NO_DATA@AutoSqlTuneBundle"
                 >
              <uix:contents>
                <oem:boundChartDataSource
                      chartDataSourceBinding="sqlStatusDataSource@defaultBean@servletRequest"/>
                <oem:imageMap imageMapDataSourceBinding="sqlImageMap@defaultBean@servletRequest"/>
                <oem:chartColumn
                    isKey="true"
                    displayLabelBinding="ITEM@sqlMsg"
                    sourceIndex="0"
                  />
                <oem:chartColumn
                    displayLabelBinding="SQL@sqlMsg"
                    sourceIndex="1"
                  />
              </uix:contents>
            </oem:chart>
                
                <%--
                  <uix:cellFormat hAlign="right">
                      <uix:messagePrompt promptBinding="EXECUTIONS@AutoSqlTuneBundle"/>
                  </uix:cellFormat>
                  <uix:cellFormat>  
                    <uix:spacer width="10"/>
                      <uix:styledText styleClass="OraDataText" 
                                      textBinding="executions@defaultBean@servletRequest" />
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                      <uix:messagePrompt promptBinding="SQLS@AutoSqlTuneBundle"/>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:spacer width="10"/>
                      <uix:styledText styleClass="OraDataText"
                                      textBinding="sqls@defaultBean@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                      <uix:messagePrompt promptBinding="SQL_TUNED@AutoSqlTuneBundle"/>
                  </uix:cellFormat>
                  <uix:cellFormat>
                      <uix:spacer width="10"/>
                      <uix:styledText styleClass="OraDataText"
                                      textBinding="tunedSql@defaultBean@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                      <uix:messagePrompt promptBinding="DISTINCT_SQL@AutoSqlTuneBundle"/>
                  </uix:cellFormat>
                  <uix:cellFormat>
                      <uix:spacer width="10"/>
                      <uix:styledText styleClass="OraDataText"
                                      textBinding="distinctSql@defaultBean@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                      <uix:messagePrompt promptBinding="FINDING_SQL@AutoSqlTuneBundle"/>
                  </uix:cellFormat>
                  <uix:cellFormat>
                      <uix:spacer width="10"/>
                      <uix:styledText styleClass="OraDataText"
                                      textBinding="findingSql@defaultBean@servletRequest" />
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                      <uix:messagePrompt promptBinding="ERROR_SQL@AutoSqlTuneBundle"/>
                  </uix:cellFormat>
                  <uix:cellFormat>         
                      <uix:spacer width="10"/>
                      <uix:styledText styleClass="OraDataText" 
                                      textBinding="errorSql@defaultBean@servletRequest" />
                  </uix:cellFormat>                          
                  --%>
             </uix:header>     
             </uix:cellFormat>
             
           <uix:cellFormat vAlign="top" hAlign="left" width="70%">
            <uix:header textBinding="FINDING@AutoSqlTuneBundle">            
              <oem:chart               
                chartType="barChart"
                orientation="vertical"
                width="650"
                height="200"             
                stacked="true"
                shadowEffect="3d"
                barWidthFraction="0.5"                
                yAxisLabelBinding="NUM_SQL@AutoSqlTuneBundle"
                yAxisVisible="true"                
                legendPosition="east"  
                barLabelling="out">
              <uix:contents>
                <oem:imageMap imageMapDataSourceBinding="findingImageMap@defaultBean@servletRequest" />
                <oem:boundChartDataSource
                      chartDataSourceBinding="findingDataSource@defaultBean@servletRequest"/>
                <oem:chartColumn
                    isKey="true"
                    displayLabelBinding="SQL_RESPONSE_TIME@sqlMsg"
                    sourceIndex="0" />
                <oem:chartColumn
                    displayLabelBinding="NOT_IMPLEMENTED@AutoSqlTuneBundle"
                    itemColor="#0099CC"
                    sourceIndex="1" />
                <oem:chartColumn
                    displayLabelBinding="IMPLEMENTED@AutoSqlTuneBundle"
                    itemColor="#00CC99"
                    sourceIndex="2" />                                                 
              </uix:contents>
            </oem:chart>
            </uix:header>            
            </uix:cellFormat>
   
   <%--         
           <uix:cellFormat vAlign="top" hAlign="left" width="35%">
 
            </uix:cellFormat>
--%>            
           </uix:rowLayout>
        </uix:tableLayout>   
          <uix:spacer height="10"/>
</uix:header>

             <uix:header textBinding="PROFILE_STATS@AutoSqlTuneBundle">             
        <uix:tableLayout>  
           <uix:rowLayout>
              <uix:cellFormat hAlign="left" >
                 <uix:header textBinding="DB_BENEFIT_WEEK@AutoSqlTuneBundle">                
                 
        <uix:tableLayout  cellSpacing="10">  
          <uix:rowLayout>
<%--	  
            <uix:cellFormat hAlign="right">
              <uix:messagePrompt promptBinding="IMPLEMENTED_SEC@AutoSqlTuneBundle"/>
              <uix:spacer width="5"/>
              <uix:styledText styleClass="OraDataText" 
                              textBinding="implemented@defaultBean@servletRequest" />
            </uix:cellFormat> 
--%>	    
            <uix:cellFormat hAlign="right">
              <uix:messagePrompt promptBinding="POTENTIAL_SEC@AutoSqlTuneBundle"/>              
              <uix:spacer width="5"/>
              <uix:styledText styleClass="OraDataText" 
                              textBinding="potential@defaultBean@servletRequest" />
            </uix:cellFormat> 
          </uix:rowLayout>  
        </uix:tableLayout>
        
            <oem:chart               
                chartType="barChart"
		legendVisible="true"
		 barLabelling="none"
                orientation="vertical"
                width="220"
                height="200"                          
                shadowEffect="3d"
                stacked="false"
                yAxisLabelBinding="DB_TIME@AutoSqlTuneBundle"
                yAxisVisible="true"                
                showXAxisLabels="true"                
               >
              <uix:contents>
                <oem:imageMap imageMapDataSourceBinding="dbTimeImageMap@defaultBean@servletRequest" />
                <oem:boundChartDataSource
                      chartDataSourceBinding="dbTimeDataSource@defaultBean@servletRequest"/>
                <oem:chartColumn
                    isKey="true"
                    displayLabelBinding="DB_TIME@sqlMsg"
                    sourceIndex="0" />
                <oem:chartColumn
                    displayLabelBinding="BEFORE@AutoSqlTuneBundle"
                    itemColor="#336699"
                    sourceIndex="1" />
                <oem:chartColumn
                    displayLabelBinding="AFTER@AutoSqlTuneBundle"
                    itemColor="#99CCFF"
                    sourceIndex="2" />                                                 
              </uix:contents>
            </oem:chart>            
            
                 </uix:header>            
             </uix:cellFormat>
            
           </uix:rowLayout>
        </uix:tableLayout>            
     </uix:header> 
                        
     <uix:header textBinding="STAT_FIND_SUMM_HEADER@AutoSqlTuneBundle"> 
        <uix:table width="80%"
               name="statFindingSummary"
                         tableDataBinding="statFindingSummary@defaultBean@servletRequest"
                         alternateTextBinding = "NO_STAT_FINDING_SUMMARY@AutoSqlTuneBundle"
                         formSubmitted="true"> 
                   <uix:tableFormat tableBanding="rowBanding"/>
                     <uix:column>
                        <uix:columnHeader>
                            <uix:styledText textBinding="OBJ_NAME@AutoSqlTuneBundle"/> 
                        </uix:columnHeader>
                        <uix:contents>
                            <uix:link textBinding="object_name" destinationBinding="destURL"/>
                        </uix:contents>
                      </uix:column>
                  
                      <uix:column>
                        <uix:columnHeader>
                            <uix:styledText textBinding="OBJ_TYPE@AutoSqlTuneBundle"/> 
                        </uix:columnHeader>
                        <uix:contents>
                            <uix:styledText styleClass="OraText" textBinding="object_type"/>
                        </uix:contents>
                      </uix:column>
                  
                      <uix:column>
                        <uix:columnHeader>
                            <uix:styledText textBinding="SCHEMA@AutoSqlTuneBundle"/> 
                        </uix:columnHeader>
                        <uix:contents>
                            <uix:styledText styleClass="OraText" textBinding="schema"/>
                        </uix:contents>
                      </uix:column>
                  
                      <uix:column>
                        <uix:columnHeader>
                            <uix:styledText textBinding="PROBLEM@AutoSqlTuneBundle"/> 
                        </uix:columnHeader>
                        <uix:contents>
                            <uix:styledText styleClass="OraText" textBinding="problem"/>
                        </uix:contents>
                      </uix:column>
                  
                      <uix:column>
                        <uix:columnFormat columnDataFormat="numberFormat" /> 
                        <uix:columnHeader>
                            <uix:styledText textBinding="REFERENCES@AutoSqlTuneBundle"/> 
                        </uix:columnHeader>
                        <uix:contents>
                            <uix:styledText styleClass="OraText" textBinding="count"/>
                        </uix:contents>
                      </uix:column>
                  
                 </uix:table>   
     </uix:header> 
     <uix:header textBinding="IDX_FIND_SUMM_HEADER@AutoSqlTuneBundle"> 
        <uix:table width="80%"
               name="IndexFindingSummary"
                         tableDataBinding="indexFindingSummary@defaultBean@servletRequest"
                         alternateTextBinding = "NO_INDEX_FINDING_SUMMARY@AutoSqlTuneBundle"
                         formSubmitted="true"> 
                   <uix:tableFormat tableBanding="rowBanding"/>
                    <uix:column>
                        <uix:columnHeader>
                            <uix:styledText textBinding="TAB_NAME@AutoSqlTuneBundle"/> 
                        </uix:columnHeader>
                        <uix:contents>
                            <uix:link textBinding="table_name" destinationBinding="destURL"/>
                        </uix:contents>
                    </uix:column>
                  
                    <uix:column>
                        <uix:columnHeader>
                            <uix:styledText textBinding="SCHEMA@AutoSqlTuneBundle"/> 
                        </uix:columnHeader>
                        <uix:contents>
                            <uix:styledText styleClass="OraText" textBinding="schema"/>
                        </uix:contents>
                    </uix:column>
                  
                    <uix:column>
                        <uix:columnFormat columnDataFormat="numberFormat" /> 
                        <uix:columnHeader>
                            <uix:styledText textBinding="REFERENCES@AutoSqlTuneBundle"/> 
                        </uix:columnHeader>
                        <uix:contents>
                            <uix:styledText styleClass="OraText" textBinding="count"/>
                        </uix:contents>
                    </uix:column>
                  
                    <uix:column>
                        <uix:columnHeader>
                            <uix:styledText textBinding="IDX_COL@AutoSqlTuneBundle"/> 
                        </uix:columnHeader>
                        <uix:contents>
                            <uix:styledText styleClass="OraText" textBinding="columns"/>
                        </uix:contents>
                    </uix:column>
                  
                 </uix:table>   
     </uix:header> 
     <uix:tableLayout>
     <uix:rowLayout renderedBinding="dbVersionGTE112@servletRequest">
     <uix:cellFormat onMouseOver="document.getElementById('testLayer1').style.visibility='visible';return false;">
     <uix:spacer width="5" height="5"/>
     </uix:cellFormat>
     </uix:rowLayout>
     </uix:tableLayout>
<%--
     <uix:rawText renderedBinding="dbVersionGTE112@servletRequest" styleClass="OraText" textBinding="summaryXML@defaultBean@servletRequest"/>
--%>
         </uix:stackLayout>
      
         
        </uix:header>    
      </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>

</uix:renderingContext>

