<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ include file="/oemNoscript.jspf" %>


<uix:renderingContext id="renderingContext">  
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="AutoSqlTuneBundle" class="oracle.sysman.db.rsc.inst.AutoSqlTuneMsg"/>
  <uix:bundle name="sqlMsg" class="oracle.sysman.db.rsc.inst.SQLMsg"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <db:form name="summaryForm" destination="autoSqlTune"
      copyParams="target,type,task_id">    
       <uix:formValue name="startDateLong" valueBinding="startDateLong@defaultBean@servletRequest"/>
       <uix:formValue name="finding_filter" value="none"/>
       <uix:formValue name="taskName" valueBinding="taskName@defaultBean@servletRequest"/>
       <uix:formValue name="taskUser" valueBinding="taskOwner@defaultBean@servletRequest"/>
       <uix:formValue name="task_id" valueBinding="taskId@defaultBean@servletRequest"/>
      <uix:formValue name="endDateLong" valueBinding="endDateLong@defaultBean@servletRequest"/>   

      <uix:pageLayout> 
        <%@ include file="/database/global.jspf" %> 
       <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>        
       <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/> 
        <%-- 
        ---- Main Header
        --%>
        <uix:header textBinding="summaryPageHeader@defaultBean@servletRequest">
         <uix:styledText styleClass="OraInstructionText" 
                         textBinding="RESULT_DESC@AutoSqlTuneBundle" />
         <uix:header textBinding="TASK_STATUS@AutoSqlTuneBundle">
              <uix:tableLayout>
                <uix:rowLayout>
                  <uix:spacer width="10"/>   
                  <uix:flowLayout>
                  <uix:styledText styleClass="OraInstructionText" 
                         textBinding="AUTOSQLTUNE_STATUS@AutoSqlTuneBundle" />
                  <uix:spacer width="5"/>                         
                  <uix:styledText styleClass="OraDataText" 
                         textBinding="status@defaultBean@servletRequest" />
                  <uix:spacer width="10"/>                                      
                  <uix:submitButton textBinding="CONFIGURE@AutoSqlTuneBundle" name="event" value="doConfig" />                                     
                  </uix:flowLayout>                         
                </uix:rowLayout>              
                <uix:rowLayout>
                  <uix:spacer width="10"/>      
                  <uix:flowLayout>
                  <uix:styledText styleClass="OraInstructionText" 
                         textBinding="AUTO_PROFILES_STATUS@AutoSqlTuneBundle" />
                  <uix:spacer width="5"/>                         
                  <uix:styledText styleClass="OraDataText" 
                         textBinding="profileStatus@defaultBean@servletRequest" />
                  <uix:spacer width="10"/>                                      
                  <uix:spacer height="0" width="3" />
                  <uix:button textBinding="CONFIGURE@AutoSqlTuneBundle"
                             destinationBinding="autoSqlTuneConfigLink@servletRequest"/>

                  </uix:flowLayout>                         
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:spacer width="10"/>
                  <uix:flowLayout>
                  <uix:styledText styleClass="OraInstructionText"
                         textBinding="KEY_SQL_PROFILES@AutoSqlTuneBundle"
                         shortDescBinding="KEY_SQL_PROFILES_TOOLTIP@AutoSqlTuneBundle"/>
                  <uix:spacer width="5"/>
                  <uix:switcher childNameBinding="hasRecommProfile@defaultBean@servletRequest">
                   <uix:case name="true">
                             <uix:link 
                                 textBinding="recommProfilesNumber@defaultBean@servletRequest"
                                 destinationBinding="autoSqlTuneFilterLink@servletRequest"/> 
                    </uix:case>
                    <uix:case name="false">
                       <uix:styledText styleClass="OraDataText"
                         textBinding="recommProfilesNumber@defaultBean@servletRequest"/> 
                   </uix:case>
                   </uix:switcher>
                  <uix:spacer width="10"/>
                  <uix:submitButton textBinding="IMPLEMENT_ALL@AutoSqlTuneBundle" name="event" value="implementAllRecomms" renderedBinding="hasRecommProfile@defaultBean@servletRequest"/>
                  </uix:flowLayout>
                </uix:rowLayout>
              </uix:tableLayout>
                 
         </uix:header> 
  <uix:stackLayout>
        <uix:header textBinding="TASK_ACT_SUMMARY@AutoSqlTuneBundle">
      
          <uix:styledText styleClass="OraInstructionText" 
                         textBinding="TASK_ACT_DESC@AutoSqlTuneBundle" />
          <uix:spacer width="10"/>  
          
            <uix:tableLayout>
              <uix:rowLayout>  
              <uix:messageChoice promptBinding="TIME_PERIOD@AutoSqlTuneBundle"                   
                       styleClass="OraPromptText"
                       name="timePeriod" 
                       id="timePeriod" 
                       onChange="submitForm('summaryForm', true, {event:'changeTime'})"
                       shortDescBinding="TIME_PERIOD@AutoSqlTuneBundle"
                       selectedValueBinding="timePeriod@defaultBean@servletRequest">
                <uix:contents>
                  <uix:option textBinding="LAST_24HR@AutoSqlTuneBundle" value="1"/>
                  <uix:option textBinding="LAST_7DAY@AutoSqlTuneBundle" value="7"/>
                  <uix:option textBinding="LAST_31DAY@AutoSqlTuneBundle" value="31"/>
                  <uix:option textBinding="SINCE_LAST@AutoSqlTuneBundle" value="last"/>
                  <uix:option textBinding="ALL@AutoSqlTuneBundle" value="all"/>
                  <uix:option textBinding="CUSTOMIZE@AutoSqlTuneBundle" value="cust"/>
                </uix:contents> 
              </uix:messageChoice>    
              <uix:spacer width="5"/>    
              <uix:submitButton textBinding="GO@AutoSqlTuneBundle" name="event" value="go" />
              <uix:spacer width="5"/>    
              <uix:submitButton 
	      		textBinding="VIEW_REPORT@AutoSqlTuneBundle" 
			name="event" 
			renderedBinding="hasResult@@defaultBean@servletRequest"
			value="viewReport" />
            </uix:rowLayout>  
          </uix:tableLayout>
<%--
          <uix:tableLayout> 
           <uix:rowLayout>
--%>           
          <uix:rowLayout>
            <uix:tableLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" >
                  <uix:messagePrompt promptBinding="BEGIN_DATE@AutoSqlTuneBundle"/>
                </uix:cellFormat>
                  <uix:spacer width="10"/>  
                  <uix:styledText styleClass="OraDataText" 
                                  textBinding="startStr@defaultBean@servletRequest" />                                                                      
              </uix:rowLayout>
            </uix:tableLayout>
            <uix:spacer width="30"/>                          
            <uix:tableLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" >
                  <uix:messagePrompt promptBinding="END_DATE@AutoSqlTuneBundle"/>
                </uix:cellFormat>
                  <uix:spacer width="10"/>
                  <uix:styledText styleClass="OraDataText" 
                                  textBinding="endStr@defaultBean@servletRequest" />
              </uix:rowLayout>
            </uix:tableLayout>
          </uix:rowLayout>            
<%--            
           </uix:rowLayout>
          </uix:tableLayout>  
--%>
      </uix:header> 
      <uix:header textBinding="OVERALL_STATS@AutoSqlTuneBundle"> 
        <uix:tableLayout  cellSpacing="5">  
          <uix:rowLayout>
            <uix:cellFormat hAlign="right">
              <uix:messagePrompt promptBinding="EXECUTIONS@AutoSqlTuneBundle"/>
              <uix:spacer width="5"/>
              <uix:styledText styleClass="OraDataText" 
                              textBinding="executions@defaultBean@servletRequest" />
              <uix:spacer width="10"/>
            </uix:cellFormat> 
            <uix:cellFormat hAlign="right">
              <uix:messagePrompt promptBinding="SQLS@AutoSqlTuneBundle"/>              
              <uix:spacer width="5"/>
              <uix:styledText styleClass="OraDataText" 
                              textBinding="sqls@defaultBean@servletRequest" />
            <uix:spacer width="10"/>
            </uix:cellFormat> 
            <uix:cellFormat hAlign="right">
              <uix:messagePrompt promptBinding="DISTINCT_SQL@AutoSqlTuneBundle"/>
              <uix:spacer width="5"/>
              <uix:styledText styleClass="OraDataText" 
                              textBinding="distinctSql@defaultBean@servletRequest" />            
            </uix:cellFormat>                 
          </uix:rowLayout> 
        </uix:tableLayout>
     

         <uix:tableLayout>  
            <uix:rowLayout>
            
             <uix:cellFormat vAlign="top" hAlign="left" width="30%">
           <uix:header textBinding="SQL_STATUS@AutoSqlTuneBundle">   
            <oem:chart
                 chartType="pieChart"
                 titleVisible="false"
                 width="300"
                 height="200"
                 pieValuesInLegend="value"                
                 shadowEffect="none"
                 legendPosition="south"
                 pieSlicesFromColumn="false"
                 showSlicePercentLabels="true"                 
                 hideZeroSlices="false"
                 noDataMessageBinding="NO_DATA@AutoSqlTuneBundle"
                 >
              <uix:contents>
                <oem:boundChartDataSource
                      chartDataSourceBinding="sqlStatusDataSource@defaultBean@servletRequest"/>              
                <oem:imageMap imageMapDataSourceBinding="sqlImageMap@defaultBean@servletRequest"/>
                <oem:chartColumn
                    isKey="true"
                    displayLabelBinding="ITEM@sqlMsg"
                    sourceIndex="0"
                  />
                <oem:chartColumn
                    displayLabelBinding="SQL@sqlMsg"
                    sourceIndex="1"                    
                  />
              </uix:contents>
            </oem:chart>
                
                <%--
                  <uix:cellFormat hAlign="right">
                      <uix:messagePrompt promptBinding="EXECUTIONS@AutoSqlTuneBundle"/>
                  </uix:cellFormat>      
                  <uix:cellFormat>  
                    <uix:spacer width="10"/>
                      <uix:styledText styleClass="OraDataText" 
                                      textBinding="executions@defaultBean@servletRequest" />
                  </uix:cellFormat>                          
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                      <uix:messagePrompt promptBinding="SQLS@AutoSqlTuneBundle"/>
                  </uix:cellFormat>      
                  <uix:cellFormat>         
                    <uix:spacer width="10"/>
                      <uix:styledText styleClass="OraDataText" 
                                      textBinding="sqls@defaultBean@servletRequest" />
                  </uix:cellFormat>                          
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                      <uix:messagePrompt promptBinding="SQL_TUNED@AutoSqlTuneBundle"/>
                  </uix:cellFormat>      
                  <uix:cellFormat>         
                      <uix:spacer width="10"/>
                      <uix:styledText styleClass="OraDataText" 
                                      textBinding="tunedSql@defaultBean@servletRequest" />
                  </uix:cellFormat>                          
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                      <uix:messagePrompt promptBinding="DISTINCT_SQL@AutoSqlTuneBundle"/>
                  </uix:cellFormat>      
                  <uix:cellFormat>         
                      <uix:spacer width="10"/>
                      <uix:styledText styleClass="OraDataText" 
                                      textBinding="distinctSql@defaultBean@servletRequest" />
                  </uix:cellFormat>                          
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                      <uix:messagePrompt promptBinding="FINDING_SQL@AutoSqlTuneBundle"/>
                  </uix:cellFormat>      
                  <uix:cellFormat>         
                      <uix:spacer width="10"/>
                      <uix:styledText styleClass="OraDataText" 
                                      textBinding="findingSql@defaultBean@servletRequest" />
                  </uix:cellFormat>                          
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                      <uix:messagePrompt promptBinding="ERROR_SQL@AutoSqlTuneBundle"/>
                  </uix:cellFormat>      
                  <uix:cellFormat>         
                      <uix:spacer width="10"/>
                      <uix:styledText styleClass="OraDataText" 
                                      textBinding="errorSql@defaultBean@servletRequest" />
                  </uix:cellFormat>                          
                  --%>
             </uix:header>     
             </uix:cellFormat>
             
           <uix:cellFormat vAlign="top" hAlign="left" width="70%">
            <uix:header textBinding="FINDING@AutoSqlTuneBundle">            
              <oem:chart               
                chartType="barChart"
                orientation="vertical"
                width="650"
                height="200"             
                stacked="true"
                shadowEffect="3d"
                barWidthFraction="0.5"                
                yAxisLabelBinding="NUM_SQL@AutoSqlTuneBundle"
                yAxisVisible="true"                
                legendPosition="east"  
                barLabelling="out">
              <uix:contents>
                <oem:imageMap imageMapDataSourceBinding="findingImageMap@defaultBean@servletRequest" />
                <oem:boundChartDataSource
                      chartDataSourceBinding="findingDataSource@defaultBean@servletRequest"/>
                <oem:chartColumn
                    isKey="true"
                    displayLabelBinding="SQL_RESPONSE_TIME@sqlMsg"
                    sourceIndex="0" />
                <oem:chartColumn
                    displayLabelBinding="NOT_IMPLEMENTED1@AutoSqlTuneBundle"
                    itemColor="#0099CC"
                    sourceIndex="1" />
                <oem:chartColumn
                    displayLabelBinding="IMPLEMENTED@AutoSqlTuneBundle"
                    itemColor="#00CC99"
                    sourceIndex="2" />                                                 
              </uix:contents>
            </oem:chart>
            </uix:header>            
            </uix:cellFormat>
   
   <%--         
           <uix:cellFormat vAlign="top" hAlign="left" width="35%">
 
            </uix:cellFormat>
--%>            
           </uix:rowLayout>
        </uix:tableLayout>   
          <uix:spacer height="10"/>
</uix:header>

             <uix:header textBinding="PROFILE_STATS@AutoSqlTuneBundle">             
        <uix:tableLayout>  
           <uix:rowLayout>
              <uix:cellFormat hAlign="left" >
                 <uix:header textBinding="DB_BENEFIT_WEEK@AutoSqlTuneBundle">                
                 
        <uix:tableLayout  cellSpacing="10">  
          <uix:rowLayout>
            <uix:cellFormat hAlign="right">
              <uix:messagePrompt promptBinding="IMPLEMENTED_SEC@AutoSqlTuneBundle"/>
              <uix:spacer width="5"/>
              <uix:styledText styleClass="OraDataText" 
                              textBinding="implemented@defaultBean@servletRequest" />
            </uix:cellFormat> 
            <uix:cellFormat hAlign="right">
              <uix:messagePrompt promptBinding="POTENTIAL_SEC@AutoSqlTuneBundle"/>              
              <uix:spacer width="5"/>
              <uix:styledText styleClass="OraDataText" 
                              textBinding="potential@defaultBean@servletRequest" />
            </uix:cellFormat> 
          </uix:rowLayout>  
        </uix:tableLayout>
        
            <oem:chart               
                chartType="barChart"
                orientation="vertical"
                width="320"
                height="200"                          
                shadowEffect="3d"
                stacked="false"
                yAxisLabelBinding="DB_TIME@AutoSqlTuneBundle"
                yAxisVisible="true"                
               >
              <uix:contents>
                <oem:imageMap imageMapDataSourceBinding="dbTimeImageMap@defaultBean@servletRequest" />
                <oem:boundChartDataSource
                      chartDataSourceBinding="dbTimeDataSource@defaultBean@servletRequest"/>
                <oem:chartColumn
                    isKey="true"
                    displayLabelBinding="DB_TIME@sqlMsg"
                    sourceIndex="0" />
                <oem:chartColumn
                    displayLabelBinding="BEFORE@AutoSqlTuneBundle"
                    itemColor="#336699"
                    sourceIndex="1" />
                <oem:chartColumn
                    displayLabelBinding="AFTER@AutoSqlTuneBundle"
                    itemColor="#99CCFF"
                    sourceIndex="2" />                                                 
              </uix:contents>
            </oem:chart>            
            
                 </uix:header>            
             </uix:cellFormat>
            
           </uix:rowLayout>
        </uix:tableLayout>            
     </uix:header> 
                        
     <uix:header textBinding="STAT_FIND_SUMM_HEADER@AutoSqlTuneBundle"
     renderedBinding="dbVersionGTE112@servletRequest"> 
        <uix:table width="80%"
               name="statFindingSummary"
                         tableDataBinding="statFindingSummary@defaultBean@servletRequest"
                         alternateTextBinding = "NO_STAT_FINDING_SUMMARY@AutoSqlTuneBundle"
                         formSubmitted="true"> 
                   <uix:tableFormat tableBanding="rowBanding"/>
				   <uix:column>
					  <uix:columnHeader>
                        <uix:styledText textBinding="OBJ_NAME@AutoSqlTuneBundle"/> 
					  </uix:columnHeader>
					  <uix:contents>
						<uix:link textBinding="object_name" destinationBinding="destURL"/>
					  </uix:contents>
				   </uix:column>
                  
				   <uix:column>
					  <uix:columnHeader>
                        <uix:styledText textBinding="OBJ_TYPE@AutoSqlTuneBundle"/> 
					  </uix:columnHeader>
					  <uix:contents>
						<uix:styledText styleClass="OraText" textBinding="object_type"/>
					  </uix:contents>
				   </uix:column>
                  
				   <uix:column>
					  <uix:columnHeader>
                        <uix:styledText textBinding="SCHEMA@AutoSqlTuneBundle"/> 
					  </uix:columnHeader>
					  <uix:contents>
						<uix:styledText styleClass="OraText" textBinding="schema"/>
					  </uix:contents>
				   </uix:column>
                  
				   <uix:column>
					  <uix:columnHeader>
                        <uix:styledText textBinding="PROBLEM@AutoSqlTuneBundle"/> 
					  </uix:columnHeader>
					  <uix:contents>
						<uix:styledText styleClass="OraText" textBinding="problem"/>
					  </uix:contents>
				   </uix:column>
                  
				   <uix:column>
                         <uix:columnFormat columnDataFormat="numberFormat" /> 
					  <uix:columnHeader>
                        <uix:styledText textBinding="REFERENCES@AutoSqlTuneBundle"/> 
					  </uix:columnHeader>
					  <uix:contents>
						<uix:styledText styleClass="OraText" textBinding="count"/>
					  </uix:contents>
				   </uix:column>
                  
                 </uix:table>   
     </uix:header> 
     <uix:header textBinding="IDX_FIND_SUMM_HEADER@AutoSqlTuneBundle"
     	renderedBinding="dbVersionGTE112@servletRequest"> 
        <uix:table width="80%"
               name="IndexFindingSummary"
                         tableDataBinding="indexFindingSummary@defaultBean@servletRequest"
                         alternateTextBinding = "NO_INDEX_FINDING_SUMMARY@AutoSqlTuneBundle"
                         formSubmitted="true"> 
                   <uix:tableFormat tableBanding="rowBanding"/>
				   <uix:column>
					  <uix:columnHeader>
                        <uix:styledText textBinding="TAB_NAME@AutoSqlTuneBundle"/> 
					  </uix:columnHeader>
					  <uix:contents>
					  <uix:link textBinding="table_name" destinationBinding="destURL"/>
					  </uix:contents>
				   </uix:column>
                  
				   <uix:column>
					  <uix:columnHeader>
                        <uix:styledText textBinding="SCHEMA@AutoSqlTuneBundle"/>
					  </uix:columnHeader>
					  <uix:contents>
						<uix:styledText styleClass="OraText" textBinding="schema"/>
					  </uix:contents>
				   </uix:column>
                  
				   <uix:column>
                         <uix:columnFormat columnDataFormat="numberFormat" /> 
					  <uix:columnHeader>
                        <uix:styledText textBinding="REFERENCES@AutoSqlTuneBundle"/> 
					  </uix:columnHeader>
					  <uix:contents>
						<uix:styledText styleClass="OraText" textBinding="count"/>
					  </uix:contents>
				   </uix:column>
                  
				   <uix:column>
					  <uix:columnHeader>
                        <uix:styledText textBinding="IDX_COL@AutoSqlTuneBundle"/> 
					  </uix:columnHeader>
					  <uix:contents>
						<uix:styledText styleClass="OraText" textBinding="columns"/>
					  </uix:contents>
				   </uix:column>
                  
                 </uix:table>   
     </uix:header> 
     <uix:tableLayout>
     <uix:rowLayout renderedBinding="dbVersionGTE112@servletRequest">
     <uix:cellFormat onMouseOver="document.getElementById('testLayer1').style.visibility='visible';return false;">
     <uix:spacer width="5" height="5"/>
     </uix:cellFormat>
     </uix:rowLayout>
     </uix:tableLayout>
<%--          
     <uix:rawText renderedBinding="dbVersionGTE112@servletRequest" styleClass="OraText" textBinding="summaryXML@defaultBean@servletRequest"/>
--%>     
<%--          
        <uix:header textBinding="PROFILE_STATS@AutoSqlTuneBundle">             
          <uix:tableLayout>  
            <uix:rowLayout>
            <uix:cellFormat hAlign="left" >
            <uix:header textBinding="RESP_HEADER@AutoSqlTuneBundle">            
              <oem:chart               
                chartType="barChart"
                orientation="vertical"
                width="250"
                height="200"             
                shadowEffect="3d"
                barWidthFraction="0.2"
                legendVisible="false"
                yAxisLabelBinding="NUM_SQL@AutoSqlTuneBundle"
                yAxisVisible="true"
                xAxisLabelBinding="RESP_TIME@AutoSqlTuneBundle"
                barLabelling="false">
              <uix:contents>
                <oem:boundChartDataSource
                      chartDataSourceBinding="sqlDataSource@defaultBean@servletRequest"/>
                <oem:chartColumn
                    isKey="true"
                    displayLabel="ResponseTime"
                    sourceIndex="0" />
                <oem:chartColumn
                    displayLabel="SQL"
                    itemColor="#00CC99"
                    sourceIndex="1" />
              </uix:contents>
            </oem:chart>
            </uix:header>            
            </uix:cellFormat>

            <uix:cellFormat hAlign="left" >
            <uix:header textBinding="IMPROVE_HEADER@AutoSqlTuneBundle">            
              <oem:chart               
                chartType="barChart"
                orientation="vertical"
                width="250"
                height="200"             
                shadowEffect="3d"
                legendVisible="false"
                yAxisLabelBinding="PERCENT@AutoSqlTuneBundle"
                yAxisVisible="true"  
                barWidthFraction="0.2"
                xAxisLabelBinding="RESP_TIME@AutoSqlTuneBundle"
                barLabelling="false">
              <uix:contents>
                <oem:boundChartDataSource
                      chartDataSourceBinding="improveDataSource@defaultBean@servletRequest"/>
                <oem:chartColumn
                    isKey="true"
                    displayLabel="ResponseTime"
                    sourceIndex="0" />
                <oem:chartColumn
                    displayLabel="%"
                    itemColor="#00CC99"
                    sourceIndex="1" />
              </uix:contents>
            </oem:chart>
            </uix:header>            
            </uix:cellFormat>
            
           </uix:rowLayout>
          </uix:tableLayout>            
</uix:header>          
--%>
         </uix:stackLayout>
      
         
        </uix:header>    
      </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>

</uix:renderingContext>

