<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">  
  <oem:setURLEncoder id="renderingContext"/>
  
  <uix:bundle name="SDKUIResourceBundle" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="AutoTaskBundle" class="oracle.sysman.db.rsc.inst.AutoTaskMsg"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <db:form name="autotaskForm" method="POST" destination="autoTask" copyParams="target,type,pageName">    
      <uix:pageLayout> 
        <%@ include file="/database/global.jspf" %> 
       <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>        
       <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/> 
        <%-- 
        ---- Main Header
        --%>
        <uix:header textBinding="AUTOTASK@AutoTaskBundle">   
          <uix:tableLayout width="100%">
           <uix:rowLayout>
            <uix:cellFormat>
            <uix:flowLayout>          
                 <uix:messagePrompt promptBinding="AUTOTASK_STATUS@AutoTaskBundle"/> 
                  <uix:spacer width="10"/>   
                  <uix:styledText styleClass="OraDataText" 
                         textBinding="status@defaultBean@servletRequest" />
                  <uix:spacer width="10"/>                                      
                  <uix:submitButton textBinding="CONFIGURE@AutoTaskBundle" name="event" value="doConfig" />                                     
            </uix:flowLayout>
            </uix:cellFormat>  
            <uix:cellFormat hAlign="right">
                 <uix:styledText styleClass="OraTipText" textBinding="COLLECTED_TARGET@AutoTaskBundle"/>
                 <uix:spacer width="5" />  
                <uix:styledText styleClass="OraTipLabel" textBinding="refreshTime@servletRequest"/>
            </uix:cellFormat>
            </uix:rowLayout>              
          </uix:tableLayout>         
        <uix:tip textBinding="DISABLED_TIP@AutoTaskBundle"/>
        <uix:tableLayout hAlign="right">
        <uix:rowLayout>    
    
        <uix:tableLayout cellSpacing="2">
          <uix:rowLayout vAlign="top"  hAlign="right">
            <uix:cellFormat  hAlign="right">
              <uix:messageDateField id="startDate" 
                            shortDescBinding="BEGIN_DATE@AutoTaskBundle"
                            name="startDate"
                            valueBinding="startDate@defaultBean@servletRequest"
                            promptBinding="BEGIN_DATE@AutoTaskBundle"
                            tipBinding="dateTip@defaultBean@servletRequest"
                            columns="10"
                            required="yes">
        <uix:onSubmitValidater>
          <uix:date dateStyle="medium" />
        </uix:onSubmitValidater>
      </uix:messageDateField>
    </uix:cellFormat>
<%--    
    <uix:spacer width="10" />
    <uix:messageChoice promptBinding="TIME@SDKUIResourceBundle"                   
                       styleClass="OraPromptText"
                       name="startHour" 
                       id="startHour" 
                       shortDescBinding="HOURS@SDKUIResourceBundle"
                       selectedValueBinding="startHour@defaultBean@servletRequest">
                  <uix:contents>
                     <uix:option text="" value=""/>
                     <uix:option text="1" value="1"/>
                     <uix:option text="2" value="2"/>
                     <uix:option text="3" value="3"/>
                     <uix:option text="4" value="4"/>
                     <uix:option text="5" value="5"/>
                     <uix:option text="6" value="6"/>
                     <uix:option text="7" value="7"/>
                     <uix:option text="8" value="8"/>
                     <uix:option text="9" value="9"/>
                     <uix:option text="10" value="10"/>
                     <uix:option text="11" value="11"/>
                     <uix:option text="12" value="12"/>
                  </uix:contents>
    </uix:messageChoice>          
    <uix:styledText text=":" styleClass="OraPromptText"/>
    <uix:choice name="startMin" id="startMin" 
                  shortDescBinding="MINUTES@SDKUIResourceBundle"
                  selectedValueBinding="startMin@@defaultBean@servletRequest">
        <uix:contents>
          <uix:option text="" value=""/>
          <uix:option text="00" value="00"/>
          <uix:option text="01" value="01"/>
          <uix:option text="02" value="02"/>           
          <uix:option text="03" value="03"/>
          <uix:option text="04" value="04"/>                     
          <uix:option text="05" value="05"/>                
          <uix:option text="06" value="06"/>
          <uix:option text="07" value="07"/>           
          <uix:option text="08" value="08"/>
          <uix:option text="09" value="09"/>                               
          <uix:option text="10" value="10"/>                 
          <uix:option text="11" value="11"/>
          <uix:option text="12" value="12"/>           
          <uix:option text="13" value="13"/>
          <uix:option text="14" value="14"/>                               
          <uix:option text="15" value="15"/>
          <uix:option text="16" value="16"/>
          <uix:option text="17" value="17"/>           
          <uix:option text="18" value="18"/>
          <uix:option text="19" value="19"/>                                         
          <uix:option text="20" value="20"/>
          <uix:option text="21" value="21"/>
          <uix:option text="22" value="22"/>           
          <uix:option text="23" value="23"/>
          <uix:option text="24" value="24"/>                                         
          <uix:option text="25" value="25"/>
          <uix:option text="26" value="26"/>
          <uix:option text="27" value="27"/>           
          <uix:option text="28" value="28"/>
          <uix:option text="29" value="29"/>                                                   
          <uix:option text="30" value="30"/>
          <uix:option text="31" value="31"/>
          <uix:option text="32" value="32"/>           
          <uix:option text="33" value="33"/>
          <uix:option text="34" value="34"/>                                                   
          <uix:option text="35" value="35"/>
          <uix:option text="36" value="36"/>
          <uix:option text="37" value="37"/>           
          <uix:option text="38" value="38"/>
          <uix:option text="39" value="39"/>                                                   
          <uix:option text="40" value="40"/>
          <uix:option text="41" value="41"/>
          <uix:option text="42" value="42"/>           
          <uix:option text="43" value="43"/>
          <uix:option text="44" value="44"/>                                                   
          <uix:option text="45" value="45"/>
          <uix:option text="46" value="46"/>
          <uix:option text="47" value="47"/>           
          <uix:option text="48" value="48"/>
          <uix:option text="49" value="49"/> 
          <uix:option text="50" value="50"/>
          <uix:option text="51" value="51"/>
          <uix:option text="52" value="52"/>           
          <uix:option text="53" value="53"/>
          <uix:option text="54" value="54"/>                                                   
          <uix:option text="55" value="55"/>
          <uix:option text="56" value="56"/>
          <uix:option text="57" value="57"/>           
          <uix:option text="58" value="58"/>
          <uix:option text="59" value="59"/> 
        </uix:contents> 
    </uix:choice>                 
    <uix:spacer width="5"/>
    <uix:radioButton textBinding="AM_LABEL@SDKUIResourceBundle"
                     name="startTime"
                     selectedValueBinding="startTime@defaultBean@servletRequest"
                     value="am"/>
    <uix:radioButton textBinding="PM_LABEL@SDKUIResourceBundle"
                     name="startTime"
                     selectedValueBinding="startTime@defaultBean@servletRequest"
                     value="pm"/>                    
--%>                     
     <uix:spacer width="2"/>    
      
    <uix:messageChoice promptBinding="INTERVAL@AutoTaskBundle"                   
                       styleClass="OraPromptText"
                       name="interval" 
                       id="interval" 
                       shortDescBinding="INTERVAL@AutoTaskBundle"
                       selectedValueBinding="interval@defaultBean@servletRequest">
        <uix:contents>
          <uix:option textBinding="HOURS_24@AutoTaskBundle" value="24"/>
          <uix:option textBinding="DAYS_7@AutoTaskBundle" value="7"/>                
          <uix:option textBinding="DAYS_31@AutoTaskBundle" value="31"/>                    
        </uix:contents> 
    </uix:messageChoice>    
      <uix:spacer width="2"/>    
    <uix:submitButton textBinding="GO@AutoTaskBundle" name="event" value="go" />
  </uix:rowLayout>  
      </uix:tableLayout>
      
      </uix:rowLayout>  
     </uix:tableLayout> 
      <uix:spacer width="50" />
      
  <uix:tableLayout>      
    <uix:rowLayout>
      <uix:table  width="100%"
                  name="autoTask"
                  columnFormatsBinding="autoTaskColFormats@defaultBean@servletRequest"
                  columnHeaderDataBinding="autoTaskColHeader@defaultBean@servletRequest" 
                  tableDataBinding="autoTaskList@defaultBean@servletRequest"
                  alternateTextBinding = "NO_ITEM_FOUND@AutoTaskBundle"
                  formSubmitted="true" 
                  summaryBinding="AUTOTASK@AutoTaskBundle" > 
         <uix:tableFormat tableBanding="rowBanding"/>
            <uix:columnHeaderStamp>                            
               <uix:sortableHeader textBinding="text" sortableBinding="sortable"/>
            </uix:columnHeaderStamp>              
            <uix:contents> 
              <uix:dataScope>
                <uix:switcher childNameBinding="showLink" >
                  <uix:case name="true">
                    <uix:link textBinding="task_name" destinationBinding="taskDest" />  
                  </uix:case>
                  <uix:default>
                   <uix:styledText textBinding="task_name" styleClass="OraPromptText"  />
                  </uix:default>
                </uix:switcher>
                 <uix:image sourceBinding="disabledImage@servletRequest" shortDescBinding="ENABLED_INSTR@AutoTaskBundle" renderedBinding="showDisabled"/>
              </uix:dataScope>
                <uix:include nodeBinding="time" /> 
            
            </uix:contents>                
                     
        </uix:table>                
    </uix:rowLayout>    
     <uix:rowLayout hAlign="right">
    <uix:flowLayout>
      <uix:image sourceBinding="leftImage@servletRequest" shortDescBinding="PREVIOUS@AutoTaskBundle" onClick="submitForm('autotaskForm', true, {'event':'prev'})" />
      <uix:spacer height="0" width="665" />
      <uix:image sourceBinding="rightImage@servletRequest" shortDescBinding="NEXT@AutoTaskBundle" onClick="submitForm('autotaskForm', true, {'event':'next'})"/>
      </uix:flowLayout>
    </uix:rowLayout>    
    <uix:rowLayout hAlign="right">
      <uix:flowLayout>      
        <uix:image sourceBinding="timeLine@servletRequest" shortDescBinding="TIME@AutoTaskBundle"/>
        <uix:spacer height="0" width="8" />
      </uix:flowLayout>
    </uix:rowLayout>
    <uix:rowLayout hAlign="right">
      <uix:flowLayout>      
        <uix:rawText textBinding="currentTime@servletRequest" /> 
        <uix:spacer height="0" width="5" />
      </uix:flowLayout>              
    </uix:rowLayout>        
  </uix:tableLayout>    
  
  
     <uix:tableLayout cellSpacing="8">        
        <uix:rowLayout hAlign="left">
          <uix:cellFormat>
              <uix:styledText textBinding="STATUS_LEGEND@AutoTaskBundle" styleClass="OraPromptText"/> 
          </uix:cellFormat>  
          <uix:cellFormat>          
            <uix:flowLayout>
               <uix:image sourceBinding="succeededImage@servletRequest" shortDescBinding="EXECUTED@AutoTaskBundle"/>
                <uix:spacer height="0" width="5" />
                <uix:styledText styleClass="OraInstructionText"
                                   textBinding="EXECUTED@AutoTaskBundle"/>
            </uix:flowLayout>                                   
          </uix:cellFormat>  
<%--          
          <uix:cellFormat>          
            <uix:flowLayout>
               <uix:image sourceBinding="failedImage@servletRequest" />
                <uix:spacer height="0" width="5" />
                <uix:styledText styleClass="OraInstructionText"
                                   textBinding="FAILED@AutoTaskBundle"/>
            </uix:flowLayout>                                   
          </uix:cellFormat>                   
--%>          
          <uix:cellFormat>          
            <uix:flowLayout>
               <uix:image sourceBinding="executedImage@servletRequest" shortDescBinding="ELAPSED_WINDOW@AutoTaskBundle" />
                <uix:spacer height="0" width="5" />
                <uix:styledText styleClass="OraInstructionText"
                                   textBinding="ELAPSED_WINDOW@AutoTaskBundle"/>
            </uix:flowLayout>                                   
          </uix:cellFormat>                                   
          <uix:cellFormat>          
            <uix:flowLayout>
               <uix:image sourceBinding="scheduledImage@servletRequest" shortDescBinding="SCHEDULED_WINDOW@AutoTaskBundle"/>
                <uix:spacer height="0" width="5" />
                <uix:styledText styleClass="OraInstructionText"
                                   textBinding="SCHEDULED_WINDOW@AutoTaskBundle"/>
            </uix:flowLayout>                                   
          </uix:cellFormat>                         
          
        </uix:rowLayout>
      </uix:tableLayout>        
  
        </uix:header>    
      </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>

</uix:renderingContext>

