<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ include file="/oemNoscript.jspf" %>

<uix:styleSheet/>
  <db:script src="/database/utils.js"/>
  <db:script src="/cabo/jsLibs/TableProxy.js"/>
  <db:script src="/database/LOV.js"/>
  <script>
    function winSelectAll(t, all)
    {
      var proxy = new TableProxy("window"); 
      for (var k=0; k<proxy.length; k++)
      {
        var selectedElement = proxy.getFormElement(t, k);
        if (selectedElement != null)
        {
          if (!selectedElement.disabled)
             selectedElement.checked = all;
          else
             break;
        }
      }        
    }
    
    function enableOrDisable()
    {
        bDisabled = eval(document.forms[0].enabled[1].checked);
        document.forms[0].optEnabled[0].disabled = bDisabled;
        document.forms[0].optEnabled[1].disabled = bDisabled;
        document.forms[0].segEnabled[0].disabled = bDisabled;
        document.forms[0].segEnabled[1].disabled = bDisabled;
        document.forms[0].sqlEnabled[0].disabled = bDisabled;
        document.forms[0].sqlEnabled[1].disabled = bDisabled;
        optDisabled = document.forms[0].optEnabled[1].checked || bDisabled;
        segDisabled = document.forms[0].segEnabled[1].checked || bDisabled;
        sqlDisabled = document.forms[0].sqlEnabled[1].checked || bDisabled;

        var proxy = new TableProxy("window");                  
        for (var k=1; k<proxy.length; k++)
        {
            var selectedElement = proxy.getFormElement("opt", k);
            if (selectedElement != null)
                selectedElement.disabled = optDisabled;
            selectedElement = proxy.getFormElement("seg", k);            
            if (selectedElement != null)
                selectedElement.disabled = segDisabled;
            selectedElement = proxy.getFormElement("sql", k);            
            if (selectedElement != null)
                selectedElement.disabled = sqlDisabled;    
        }
        
    }
  </script>

<uix:renderingContext id="renderingContext">  
  <oem:setURLEncoder id="renderingContext"/>
  
  <uix:bundle name="AutoTaskBundle" class="oracle.sysman.db.rsc.inst.AutoTaskMsg"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body onLoad="enableOrDisable()">
      <db:form name="configForm" method="POST" destination="autoTask" copyParams="target,type">          
      <uix:formValue name="pageName" value="/database/instance/autotask/config"/>      
      <uix:pageLayout> 
        <%@ include file="/database/global.jspf" %> 
       <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>        
       <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/> 
        <%-- 
        ---- Main Header
        --%>
        <uix:header textBinding="AUTOTASK_CONFIG@AutoTaskBundle">         
          <uix:tableLayout>
            <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                <uix:messagePrompt promptBinding="GLOBAL_SETTING@AutoTaskBundle" />      
               </uix:cellFormat>      
               <uix:cellFormat>         
                 <uix:radioButton name="enabled"
                          textBinding="ENABLED@AutoTaskBundle"
                          value="TRUE"
                          onClick="enableOrDisable()"
                          selectedValueBinding="enabled@defaultBean@servletRequest" />      
                  <uix:radioButton name="enabled"
                          textBinding="DISABLED@AutoTaskBundle"
                          value="FALSE"
                          onClick="enableOrDisable()"
                          selectedValueBinding="enabled@defaultBean@servletRequest" /> 
                </uix:cellFormat>                          
                </uix:rowLayout>
          </uix:tableLayout>
         <uix:header textBinding="TASK_LEVEL_SETTING@AutoTaskBundle">
          <uix:tableLayout>
            <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                <uix:styledText textBinding="OPT_STATS_GATHER@AutoTaskBundle" styleClass="OraPromptText"  />
               </uix:cellFormat>      
               <uix:cellFormat>         
                 <uix:radioButton name="optEnabled"
                          textBinding="ENABLED@AutoTaskBundle"
                          value="TRUE"
                          onClick="enableOrDisable()"
                          selectedValueBinding="optEnabled@defaultBean@servletRequest" />      
                  <uix:radioButton name="optEnabled"
                          textBinding="DISABLED@AutoTaskBundle"
                          value="FALSE"
                          onClick="enableOrDisable()"
                          selectedValueBinding="optEnabled@defaultBean@servletRequest" />                 
                </uix:cellFormat>   
                 <uix:spacer height="0" width="3" />
                 <uix:button textBinding="CONFIGURE@AutoTaskBundle"
                             destinationBinding="optLink@servletRequest"/>

                </uix:rowLayout>
<%-- comment out health_monitor                     
            <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                <uix:link textBinding="HEALTH_MONITOR@AutoTaskBundle" destinationBinding="healthLink@servletRequest" />                
               </uix:cellFormat>      
               <uix:cellFormat>         
                 <uix:radioButton name="healthEnabled"
                          textBinding="ENABLED@AutoTaskBundle"
                          value="TRUE"
                          selectedValueBinding="healthEnabled@defaultBean@servletRequest" />      
                  <uix:radioButton name="healthEnabled"
                          textBinding="DISABLED@AutoTaskBundle"
                          value="FALSE"
                          selectedValueBinding="healthEnabled@defaultBean@servletRequest" /> 
                </uix:cellFormat>                          
              </uix:rowLayout>
--%>              
            <uix:rowLayout>
              <uix:cellFormat hAlign="right">
              <%--
                <uix:link textBinding="SEGMENT_ADVISOR@AutoTaskBundle" destinationBinding="segLink@servletRequest" />                              
                                --%>
                <uix:styledText textBinding="SEGMENT_ADVISOR@AutoTaskBundle" styleClass="OraPromptText"  />
               </uix:cellFormat>      
               <uix:cellFormat>         
                 <uix:radioButton name="segEnabled"
                          textBinding="ENABLED@AutoTaskBundle"
                          value="TRUE"
                          onClick="enableOrDisable()"
                          selectedValueBinding="segEnabled@defaultBean@servletRequest" />      
                  <uix:radioButton name="segEnabled"
                          textBinding="DISABLED@AutoTaskBundle"
                          value="FALSE"
                          onClick="enableOrDisable()"
                          selectedValueBinding="segEnabled@defaultBean@servletRequest" /> 
                </uix:cellFormat>                          
              </uix:rowLayout>          
             <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                <uix:styledText textBinding="AUTO_SQL_TUNING@AutoTaskBundle" styleClass="OraPromptText"  />
               </uix:cellFormat>      
               <uix:cellFormat>         
                 <uix:radioButton name="sqlEnabled"
                          textBinding="ENABLED@AutoTaskBundle"
                          value="TRUE"
                          onClick="enableOrDisable()"
                          selectedValueBinding="sqlEnabled@defaultBean@servletRequest" />      
                  <uix:radioButton name="sqlEnabled"
                          textBinding="DISABLED@AutoTaskBundle"
                          value="FALSE"
                          onClick="enableOrDisable()"
                          selectedValueBinding="sqlEnabled@defaultBean@servletRequest" /> 
                </uix:cellFormat> 
                 <uix:spacer height="0" width="3" />
                 <uix:button textBinding="CONFIGURE@AutoTaskBundle"
                             destinationBinding="sqlLink@servletRequest"/>
              </uix:rowLayout>                              
          </uix:tableLayout>
         </uix:header> 
        <uix:header textBinding="MAIN_GRP_ASSIGN@AutoTaskBundle">
  <uix:tableLayout>      
    <uix:rowLayout hAlign="right">
        <uix:submitButton textBinding="EDIT_WIN_GROUP@AutoTaskBundle"
                          name="event" value="winEdit"/>
    </uix:rowLayout>

    <uix:rowLayout>
      <uix:table  width="100%"
                  name="window"
                  tableDataBinding="windowList@defaultBean@servletRequest"
                  alternateTextBinding = "NO_ITEM_FOUND@AutoTaskBundle"
                  formSubmitted="true" 
                  summaryBinding="WINDOW@AutoTaskBundle" > 
         <uix:tableFormat tableBanding="rowBanding"/>      
            <uix:column>
              <uix:columnFormat columnDataFormat="textFormat" width="100" />
              <uix:columnHeader>
               <uix:sortableHeader textBinding="WINDOW@AutoTaskBundle" sortableBinding="sortable"/>
              </uix:columnHeader>               
                <uix:contents>                               
                <uix:link textBinding="window" destinationBinding="windowDest" /> 
                </uix:contents>
            </uix:column>
            
            <uix:column>
              <uix:columnFormat columnDataFormat="iconButtonFormat" />
              <uix:columnHeader>
              <%--
                <uix:link textBinding="OPT_STATS_GATHER@AutoTaskBundle" destinationBinding="optLink@servletRequest"/>     
               --%>
               <uix:styledText textBinding="OPT_STATS_GATHER@AutoTaskBundle" styleClass="OraHeaderText"  />
              </uix:columnHeader> 
               <uix:contents>
               <uix:switcher childNameBinding="showLink" >
                  <uix:case name="TRUE">                  
                <uix:flowLayout>
                    <uix:link textBinding="SELECT_ALL@AutoTaskBundle" destination="javascript:winSelectAll('opt', true)" />   
                    <uix:spacer width="2"/>
                    <uix:styledText styleClass="OraInstructionText" text="|"/>
                    <uix:spacer width="2"/>
                    <uix:link textBinding="SELECT_NONE@AutoTaskBundle" destination="javascript:winSelectAll('opt', false)"/>  
                </uix:flowLayout>
                </uix:case>
                <uix:default>
               <uix:checkBox name="opt"  value="TRUE" shortDescBinding="OPT_STATS_GATHER@AutoTaskBundle" selectedValueBinding="opt"/>
                </uix:default>
              </uix:switcher>
              </uix:contents>
            </uix:column>
<%--  comment out health_monitor     
            <uix:column>
              <uix:columnFormat columnDataFormat="iconButtonFormat" />
              <uix:columnHeader>
                <uix:link textBinding="HEALTH_MONITOR@AutoTaskBundle" destinationBinding="healthLink@servletRequest"/>     
              </uix:columnHeader> 
               <uix:contents>
                <uix:switcher childNameBinding="showLink" >
                  <uix:case name="TRUE">                  
                <uix:flowLayout>
                    <uix:link text="Select All" destination="javascript:winSelectAll('health', true)" />   
                    <uix:spacer width="2"/>
                    <uix:styledText styleClass="OraInstructionText" text="|"/>
                    <uix:spacer width="2"/>
                    <uix:link text="Select None" destination="javascript:winSelectAll('health', false)"/>  
                </uix:flowLayout>
                </uix:case>
                <uix:default>
               <uix:checkBox name="health"  value="TRUE" selectedValueBinding="health"/>
                </uix:default>
              </uix:switcher>
              </uix:contents>
            </uix:column>
--%>
            <uix:column>
              <uix:columnFormat columnDataFormat="iconButtonFormat" />
              <uix:columnHeader>
              <%--
                <uix:link textBinding="SEGMENT_ADVISOR@AutoTaskBundle" destinationBinding="segLink@servletRequest"/>     
               --%>
               <uix:styledText textBinding="SEGMENT_ADVISOR@AutoTaskBundle" styleClass="OraHeaderText"  />
             </uix:columnHeader> 
               <uix:contents>
               <uix:switcher childNameBinding="showLink" >
                  <uix:case name="TRUE">                  
                <uix:flowLayout>
                    <uix:link textBinding="SELECT_ALL@AutoTaskBundle" destination="javascript:winSelectAll('seg', true)" />   
                    <uix:spacer width="2"/>
                    <uix:styledText styleClass="OraInstructionText" text="|"/>
                    <uix:spacer width="2"/>
                    <uix:link textBinding="SELECT_NONE@AutoTaskBundle" destination="javascript:winSelectAll('seg', false)"/>  
                </uix:flowLayout>
                </uix:case>
                <uix:default>
               <uix:checkBox name="seg"  value="TRUE" shortDescBinding="SEGMENT_ADVISOR@AutoTaskBundle" selectedValueBinding="seg"/>
                </uix:default>
              </uix:switcher>
              </uix:contents>
            </uix:column>

            <uix:column>
              <uix:columnFormat columnDataFormat="iconButtonFormat" />
              <uix:columnHeader>
              <%--
                <uix:link textBinding="AUTO_SQL_TUNING@AutoTaskBundle" destinationBinding="sqlLink@servletRequest"/>     
                --%>                
                <uix:styledText textBinding="AUTO_SQL_TUNING@AutoTaskBundle" styleClass="OraHeaderText"  />
              </uix:columnHeader> 
               <uix:contents>
               <uix:switcher childNameBinding="showLink" >
                  <uix:case name="TRUE">                  
                <uix:flowLayout>
                    <uix:link textBinding="SELECT_ALL@AutoTaskBundle" destination="javascript:winSelectAll('sql', true)" />   
                    <uix:spacer width="2"/>
                    <uix:styledText styleClass="OraInstructionText" text="|"/>
                    <uix:spacer width="2"/>
                    <uix:link textBinding="SELECT_NONE@AutoTaskBundle" destination="javascript:winSelectAll('sql', false)"/>  
                </uix:flowLayout>
                </uix:case>
                <uix:default>
               <uix:checkBox name="sql"  value="TRUE" shortDescBinding="AUTO_SQL_TUNING@AutoTaskBundle" selectedValueBinding="sql"/>
               
                </uix:default>
              </uix:switcher>
              </uix:contents>
            </uix:column>
        </uix:table>                
    </uix:rowLayout>    
    </uix:tableLayout>
        </uix:header> 
<%--        
      <uix:hideShowHeader id="hideShowOptions"
                    textBinding="optionsText@defaultBean@servletRequest"
                    disclosedBinding="hideOptions@defaultBean@servletRequest"
                    formSubmitted="true">                    
      <uix:table  width="100%"
                  name="option"
                  tableDataBinding="optionList@defaultBean@servletRequest"
                  alternateTextBinding = "NO_ITEM_FOUND@AutoTaskBundle"
                  formSubmitted="true" 
                  summaryBinding="SHOW_ADV_OPTS@AutoTaskBundle" >         
            <uix:column>
              <uix:columnFormat columnDataFormat="textFormat" width="150" cellNoWrapFormat="true"/>
              <uix:columnHeader  >
                <uix:messagePrompt prompt="" />
              </uix:columnHeader>               
                <uix:contents>         
                  <uix:styledText styleClass="OraFieldText" 
                         textBinding="title" />
                </uix:contents>
            </uix:column>
            
            <uix:column>
              <uix:columnFormat columnDataFormat="textFormat" />
              <uix:columnHeader>
                <uix:link textBinding="OPT_STATS_GATHER@AutoTaskBundle" destinationBinding="optLink@servletRequest"/>     
              </uix:columnHeader> 
               <uix:contents>
               <uix:switcher childNameBinding="showResource" >
                 <uix:case name="TRUE">       
                  <uix:textInput name="optRsc"
                                 textBinding="optRsc"  columns="30" />
                </uix:case>
                <uix:default>
                   <uix:messageLovField
                              name="optService"
                              textBinding="optService"                            
                              onClick="startLov('option:optService:1', 'ListService')"/>
                </uix:default>
              </uix:switcher>
              </uix:contents>
            </uix:column>
            
--  comment out health_monitor                 
            <uix:column>
              <uix:columnFormat columnDataFormat="textFormat" />
              <uix:columnHeader>
                <uix:link textBinding="HEALTH_MONITOR@AutoTaskBundle" destinationBinding="healthLink@servletRequest"/>     
              </uix:columnHeader> 
               <uix:contents>
               <uix:switcher childNameBinding="showResource" >
                 <uix:case name="TRUE">       
                  <uix:textInput name="healthRsc"
                                 textBinding="healthRsc"  columns="20" />                                 
                </uix:case>
                <uix:default>
                   <uix:messageLovField
                              name="healthService"
                              textBinding="healthService"
                              onClick="startLov('option:healthService:1', 'ListService')" columns="15" />
                </uix:default>
              </uix:switcher>
              </uix:contents>
            </uix:column>

            <uix:column>
              <uix:columnFormat columnDataFormat="textFormat" />
              <uix:columnHeader>
                <uix:link textBinding="SEGMENT_ADVISOR@AutoTaskBundle" destinationBinding="segLink@servletRequest"/>     
              </uix:columnHeader> 
               <uix:contents>
               <uix:switcher childNameBinding="showResource" >
                 <uix:case name="TRUE">       
                  <uix:textInput name="segRsc"
                                 textBinding="segRsc"  columns="20" />
                </uix:case>
                <uix:default>
                   <uix:messageLovField
                              name="segService"
                              textBinding="segService"
                              onClick="startLov('option:segService:1', 'ListService')"  columns="15" />
                </uix:default>
              </uix:switcher>
              </uix:contents>
            </uix:column>
            
  <uix:column>
              <uix:columnFormat columnDataFormat="textFormat" />
              <uix:columnHeader>
                <uix:link textBinding="AUTO_SQL_TUNING@AutoTaskBundle" destinationBinding="sqlLink@servletRequest"/>     
              </uix:columnHeader> 
               <uix:contents>
               <uix:switcher childNameBinding="showResource" >
                 <uix:case name="TRUE">       
                  <uix:textInput name="sqlRsc"
                                 textBinding="sqlRsc"  columns="30" />
                </uix:case>
                <uix:default>
                   <uix:messageLovField
                              name="sqlService"
                              textBinding="sqlService"
                              onClick="startLov('option:sqlService:1', 'ListService')"  columns="25" />
                </uix:default>
              </uix:switcher>
              </uix:contents>
            </uix:column>            
        </uix:table>
        <uix:spacer height="15"/>                                 
          <uix:tip textBinding="RSC_TOTAL@AutoTaskBundle"/> 
        <uix:spacer height="15"/>    
         
        
      </uix:hideShowHeader> 
--%>                  
        </uix:header> 
        
        <uix:pageButtons>
          <uix:pageButtonBar>
            <jsp:include page="/database/schema/pageButtonInclude.jsp" />
            <uix:ref refID="pageButtonInclude" />
          </uix:pageButtonBar>
        </uix:pageButtons>
  
      </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>

</uix:renderingContext>

