<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">  
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="AutoTaskBundle" class="oracle.sysman.db.rsc.inst.AutoTaskMsg"/>
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <db:form name="schedulerForm" method="POST" destination="autoTask" copyParams="target,type,pageName">
      <uix:pageLayout> 
        <%@ include file="/database/global.jspf" %> 
       <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>        
       <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/> 
        <%-- 
        ---- Main Header
        --%>
        <uix:header textBinding="SCHEDULER_CENTRAL@AutoTaskBundle">
          <%@ include file="../refreshTime.jspf" %>   
          
          <uix:header textBinding="SCHEDULERS@AutoTaskBundle">
            <uix:tableLayout  cellSpacing="5">  
              <uix:rowLayout width="100%" >             
                <uix:cellFormat hAlign="left" vAlign="top" width="33%">
                <uix:stackLayout>
                  <uix:link textBinding="ORACLE_SCHEDULER@AutoTaskBundle" destinationBinding="schedulerDest@servletRequest" />   
                  <uix:styledText styleClass="OraInlineInfoText" textBinding="ORACLE_SCHEDULER_NOTE@AutoTaskBundle" />   
                </uix:stackLayout>  
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" vAlign="top" width="34%">
                <uix:stackLayout>
                  <uix:link textBinding="JOBS@AutoTaskBundle" destinationBinding="jobDest@servletRequest" />   
                  <uix:styledText styleClass="OraInlineInfoText" textBinding="JOBS_NOTE@AutoTaskBundle" />   
                </uix:stackLayout>  
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" vAlign="top" width="33%">
                <uix:stackLayout>
                  <uix:link textBinding="AUTOTASK@AutoTaskBundle" destinationBinding="autoDest@servletRequest" />   
                  <uix:styledText styleClass="OraInlineInfoText" textBinding="AUTO_TASK_NOTE@AutoTaskBundle" />   
                </uix:stackLayout>  
                </uix:cellFormat>
               </uix:rowLayout>    
            </uix:tableLayout>      
          </uix:header>
          <uix:header textBinding="SCHEDULER_TASK@AutoTaskBundle">   
            <uix:messagePrompt promptBinding="VIEW@AutoTaskBundle" labeledNodeId="schedulerType"/> 
            <uix:choice id="schedulerType" name="schedulerType"
                        onChange="submitForm('schedulerForm', true, {'event':'changeType'})"                        
                        selectedValueBinding="schedulerType@defaultBean@servletRequest"                                
                        shortDescBinding="TYPE@AutoTaskBundle">
              <uix:contents childDataBinding="schedulerList@defaultBean@servletRequest">
                 <uix:option textBinding="stext" valueBinding="sval"/>
              </uix:contents>
            </uix:choice>  
            
            <uix:tableLayout  width="100%">
             <uix:rowLayout>
             
             <uix:switcher childNameBinding="schedulerType@defaultBean@servletRequest">                 
               <uix:case name="0"> 
                 <uix:table  width="100%"
                           name="job"
                           tableDataBinding="jobList@defaultBean@servletRequest"
                           columnFormatsBinding="jobColFormats@defaultBean@pageContext"
                           columnHeaderDataBinding="jobColHeader@defaultBean@servletRequest" 
                           alternateTextBinding = "NO_ITEM_FOUND@AutoTaskBundle"
                           blockSizeBinding="jobBlockSize@defaultBean@servletRequest"
                           valueBinding="jobValue@defaultBean@servletRequest" 
                           minValueBinding="jobMinValue@defaultBean@servletRequest" 
                           maxValueBinding="jobMaxValue@defaultBean@servletRequest"
                           formSubmitted="true"
                           summaryBinding="SCHEDULER_TASK@AutoTaskBundle"> 
                   <uix:tableFormat tableBanding="rowBanding"/>
                  
                   <uix:columnHeaderStamp>
                     <uix:sortableHeader textBinding="text" sortableBinding="sortable"/>
                   </uix:columnHeaderStamp>                   
                   <uix:contents>   
                      <uix:link textBinding="name" destinationBinding="jobDest" />                        
                     <uix:styledText textBinding="owner" />              
                      <uix:styledText textBinding="type" />
                      <uix:styledText textBinding="state" /> 
                      <uix:switcher childNameBinding="winLink">                 
                      <uix:case name="">             
                         <uix:styledText textBinding="scheduledDate" />                      
                      </uix:case>
                      <uix:default>
                         <uix:styledText textBinding="scheduledDate" destinationBinding="winLink"/>                      
                      </uix:default>
                     </uix:switcher>     
                   </uix:contents>
                 </uix:table>    
                </uix:case>                  
                <uix:default>
                 <uix:table  width="100%"
                           name="job"
                           tableDataBinding="jobList@defaultBean@servletRequest"
                           columnFormatsBinding="jobColFormats@defaultBean@pageContext"
                           columnHeaderDataBinding="jobColHeader@defaultBean@servletRequest" 
                           alternateTextBinding = "NO_ITEM_FOUND@AutoTaskBundle"
                           blockSizeBinding="jobBlockSize@defaultBean@servletRequest"
                           valueBinding="jobValue@defaultBean@servletRequest" 
                           minValueBinding="jobMinValue@defaultBean@servletRequest" 
                           maxValueBinding="jobMaxValue@defaultBean@servletRequest"
                           formSubmitted="true"
                           summaryBinding="SCHEDULER_TASK@AutoTaskBundle"> 
                   <uix:tableFormat tableBanding="rowBanding"/>
                  
                   <uix:columnHeaderStamp>
                     <uix:sortableHeader textBinding="text" sortableBinding="sortable"/>
                   </uix:columnHeaderStamp>                   
                   <uix:contents>                       
                     <uix:link textBinding="name" destinationBinding="jobDest" />                        
                     <uix:styledText textBinding="owner" />   
                     <uix:styledText textBinding="state" /> 
                     <uix:switcher childNameBinding="winLink">                          
                      <uix:case name="">             
                         <uix:styledText textBinding="scheduledDate" />                      
                      </uix:case>
                      <uix:default>
                         <uix:styledText textBinding="scheduledDate" destinationBinding="winLink"/>                      
                      </uix:default>
                     </uix:switcher>     
                   </uix:contents>
                 </uix:table>                    
                </uix:default>
                </uix:switcher>
                </uix:rowLayout>
              </uix:tableLayout>                 
          </uix:header>
        </uix:header>    
      </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>

                 
</uix:renderingContext>

