<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="DBMsg"  class="oracle.sysman.db.rsc.inst.DBMsg"/>

  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <db:form name="awrReportForm" method="POST" 
        destination="/console/database/instance/awrBaselineReport"
        copyParams="target,type,oid">
  
        <uix:pageLayout titleBinding="reportHeader@baselineDetailsBean@servletRequest">
          <%@ include file="/database/global.jspf" %>
      
          <oem:messageBox messageType="error" 
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="info" 
                          errorTableBinding="info@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>     
      
          <uix:subTabLayout>
            <uix:subTabs>
              <uix:subTabBar selectedIndex="1">
                  <uix:link textBinding="DETAILS@DBMsg"
                        destinationBinding="detailsLink@servletRequest" />
                  <uix:link textBinding="REPORT@DBMsg" />
              </uix:subTabBar>
            </uix:subTabs>
      
      
            <uix:tableLayout width="100%" renderedBinding="noErrors@baselineDetailsBean@servletRequest">
              <uix:rowLayout hAlign="right">  
                <uix:submitButton textBinding="SAVE_TO_FILE@DBMsg" 
                    name="event" value="saveToFile" />
               </uix:rowLayout>
            </uix:tableLayout>
      
            <uix:tableLayout width="100%" renderedBinding="noErrors@baselineDetailsBean@servletRequest" >
              <uix:rawText textBinding="awrReport@baselineDetailsBean@servletRequest" /> 
            </uix:tableLayout>
        
      
          </uix:subTabLayout>
        </uix:pageLayout>
      </db:form>	
    </uix:body>
  </uix:document>
</uix:renderingContext>

