<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        baselineEdit.jsp
  -- Controller:  db/adm/inst/BaselineController.java
  --
  -- Description: Page for editing the baselines
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.adm.instance.baseline.BaselineConst" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="DBObjectMsg"  class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="DBMsg"  class="oracle.sysman.db.rsc.inst.DBMsg"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    
    <%-- HTML Page Title --%>
  
    <uix:body>
      <%-- HTML Form --%>
      <db:form name="bslnEditForm"
               method="post"              
               destination="awrBaseline"
               copyParams="target,type,cancelURL,oid">
      <uix:formValue name="pageName" value="<%= BaselineConst.BSLN_EDIT_PG %>"/>
        <uix:pageLayout titleBinding="editHeader@baselineBean@servletRequest">
        
          <%-- Oracle Logo and Tabs --%>
          <%@ include file="/database/global.jspf" %>
        
          <%-- Warning/Error display --%>
          <oem:messageBox messageType="info" 
                          errorTableBinding="info@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error" 
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>

          <%-- START: Edit baseline contents starts here --%>   

          <%-- General --%>
          <uix:header textBinding="GENERAL@DBMsg">
            <uix:spacer height="5"/>
            <uix:tableLayout>
              <uix:rowLayout >
                <uix:cellFormat hAlign="right"> 
                  <uix:styledText labeledNodeId="BaselineNameId"
                                  styleClass="OraPromptText" 
                                  textBinding="BSLN_EDIT_NAME@DBMsg"/>
                </uix:cellFormat>
                <uix:spacer width="5"/>
                <uix:cellFormat hAlign="left">
                  <uix:switcher childNameBinding="baselineTypeID@baselineDetailsBean@servletRequest"
                                defaultCase="defCase">
                    <uix:case name="defCase">
                      <uix:textInput name="baselineName" 
                                     id="BaselineNameId"
                                     columns="20"
                                     textBinding="baselineName@baselineDetailsBean@servletRequest"/>
                    </uix:case>
                    <uix:case name="<%= BaselineConst.BSLN_TYPE_MW %>">
                      <uix:styledText styleClass="OraDataText" 
                                      id="BaselineNameId"
                                      textBinding="baselineName@baselineDetailsBean@servletRequest"/>
                    </uix:case>
                  </uix:switcher>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout >
                <uix:cellFormat hAlign="right"> 
                  <uix:styledText
                                  styleClass="OraPromptText" 
                                  textBinding="BSLN_ID@DBMsg"/>
                </uix:cellFormat>
                <uix:spacer width="5"/>
                <uix:cellFormat hAlign="left">
                  <uix:styledText styleClass="OraDataText" 
                                  textBinding="baselineID@baselineDetailsBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout >
                <uix:cellFormat hAlign="right"> 
                  <uix:styledText
                                  styleClass="OraPromptText" 
                                  textBinding="BSLN_TYPE@DBMsg"/>
                </uix:cellFormat>
                <uix:spacer width="5"/>
                <uix:cellFormat hAlign="left">
                  <uix:styledText styleClass="OraDataText" 
                                  textBinding="baselineType@baselineDetailsBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:switcher childNameBinding="baselineTypeID@baselineDetailsBean@servletRequest">
                <uix:case name="<%= BaselineConst.BSLN_TYPE_STATIC %>">
                  <uix:rowLayout >
                    <uix:cellFormat hAlign="right"> 
                      <uix:styledText
                                      styleClass="OraPromptText" 
                                      textBinding="BSLN_CREATE_TIME@DBMsg"/>
                    </uix:cellFormat>
                    <uix:spacer width="5"/>
                    <uix:cellFormat hAlign="left">
                      <uix:styledText styleClass="OraDataText" 
                                      textBinding="creationTimeSB@baselineDetailsBean@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:case>
              </uix:switcher>
              <uix:switcher childNameBinding="baselineTypeID@baselineDetailsBean@servletRequest">
                <uix:case name="<%= BaselineConst.BSLN_TYPE_MW %>">
                  <uix:rowLayout >
                    <uix:cellFormat hAlign="right"> 
                      <uix:styledText
                                      styleClass="OraPromptText" 
                                      textBinding="BSLN_AT_ENABLE@DBMsg"/>
                    </uix:cellFormat>
                    <uix:spacer width="5"/>
                    <uix:cellFormat hAlign="left">
                      <uix:styledText styleClass="OraDataText" 
                                      textBinding="ATEnableSB@baselineDetailsBean@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:case>
              </uix:switcher>
              <uix:switcher childNameBinding="baselineTypeID@baselineDetailsBean@servletRequest">
                <uix:case name="<%= BaselineConst.BSLN_TYPE_MW %>">
                  <uix:rowLayout >
                    <uix:cellFormat hAlign="right"> 
                      <uix:styledText labeledNodeId="WindowSizeId"
                                      styleClass="OraPromptText" 
                                      textBinding="BSLN_WINDOW_SIZE@DBMsg"/>
                    </uix:cellFormat>
                    <uix:spacer width="5"/>
                    <uix:cellFormat hAlign="left">
                      <uix:textInput name="MWSize" 
                                     id="WindowSizeId"
                                     columns="20"
                                     textBinding="MWSize@baselineDetailsBean@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:case>
              </uix:switcher>
              <uix:switcher childNameBinding="baselineTypeID@baselineDetailsBean@servletRequest">
                <uix:case name="<%= BaselineConst.BSLN_TYPE_GENERATED %>">
                  <uix:rowLayout >
                    <uix:cellFormat hAlign="right"> 
                      <uix:styledText
                                      styleClass="OraPromptText" 
                                      textBinding="BSLN_TEMPLATE@DBMsg"/>
                    </uix:cellFormat>
                    <uix:spacer width="5"/>
                    <uix:cellFormat hAlign="left">
                      <uix:styledText styleClass="OraDataText" 
                                      textBinding="template@baselineDetailsBean@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:case>
              </uix:switcher>
            </uix:tableLayout>
          </uix:header>


          <%-- Validity --%>
          <uix:header textBinding="BSLN_VALIDITY@DBMsg">
            <uix:spacer height="5"/>
            <uix:tableLayout>
              <uix:rowLayout >
                <uix:cellFormat hAlign="right"> 
                  <uix:styledText
                                  styleClass="OraPromptText" 
                                  textBinding="BSLN_SHUTDOWN@DBMsg"/>
                </uix:cellFormat>
                <uix:spacer width="5"/>
                <uix:cellFormat hAlign="left">
                  <uix:styledText styleClass="OraDataText" 
                                  textBinding="shutDown@baselineDetailsBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout >
                <uix:cellFormat hAlign="right"> 
                  <uix:styledText
                                  styleClass="OraPromptText" 
                                  textBinding="BSLN_PCT_TOTAL_TIME@DBMsg"/>
                </uix:cellFormat>
                <uix:spacer width="5"/>
                <uix:cellFormat hAlign="left">
                  <uix:styledText styleClass="OraDataText" 
                                  textBinding="pctTotalTime@baselineDetailsBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout >
                <uix:cellFormat hAlign="right"> 
                  <uix:styledText
                                  styleClass="OraPromptText" 
                                  textBinding="BSLN_ERROR_COUNT@DBMsg"/>
                </uix:cellFormat>
                <uix:spacer width="5"/>
                <uix:cellFormat hAlign="left">
                  <uix:styledText styleClass="OraDataText" 
                                  textBinding="errorCount@baselineDetailsBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
          </uix:header>

          <%-- Time Interval --%>
          <uix:header textBinding="BSLN_TIME_INTERVAL@DBMsg">
            <uix:spacer height="5"/>
            <uix:tableLayout>
              <uix:rowLayout >
                <uix:cellFormat hAlign="right"> 
                  <uix:styledText
                                  styleClass="OraPromptText" 
                                  textBinding="BSLN_START_SNAP_TIME@DBMsg"/>
                </uix:cellFormat>
                <uix:spacer width="5"/>
                <uix:cellFormat hAlign="left">
                  <uix:styledText styleClass="OraDataText" 
                                  textBinding="startSnapTimeSB@baselineDetailsBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout >
                <uix:cellFormat hAlign="right"> 
                  <uix:styledText
                                  styleClass="OraPromptText" 
                                  textBinding="BSLN_END_SNAP_TIME@DBMsg"/>
                </uix:cellFormat>
                <uix:spacer width="5"/>
                <uix:cellFormat hAlign="left">
                  <uix:styledText styleClass="OraDataText" 
                                  textBinding="endSnapTimeSB@baselineDetailsBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout >
                <uix:cellFormat hAlign="right"> 
                  <uix:styledText
                                  styleClass="OraPromptText" 
                                  textBinding="BSLN_START_SNAP_ID@DBMsg"/>
                </uix:cellFormat>
                <uix:spacer width="5"/>
                <uix:cellFormat hAlign="left">
                  <uix:styledText styleClass="OraDataText" 
                                  textBinding="startSnapID@baselineDetailsBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout >
                <uix:cellFormat hAlign="right"> 
                  <uix:styledText
                                  styleClass="OraPromptText" 
                                  textBinding="BSLN_END_SNAP_ID@DBMsg"/>
                </uix:cellFormat>
                <uix:spacer width="5"/>
                <uix:cellFormat hAlign="left">
                  <uix:styledText styleClass="OraDataText" 
                                  textBinding="endSnapID@baselineDetailsBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
          </uix:header>
 
          <%-- END: Edit baseline contents ends here --%>   
                
          <%-- Revert/Apply Button --%>
          <uix:pageButtons>
            <uix:pageButtonBar>
          
              <%-- Cancel BUTTON --%>
              <uix:submitButton textBinding="REVERT@DBObjectMsg" 
                                shortDescBinding="REVERT@DBObjectMsg" 
                                name="event" 
                                value="<%= BaselineConst.REVERT %>" />
           
              <%-- Finish BUTTON --%>
              <uix:submitButton textBinding="APPLY@DBObjectMsg" 
                                shortDescBinding="APPLY@DBObjectMsg" 
                                name="event" 
                                value="<%= BaselineConst.APPLY %>" />
          
            </uix:pageButtonBar>
          </uix:pageButtons>
        
        </uix:pageLayout>
      </db:form>
      <%-- END: HTML Form --%>
    </uix:body>
  
  </uix:document>
</uix:renderingContext>
<%-- END: Content --%> 
