<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        baselineIntervalType.jsp
  -- Controller:  db/adm/inst/BaselineController.java
  --
  -- Description: Page for defining the baseline interval type, the first step of
  --              creating a baseline.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.adm.instance.baseline.BaselineConst" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="DBMsg"  class="oracle.sysman.db.rsc.inst.DBMsg"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    
    <%-- HTML Page Title --%>
  
    <uix:body>
      <%-- HTML Form --%>
      <db:form name="bslnC1Form"
               method="get"              
               destination="awrBaseline"
               copyParams="target,type,cancelURL">
      <uix:formValue name="pageName" value="<%= BaselineConst.BSLN_INTEVAL_TYPE_PG %>"/>
        <uix:pageLayout titleBinding="BSLN_CREATE_STEP1@DBMsg">
        
          <%-- Oracle Logo and Tabs --%>
          <%@ include file="/database/global.jspf" %>
        
          <%-- Warning/Error display --%>
          <oem:messageBox messageType="info" 
                          errorTableBinding="info@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error" 
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
        
          <%-- START: Baseline Interval type contents starts here --%>
          <uix:stackLayout>
             <uix:spacer height="5"/>
                <uix:styledText styleClass="OraInstructionText"
                                textBinding="BSLN_INTVL_TIP@DBMsg" 
                                labeledNodeId="intervalTypeId"/>
             <%-- Single --%>
             <oem:radioButton name="intervalTypeSB"
                              id="intervalTypeSBId"
                              textBinding="BSLN_INTVL_SINGLE@DBMsg"
                              value="<%= BaselineConst.TEMPLATE_TYPE_SINGLE %>"
     			      shortDescBinding="BSLN_INTVL_SINGLE@DBMsg"
			      styleClass="OraInstructionText"
                              selectedValueBinding="intervalTypeSB@baselineBean@servletRequest" />
             <uix:flowLayout>
               <uix:spacer width="20" height="1" />
               <uix:styledText styleClass="OraTipText"
                                textBinding="BSLN_INTVL_SINGLE_TIP@DBMsg" />
               <uix:spacer height="5"/>
             </uix:flowLayout>
             
             <%-- Repeating --%>
             <oem:radioButton name="intervalTypeSB"
                              id="intervalTypeSBId"
                              textBinding="BSLN_INTVL_REPEATING@DBMsg"
                              value="<%= BaselineConst.TEMPLATE_TYPE_REPEATING %>"
                              shortDescBinding="BSLN_INTVL_REPEATING@DBMsg"
                              styleClass="OraInstructionText"
                              selectedValueBinding="intervalTypeSB@baselineBean@servletRequest" />
             <uix:flowLayout>
               <uix:spacer width="20" height="1" />
               <uix:styledText styleClass="OraTipText"
                                textBinding="BSLN_INTVL_REPEATING_TIP@DBMsg" />
               <uix:spacer height="5"/>
             </uix:flowLayout>
         
             <%-- Moving Window --%>
<%-- Moving window is automatically created by the server.
             <oem:radioButton name="intervalType"
                              textBinding="BSLN_INTVL_MW@DBMsg"
                              value="<%= BaselineConst.INTVL_MW %>"
                              selectedValueBinding="intervalType@baselineBean@servletRequest" />
             <uix:flowLayout>
               <uix:spacer width="20" height="1" />
               <uix:styledText styleClass="OraTipText"
                                textBinding="BSLN_INTVL_MW_TIP@DBMsg" />
               <uix:spacer height="5"/>
             </uix:flowLayout>
--%>
        
        
          </uix:stackLayout>
          <%-- END: Baseline Interval type contents ends here --%>   
                
          <%-- Cancel/Continue Button --%>
          <uix:pageButtons>
            <uix:pageButtonBar>
          
              <%-- CancelL BUTTON --%>
              <uix:submitButton textBinding="CANCEL@DBMsg" 
                                shortDescBinding="CANCEL@DBMsg" 
                                name="event" 
                                value="<%= BaselineConst.CANCEL %>" />
          
              <%-- Continue BUTTON --%>
              <uix:submitButton textBinding="CONTINUE@DBMsg" 
                                shortDescBinding="CONTINUE@DBMsg" 
                                name="event" 
                                value="<%= BaselineConst.INTVL_CONTINUE %>" />
          
            </uix:pageButtonBar>
          </uix:pageButtons>
        
        </uix:pageLayout>
      </db:form>
      <%-- END: HTML Form --%>
    </uix:body>
  
  </uix:document>
</uix:renderingContext>
<%-- END: Content --%> 
