<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<uix:bundle name="DBMsg"  class="oracle.sysman.db.rsc.inst.DBMsg"/>
<oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <db:form name="foo" method="POST" destination="/console/database/instance/awrBaselines"
      copyParams="target,type">

    <uix:pageLayout>
    <%@ include file="/database/global.jspf" %>

    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>     

    <uix:header textBinding="CREATE_STS@DBMsg">
    
    
      <uix:labeledFieldLayout fieldWidth="100%" labelWidth="0" columns="1" >
        <uix:cellFormat wrappingDisabled="true" hAlign="right">
          <uix:messagePrompt promptBinding="BASELINE_ID@DBMsg" />
        </uix:cellFormat>
        <uix:styledText styleClass="OraDataText" 
          textBinding="baselineID@baselinesBean@servletRequest" />
        <uix:cellFormat wrappingDisabled="true" hAlign="right">
          <uix:messagePrompt promptBinding="NAME@DBMsg" />
        </uix:cellFormat>
        <uix:styledText styleClass="OraDataText" 
          textBinding="baselineName@baselinesBean@servletRequest" />
        <uix:cellFormat wrappingDisabled="true" hAlign="right">
          <uix:messagePrompt promptBinding="BEGIN_SNAP_CAPTURE_TIME@DBMsg" />
        </uix:cellFormat>
        <uix:styledText styleClass="OraDataText" 
          textBinding="beginSnapshotTime@baselinesBean@servletRequest" />
        <uix:cellFormat wrappingDisabled="true" hAlign="right">
          <uix:messagePrompt promptBinding="END_SNAP_CAPTURE_TIME@DBMsg" />
        </uix:cellFormat>
        <uix:styledText styleClass="OraDataText" 
          textBinding="endSnapshotTime@baselinesBean@servletRequest" />
            
     </uix:labeledFieldLayout>

      <uix:spacer height="30" />


      <uix:labeledFieldLayout labelWidth="0" fieldWidth="100%" columns="1">
        <uix:cellFormat wrappingDisabled="true" hAlign="right">
          <uix:messagePrompt promptBinding="NAME@DBMsg" 
             labeledNodeId="stsNameId"
             required="yes"  />
        </uix:cellFormat>
           <uix:textInput name="stsName" id="stsNameId"
            textBinding="stsName@baselinesBean@servletRequest" />
        <uix:cellFormat wrappingDisabled="true" hAlign="right">
          <uix:messagePrompt promptBinding="DESCRIPTION@DBMsg" 
            labeledNodeId="stsDescId"  />
        </uix:cellFormat>
           <uix:textInput name="description" id="stsDescId"
            textBinding="description@baselinesBean@servletRequest"  />
     </uix:labeledFieldLayout>

     
    </uix:header>

        <uix:pageButtons>
        <uix:pageButtonBar>
         <uix:flowLayout >
            <uix:button textBinding="CANCEL@DBMsg"
              destinationBinding="cancelURL@servletRequest" />
            <uix:submitButton textBinding="OK@DBMsg"
              name="event" 
              value="doCreateSTS"/>
          </uix:flowLayout>
        </uix:pageButtonBar>
        </uix:pageButtons>



    </uix:pageLayout>
    </db:form>    
    </uix:body>

  </uix:document>
</uix:renderingContext>

